/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.jdbc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mentabean.BeanConfig;
import org.mentabean.BeanException;
import org.mentabean.BeanManager;
import org.mentabean.BeanSession;
import org.mentabean.DBField;
import org.mentabean.DBType;
import org.mentabean.event.TriggerDispatcher;
import org.mentabean.event.TriggerEvent;
import org.mentabean.event.TriggerListener;
import org.mentabean.jdbc.QueryBuilder;
import org.mentabean.sql.TableAlias;
import org.mentabean.type.AutoIncrementType;
import org.mentabean.type.AutoTimestampType;
import org.mentabean.type.NowOnInsertAndUpdateTimestampType;
import org.mentabean.type.NowOnInsertTimestampType;
import org.mentabean.type.NowOnUpdateTimestampType;
import org.mentabean.type.SizedType;
import org.mentabean.util.InjectionUtils;
import org.mentabean.util.Limit;
import org.mentabean.util.OrderBy;
import org.mentabean.util.PropertiesProxy;
import org.mentabean.util.SQLUtils;

public class AnsiSQLBeanSession
implements BeanSession {
    protected static boolean DEBUG = false;
    protected static boolean DEBUG_NATIVE = false;
    protected IdentityHashMap<Object, Map<String, Value>> loaded = new IdentityHashMap();
    protected Connection conn;
    protected final BeanManager beanManager;
    protected final TriggerDispatcher dispatcher = new TriggerDispatcher();

    public AnsiSQLBeanSession(BeanManager beanManager, Connection conn) {
        this.beanManager = beanManager;
        this.conn = conn;
    }

    public static void debugSql(boolean b) {
        DEBUG = b;
    }

    public static void debugNativeSql(boolean b) {
        DEBUG_NATIVE = b;
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    protected String getCurrentTimestampCommand() {
        return null;
    }

    protected Object getValueFromBean(Object bean, String fieldName) {
        return this.getValueFromBean(bean, fieldName, null);
    }

    public static String[] getProperties(Object[] names) {
        if (names != null) {
            for (Object o : names) {
                if (!(o instanceof String)) continue;
                PropertiesProxy.addPropertyName((String)o);
            }
        }
        if (PropertiesProxy.hasProperties()) {
            return PropertiesProxy.getPropertyNames();
        }
        return null;
    }

    protected Object getValueFromBean(Object bean, String fieldName, Method m) {
        int index = fieldName.lastIndexOf(".");
        if (index > 0) {
            String chain = fieldName.substring(0, index);
            String lastField = fieldName.substring(index + 1);
            Object deepestBean = this.getDeepestBean(bean, chain, false);
            if (deepestBean == null) {
                return null;
            }
            return this.getValueFromBean(deepestBean, lastField, m);
        }
        if (bean == null) {
            return null;
        }
        if (m == null) {
            m = InjectionUtils.findMethodToGet(bean.getClass(), fieldName);
        }
        if (m == null) {
            throw new BeanException("Cannot find method to get field from bean: Class: " + bean.getClass() + ", field: " + fieldName);
        }
        Object value = null;
        try {
            value = m.invoke(bean, (Object[])null);
            return value;
        }
        catch (Exception e) {
            throw new BeanException(e);
        }
    }

    private static void checkPK(Object value, DBField dbField) {
        Number n;
        if (value == null) {
            throw new BeanException("pk is missing: " + dbField);
        }
        if (value instanceof Number && (n = (Number)value).doubleValue() <= 0.0) {
            throw new BeanException("Number pk is missing: " + dbField);
        }
    }

    @Override
    public boolean load(Object bean) {
        return this.loadImpl(bean, null, null);
    }

    @Override
    public boolean load(Object bean, Object ... properties) {
        return this.loadImpl(bean, AnsiSQLBeanSession.getProperties(properties), null);
    }

    @Override
    public boolean loadMinus(Object bean, Object ... minus) {
        return this.loadImpl(bean, null, AnsiSQLBeanSession.getProperties(minus));
    }

    protected boolean loadImpl(Object bean, String[] properties, String[] minus) {
        boolean bl;
        HashMap<String, Value> fieldsLoaded;
        ResultSet rset;
        PreparedStatement stmt;
        block20: {
            BeanConfig bc = this.getConfigFor((Class<? extends Object>)bean.getClass());
            if (bc == null) {
                throw new BeanException("Cannot find bean config: " + bean.getClass());
            }
            if (bc.getNumberOfFields() == 0) {
                throw new BeanException("BeanConfig has zero fields: " + bc);
            }
            StringBuilder sb = new StringBuilder(32 * bc.getNumberOfFields());
            sb.append("SELECT ");
            Iterator<DBField> iter = bc.fields();
            int count = 0;
            while (iter.hasNext()) {
                DBField field = iter.next();
                String fieldName = field.getDbName();
                if (!field.isPK() && (properties != null && !this.checkArray(fieldName, properties, bc) || minus != null && this.checkArray(fieldName, minus, bc))) continue;
                if (count++ > 0) {
                    sb.append(',');
                }
                sb.append(fieldName);
            }
            sb.append(" FROM ").append(bc.getTableName()).append(" WHERE ");
            if (!bc.hasPK()) {
                throw new BeanException("Cannot load bean without a PK!");
            }
            iter = bc.pks();
            count = 0;
            LinkedList<Value> values = new LinkedList<Value>();
            while (iter.hasNext()) {
                DBField dbField = iter.next();
                String fieldName = dbField.getName();
                String dbFieldName = dbField.getDbName();
                Object value = this.getValueFromBean(bean, fieldName);
                AnsiSQLBeanSession.checkPK(value, dbField);
                if (count++ > 0) {
                    sb.append(" AND ");
                }
                sb.append(dbFieldName).append("=?");
                values.add(new Value(dbField, value));
            }
            if (values.isEmpty()) {
                throw new BeanException("Bean is empty: " + bean + " / " + bc);
            }
            if (this.conn == null) {
                throw new BeanException("Connection is null!");
            }
            stmt = null;
            rset = null;
            if (DEBUG) {
                System.out.println("LOAD SQL: " + sb.toString());
            }
            stmt = this.conn.prepareStatement(sb.toString());
            Iterator iter2 = values.iterator();
            int index = 0;
            while (iter2.hasNext()) {
                Value v = (Value)iter2.next();
                v.field.getType().bindToStmt(stmt, ++index, v.value);
            }
            rset = stmt.executeQuery();
            if (DEBUG_NATIVE) {
                System.out.println("LOAD SQL (NATIVE): " + stmt);
            }
            index = 0;
            fieldsLoaded = new HashMap<String, Value>();
            if (rset.next()) {
                iter = bc.fields();
                while (iter.hasNext()) {
                    DBField f = iter.next();
                    String fieldName = f.getName();
                    if (!f.isPK() && (properties != null && !this.checkArray(fieldName, properties, bc) || minus != null && this.checkArray(fieldName, minus, bc))) continue;
                    DBType type = f.getType();
                    Object value = type.getFromResultSet(rset, ++index);
                    this.injectValue(bean, fieldName, value, type.getTypeClass());
                    fieldsLoaded.put(fieldName, new Value(f, value));
                }
                break block20;
            }
            boolean bl2 = false;
            AnsiSQLBeanSession.close(stmt, rset);
            return bl2;
        }
        try {
            if (rset.next()) {
                throw new BeanException("Load returned more than one row!");
            }
            this.loaded.put(bean, fieldsLoaded);
            bl = true;
        }
        catch (Exception e) {
            try {
                throw new BeanException(e);
            }
            catch (Throwable throwable) {
                AnsiSQLBeanSession.close(stmt, rset);
                throw throwable;
            }
        }
        AnsiSQLBeanSession.close(stmt, rset);
        return bl;
    }

    private Object getDeepestBean(Object target, String name, boolean create) {
        int index = name.indexOf(46);
        if (index > 0) {
            String fieldName = name.substring(0, index);
            String remainingName = name.substring(index + 1);
            Object bean = this.getPropertyBean(target, fieldName, create);
            return this.getDeepestBean(bean, remainingName, create);
        }
        return this.getPropertyBean(target, name, create);
    }

    protected Object getPropertyBean(Object target, String name, boolean create) {
        Object value = this.getValueFromBean(target, name);
        if (value == null && create) {
            Class<?> beanClass = InjectionUtils.findPropertyType(target.getClass(), name);
            if (beanClass == null) {
                throw new BeanException("Cannot find property type: " + target.getClass() + " " + name);
            }
            try {
                value = beanClass.newInstance();
            }
            catch (Exception e) {
                value = this.getAbstractValue(target.getClass(), name);
            }
            this.injectValue(target, name, value, beanClass);
        }
        return value;
    }

    private Object getAbstractValue(Class<? extends Object> clazz, String name) {
        try {
            Class<? extends Object> instanceClass;
            BeanConfig bc = this.getConfigFor(clazz);
            if (bc != null && (instanceClass = bc.getAbstractProperty(name)) != null) {
                return instanceClass.newInstance();
            }
            throw new BeanException("Cannot instantiate property name: " + name + " from " + clazz);
        }
        catch (Exception e) {
            throw new BeanException("Cannot instantiate abstract value for " + clazz + " (field " + name + ")", e);
        }
    }

    protected void injectValue(Object bean, String fieldName, Object value, Class<? extends Object> valueType) {
        int index = fieldName.lastIndexOf(".");
        if (index > 0) {
            if (value == null) {
                return;
            }
            String chain = fieldName.substring(0, index);
            String lastField = fieldName.substring(index + 1);
            Object deepestBean = this.getDeepestBean(bean, chain, true);
            this.injectValue(deepestBean, lastField, value, valueType);
            return;
        }
        Method m = InjectionUtils.findMethodToInject(bean.getClass(), fieldName, value == null ? valueType : value.getClass());
        if (m == null) {
            Field field = InjectionUtils.findFieldToInject(bean.getClass(), fieldName, value == null ? valueType : value.getClass());
            if (field != null) {
                if (field.getType().isPrimitive() && value == null) {
                    value = InjectionUtils.getDefaultValueForPrimitive(field.getType());
                }
                try {
                    field.set(bean, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BeanException(e);
                }
            } else {
                Long l;
                if (value instanceof Long && (l = (Long)value) <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                    this.injectValue(bean, fieldName, l.intValue(), Integer.class);
                    return;
                }
                if (value != null) {
                    throw new BeanException("Cannot find field or method to inject: " + bean + " / " + fieldName);
                }
            }
        } else {
            Class<?> paramType = m.getParameterTypes()[0];
            if (paramType.isPrimitive() && value == null) {
                value = InjectionUtils.getDefaultValueForPrimitive(paramType);
            }
            try {
                m.invoke(bean, value);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BeanException(e);
            }
        }
    }

    protected StringBuilder handleLimit(StringBuilder sb, OrderBy orderBy, Limit limit) {
        return sb;
    }

    @Override
    public String buildSelect(Class<? extends Object> beanClass) {
        return this.buildSelectImpl(beanClass, null, null, null, true, true);
    }

    @Override
    public String buildSelect(Class<? extends Object> beanClass, Object ... properties) {
        return this.buildSelectImpl(beanClass, null, AnsiSQLBeanSession.getProperties(properties), null, true, true);
    }

    @Override
    public String buildSelect(Class<? extends Object> beanClass, String tablePrefix) {
        return this.buildSelectImpl(beanClass, tablePrefix, null, null, true, true);
    }

    @Override
    public String buildSelect(Class<? extends Object> beanClass, String tablePrefix, Object ... properties) {
        return this.buildSelectImpl(beanClass, tablePrefix, AnsiSQLBeanSession.getProperties(properties), null, true, true);
    }

    @Override
    public String buildSelectMinus(Class<? extends Object> beanClass, Object ... minus) {
        return this.buildSelectImpl(beanClass, null, null, AnsiSQLBeanSession.getProperties(minus), true, true);
    }

    @Override
    public String buildSelectMinus(Class<? extends Object> beanClass, String tablePrefix, Object ... minus) {
        return this.buildSelectImpl(beanClass, tablePrefix, null, AnsiSQLBeanSession.getProperties(minus), true, true);
    }

    protected String buildSelectImpl(Class<? extends Object> beanClass, String tablePrefix, String[] properties, String[] minus, boolean includePK, boolean addSuffix) {
        BeanConfig bc = this.getConfigFor(beanClass);
        if (bc == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(32 * bc.getNumberOfFields());
        Iterator<DBField> iter = bc.fields();
        int count = 0;
        while (iter.hasNext()) {
            DBField field = iter.next();
            String dbField = field.getDbName();
            String name = field.getName();
            if ((!field.isPK() || !includePK) && (properties != null && !this.checkArray(name, properties, bc) || minus != null && this.checkArray(name, minus, bc))) continue;
            if (count++ > 0) {
                sb.append(",");
            }
            if (tablePrefix != null) {
                sb.append(tablePrefix).append('.').append(dbField);
                if (!addSuffix) continue;
                sb.append(' ');
                sb.append(tablePrefix).append('_').append(dbField);
                continue;
            }
            sb.append(dbField);
        }
        return sb.toString();
    }

    private boolean checkArray(String value, String[] array, BeanConfig bc) {
        String column = this.propertyToColumn(bc, (Object)value);
        for (int i = 0; i < array.length; ++i) {
            if (!this.propertyToColumn(bc, (Object)array[i]).equals(column)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void populateBean(ResultSet rset, Object bean) {
        this.populateBeanImpl(rset, bean, null, null, null, true);
    }

    @Override
    public void populateBean(ResultSet rset, Object bean, Object ... properties) {
        this.populateBeanImpl(rset, bean, null, AnsiSQLBeanSession.getProperties(properties), null, true);
    }

    @Override
    public void populateBean(ResultSet rset, Object bean, String tablePrefix) {
        this.populateBeanImpl(rset, bean, tablePrefix, null, null, true);
    }

    @Override
    public void populateBean(ResultSet rset, Object bean, String tablePrefix, Object ... properties) {
        this.populateBeanImpl(rset, bean, tablePrefix, AnsiSQLBeanSession.getProperties(properties), null, true);
    }

    @Override
    public void populateBeanMinus(ResultSet rset, Object bean, Object ... minus) {
        this.populateBeanImpl(rset, bean, null, null, AnsiSQLBeanSession.getProperties(minus), true);
    }

    @Override
    public void populateBeanMinus(ResultSet rset, Object bean, String tablePrefix, Object ... minus) {
        this.populateBeanImpl(rset, bean, tablePrefix, null, AnsiSQLBeanSession.getProperties(minus), true);
    }

    protected void populateBeanImpl(ResultSet rset, Object bean, String tablePrefix, String[] properties, String[] minus, boolean includePK) {
        BeanConfig bc = this.getConfigFor((Class<? extends Object>)bean.getClass());
        if (bc == null) {
            throw new BeanException("Cannot find bean config: " + bean.getClass());
        }
        Iterator<DBField> iter = bc.fields();
        StringBuilder sbField = new StringBuilder(32);
        while (iter.hasNext()) {
            DBField f = iter.next();
            String fieldName = f.getName();
            if ((!f.isPK() || !includePK) && (properties != null && !this.checkArray(fieldName, properties, bc) || minus != null && this.checkArray(fieldName, minus, bc))) continue;
            String dbFieldName = f.getDbName();
            DBType type = f.getType();
            sbField.setLength(0);
            if (tablePrefix != null) {
                sbField.append(tablePrefix).append('_').append(dbFieldName);
            } else {
                sbField.append(dbFieldName);
            }
            try {
                Object value = type.getFromResultSet(rset, sbField.toString());
                this.injectValue(bean, fieldName, value, type.getTypeClass());
            }
            catch (Exception e) {
                throw new BeanException(e);
            }
        }
    }

    @Override
    public <E> List<E> loadListMinus(E bean, OrderBy orderBy, Limit limit, Object ... minus) {
        return this.loadListImpl(bean, orderBy, limit, null, AnsiSQLBeanSession.getProperties(minus));
    }

    private <E> E checkUnique(List<E> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            throw new BeanException("Query returned more than one bean!");
        }
        return list.get(0);
    }

    @Override
    public <E> List<E> loadList(E bean, OrderBy orderBy, Limit limit) {
        return this.loadListImpl(bean, orderBy, limit, null, null);
    }

    @Override
    public <E> List<E> loadList(E bean, OrderBy orderBy, Limit limit, Object ... properties) {
        return this.loadListImpl(bean, orderBy, limit, AnsiSQLBeanSession.getProperties(properties), null);
    }

    private <E> StringBuilder prepareListQuery(StringBuilder sb, BeanConfig bc, E bean, OrderBy orderBy, Limit limit, List<Value> values) {
        sb.append(" FROM ").append(bc.getTableName()).append(" ");
        Iterator<DBField> iter = bc.fields();
        int count = 0;
        while (iter.hasNext()) {
            DBField field = iter.next();
            String dbField = field.getDbName();
            Method m = this.findMethodToGet(bean, field.getName());
            boolean isNestedProperty = field.getName().contains(".");
            if (m == null) {
                if (isNestedProperty) continue;
                throw new BeanException("Cannot find method to get field from bean: " + field.getName());
            }
            Class<?> returnType = m.getReturnType();
            Object value = this.getValueFromBean(bean, field.getName(), m);
            if (!this.isSet(value, returnType)) continue;
            if (count++ > 0) {
                sb.append(" AND ");
            } else {
                sb.append(" WHERE ");
            }
            sb.append(dbField).append("=?");
            values.add(new Value(field, value));
        }
        sb.append(this.buildOrderBy(orderBy, bc));
        sb = this.handleLimit(sb, orderBy, limit);
        return sb;
    }

    private String buildOrderBy(OrderBy orderBy, BeanConfig bc) {
        if (orderBy != null && !orderBy.isEmpty()) {
            String[] orders;
            String orderByString = orderBy.toString();
            for (String order : orders = orderByString.trim().split("\\s*,\\s*")) {
                if (order.contains(" ")) {
                    order = order.substring(0, order.indexOf(" "));
                }
                orderByString = orderByString.replace(order, this.propertyToColumn(bc, (Object)order));
            }
            StringBuilder sb = new StringBuilder();
            sb.append(" order by ").append(orderByString).append(" ");
            return sb.toString();
        }
        return " ";
    }

    public String propertyToColumn(BeanConfig bc, Object property) {
        Iterator<DBField> it = bc.fields();
        String propertyName = AnsiSQLBeanSession.getProperties(new Object[]{property})[0];
        while (it.hasNext()) {
            DBField field = it.next();
            if (!propertyName.equalsIgnoreCase(field.getName())) continue;
            return field.getDbName();
        }
        return propertyName;
    }

    @Override
    public String propertyToColumn(Class<? extends Object> clazz, Object property) {
        return this.propertyToColumn(clazz, property, null);
    }

    @Override
    public String propertyToColumn(Class<? extends Object> clazz, Object property, String alias) {
        BeanConfig bc = this.getConfigFor(clazz);
        if (alias == null) {
            return this.propertyToColumn(bc, property);
        }
        return alias + "." + this.propertyToColumn(bc, property);
    }

    @Override
    public String buildTableName(Class<? extends Object> clazz) {
        return this.getConfigFor(clazz).getTableName();
    }

    @Override
    public QueryBuilder buildQuery() {
        return new QueryBuilder(this);
    }

    @Override
    public int countList(Object bean) {
        return this.countListImpl(bean, null, null);
    }

    private int countListImpl(Object bean, OrderBy orderBy, Limit limit) {
        int n;
        if (limit != null && limit.intValue() == 0) {
            return 0;
        }
        BeanConfig bc = this.getConfigFor((Class<? extends Object>)bean.getClass());
        if (bc == null) {
            throw new BeanException("Cannot find bean config: " + bean.getClass());
        }
        StringBuilder sb = new StringBuilder(32 * bc.getNumberOfFields());
        sb.append("SELECT count(1)");
        LinkedList<Value> values = new LinkedList<Value>();
        sb = this.prepareListQuery(sb, bc, bean, orderBy, limit, values);
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            String sql = sb.toString();
            if (DEBUG) {
                System.out.println("COUNT LIST: " + sql);
            }
            stmt = this.conn.prepareStatement(sql);
            Iterator iter2 = values.iterator();
            int index = 0;
            while (iter2.hasNext()) {
                Value v = (Value)iter2.next();
                v.field.getType().bindToStmt(stmt, ++index, v.value);
            }
            rset = stmt.executeQuery();
            if (DEBUG_NATIVE) {
                System.out.println("COUNT LIST (NATIVE): " + stmt);
            }
            rset.next();
            n = rset.getInt(1);
        }
        catch (Exception e) {
            try {
                throw new BeanException(e);
            }
            catch (Throwable throwable) {
                AnsiSQLBeanSession.close(stmt, rset);
                throw throwable;
            }
        }
        AnsiSQLBeanSession.close(stmt, rset);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <E> List<E> loadListImpl(E bean, OrderBy orderBy, Limit limit, String[] properties, String[] minus) {
        if (limit != null && limit.intValue() == 0) {
            return new ArrayList();
        }
        BeanConfig bc = this.getConfigFor((Class<? extends Object>)bean.getClass());
        if (bc == null) {
            throw new BeanException("Cannot find bean config: " + bean.getClass());
        }
        StringBuilder sb = new StringBuilder(32 * bc.getNumberOfFields());
        Iterator<DBField> iter = bc.fields();
        sb.append("SELECT ");
        int count = 0;
        while (iter.hasNext()) {
            DBField field = iter.next();
            String dbField = field.getDbName();
            String name = field.getName();
            if (!field.isPK() && (properties != null && !this.checkArray(name, properties, bc) || minus != null && this.checkArray(name, minus, bc))) continue;
            if (count++ > 0) {
                sb.append(",");
            }
            sb.append(dbField);
        }
        LinkedList<Value> values = new LinkedList<Value>();
        sb = this.prepareListQuery(sb, bc, bean, orderBy, limit, values);
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            String sql = sb.toString();
            if (DEBUG) {
                System.out.println("LOAD LIST: " + sql);
            }
            stmt = this.conn.prepareStatement(sql);
            Iterator iter2 = values.iterator();
            int index = 0;
            while (iter2.hasNext()) {
                Value v = (Value)iter2.next();
                v.field.getType().bindToStmt(stmt, ++index, v.value);
            }
            rset = stmt.executeQuery();
            if (DEBUG_NATIVE) {
                System.out.println("LOAD LIST (NATIVE): " + stmt);
            }
            LinkedList results = new LinkedList();
            Class<?> beanKlass = bean.getClass();
            int total = 0;
            do {
                Object item;
                if (rset.next()) {
                    iter = bc.fields();
                    index = 0;
                    item = beanKlass.newInstance();
                } else {
                    LinkedList linkedList = results;
                    AnsiSQLBeanSession.close(stmt, rset);
                    return linkedList;
                }
                while (iter.hasNext()) {
                    DBField f = iter.next();
                    String fieldName = f.getName();
                    if (!f.isPK() && (properties != null && !this.checkArray(fieldName, properties, bc) || minus != null && this.checkArray(fieldName, minus, bc))) continue;
                    DBType type = f.getType();
                    Object value = type.getFromResultSet(rset, ++index);
                    this.injectValue(item, fieldName, value, type.getTypeClass());
                }
                results.add(item);
            } while (limit == null || limit.intValue() <= 0 || ++total != limit.intValue());
            LinkedList linkedList = results;
            AnsiSQLBeanSession.close(stmt, rset);
            return linkedList;
        }
        catch (Exception e) {
            try {
                throw new BeanException(e);
            }
            catch (Throwable throwable) {
                AnsiSQLBeanSession.close(stmt, rset);
                throw throwable;
            }
        }
    }

    protected boolean isSet(Object value, Class<? extends Object> returnType) {
        if (value != null) {
            if (returnType.equals(Boolean.TYPE) && value instanceof Boolean) {
                boolean b = (Boolean)value;
                return b;
            }
            if (returnType.equals(Character.TYPE) && value instanceof Character) {
                char c = ((Character)value).charValue();
                return c != '\u0000';
            }
            if (returnType.isPrimitive() && !returnType.equals(Boolean.TYPE) && !returnType.equals(Character.TYPE) && value instanceof Number) {
                Number n = (Number)value;
                if (n.intValue() != 0) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    public int update(Object bean, Object ... forceNull) {
        return this.update(bean, true, AnsiSQLBeanSession.getProperties(forceNull));
    }

    @Override
    public int updateAll(Object bean) {
        return this.update(bean, false, (String[])null);
    }

    private int update(Object bean, boolean dynUpdate, String[] nullProps) {
        int n;
        PreparedStatement stmt;
        LinkedList<Value> values;
        Map<String, Value> fieldsLoaded;
        block34: {
            DBField dbField;
            fieldsLoaded = this.loaded.get(bean);
            BeanConfig bc = this.getConfigFor((Class<? extends Object>)bean.getClass());
            if (bc == null) {
                throw new BeanException("Cannot find bean config: " + bean.getClass());
            }
            if (bc.getNumberOfFields() == 0) {
                throw new BeanException("BeanConfig has zero fields: " + bc);
            }
            StringBuilder sb = new StringBuilder(32 * bc.getNumberOfFields());
            sb.append("UPDATE ").append(bc.getTableName()).append(" SET ");
            Iterator<DBField> iter = bc.fields();
            int count = 0;
            values = new LinkedList<Value>();
            while (iter.hasNext()) {
                DBType type;
                dbField = iter.next();
                if (dbField.isPK() || (type = dbField.getType()) instanceof AutoIncrementType || type instanceof AutoTimestampType) continue;
                boolean isNowOnUpdate = type instanceof NowOnUpdateTimestampType || type instanceof NowOnInsertAndUpdateTimestampType;
                String fieldName = dbField.getName();
                String dbFieldName = dbField.getDbName();
                if (!isNowOnUpdate) {
                    Method m = this.findMethodToGet(bean, fieldName);
                    Object value = null;
                    Class<?> returnType = null;
                    boolean isNestedProperty = fieldName.contains(".");
                    if (m == null && !isNestedProperty) {
                        throw new BeanException("Cannot find method to get field from bean: " + fieldName);
                    }
                    if (m != null) {
                        returnType = m.getReturnType();
                        value = this.getValueFromBean(bean, fieldName, m);
                    }
                    boolean update = false;
                    if (!dynUpdate) {
                        update = true;
                    } else if (fieldsLoaded != null) {
                        Value v = fieldsLoaded.get(fieldName);
                        if (v != null) {
                            update = value == null && v.value != null ? true : (value != null && v.value == null ? true : (value == null && v.value == null ? false : !value.equals(v.value)));
                        }
                    } else {
                        update = this.isSet(value, returnType);
                        if (!update && nullProps != null) {
                            update = this.checkArray(fieldName, nullProps, bc);
                            value = null;
                        }
                    }
                    if (!update) continue;
                    if (count++ > 0) {
                        sb.append(',');
                    }
                    sb.append(dbFieldName).append("=?");
                    values.add(new Value(dbField, value));
                    continue;
                }
                if (count++ > 0) {
                    sb.append(',');
                }
                sb.append(dbFieldName).append("=");
                String nowCommand = this.getCurrentTimestampCommand();
                if (nowCommand == null) {
                    sb.append("?");
                    values.add(new Value(dbField, new Date()));
                    continue;
                }
                sb.append(nowCommand);
            }
            if (count == 0) {
                return 0;
            }
            sb.append(" WHERE ");
            if (!bc.hasPK()) {
                throw new BeanException("Cannot update bean without a PK!");
            }
            iter = bc.pks();
            count = 0;
            while (iter.hasNext()) {
                Number n2;
                dbField = iter.next();
                String fieldName = dbField.getName();
                String dbFieldName = dbField.getDbName();
                Object value = this.getValueFromBean(bean, fieldName);
                if (value == null) {
                    throw new BeanException("pk is missing: " + dbField);
                }
                if (value instanceof Number && (n2 = (Number)value).doubleValue() <= 0.0) {
                    throw new BeanException("Number pk is missing: " + dbField);
                }
                if (count++ > 0) {
                    sb.append(" AND ");
                }
                sb.append(dbFieldName).append("=?");
                values.add(new Value(dbField, value));
            }
            if (values.isEmpty()) {
                throw new BeanException("Bean is empty: " + bean + " / " + bc);
            }
            if (this.conn == null) {
                throw new BeanException("Connection is null!");
            }
            stmt = null;
            if (DEBUG) {
                System.out.println("UPDATE SQL: " + sb.toString());
            }
            this.dispatchBeforeUpdate(bean);
            stmt = this.conn.prepareStatement(sb.toString());
            Iterator iter2 = values.iterator();
            int index = 0;
            while (iter2.hasNext()) {
                Value v = (Value)iter2.next();
                v.field.getType().bindToStmt(stmt, ++index, v.value);
            }
            int x = stmt.executeUpdate();
            if (DEBUG_NATIVE) {
                System.out.println("UPDATE SQL (NATIVE): " + stmt);
            }
            if (x > 1) {
                throw new BeanException("update modified more than one line: " + x);
            }
            if (x != 0) break block34;
            int n2 = 0;
            AnsiSQLBeanSession.close(stmt);
            return n2;
        }
        try {
            if (fieldsLoaded != null) {
                for (Value v : values) {
                    Value vv;
                    if (v.field.isPK() || (vv = fieldsLoaded.get(v.field.getName())) == null) continue;
                    vv.value = v.value;
                }
            }
            this.dispatchAfterUpdate(bean);
            n = 1;
        }
        catch (Exception e) {
            try {
                throw new BeanException(e);
            }
            catch (Throwable throwable) {
                AnsiSQLBeanSession.close(stmt);
                throw throwable;
            }
        }
        AnsiSQLBeanSession.close(stmt);
        return n;
    }

    @Override
    public <E> E createBasicInstance(E bean) {
        try {
            BeanConfig bc = this.getConfigFor((Class<? extends Object>)bean.getClass());
            Iterator<DBField> pks = bc.pks();
            DBField pk = null;
            Object value = null;
            Object basic = bean.getClass().newInstance();
            while (pks.hasNext()) {
                pk = pks.next();
                value = this.getValueFromBean(bean, pk.getName());
                AnsiSQLBeanSession.checkPK(value, pk);
                this.injectValue(basic, pk.getName(), value, null);
            }
            return (E)basic;
        }
        catch (Exception e) {
            throw new BeanException(e);
        }
    }

    @Override
    public <E> int updateDiff(E newBean, E oldBean) {
        LinkedList<String> nullProps = new LinkedList<String>();
        E diff = this.compareDifferences(newBean, oldBean, nullProps);
        return diff == null ? 0 : this.update(diff, nullProps.toArray());
    }

    @Override
    public <E> E compareDifferences(E bean, E another, List<String> nullProps) {
        try {
            BeanConfig bc = this.getConfigFor((Class<? extends Object>)bean.getClass());
            Iterator<DBField> fields = bc.fields();
            Object diff = bean.getClass().newInstance();
            boolean hasDiff = false;
            while (fields.hasNext()) {
                DBField field = fields.next();
                Method m = this.findMethodToGet(bean, field.getName());
                boolean isNestedProperty = field.getName().contains(".");
                if (m == null) {
                    if (!isNestedProperty) {
                        throw new BeanException("Cannot find method to get field from bean: " + field.getName());
                    }
                    int index = field.getName().lastIndexOf(".") + 1;
                    Object deepest = this.getDeepestBean(bean, field.getName().substring(0, index - 1), true);
                    String lastField = field.getName().substring(index);
                    m = this.findMethodToGet(deepest, lastField);
                }
                Class<?> returnType = m.getReturnType();
                Object valueBean = this.getValueFromBean(bean, field.getName());
                if (field.isPK()) {
                    this.injectValue(diff, field.getName(), valueBean, null);
                    continue;
                }
                Object valueAnother = this.getValueFromBean(another, field.getName());
                if (!this.isSet(valueBean, returnType) && !this.isSet(valueAnother, returnType)) continue;
                if (!this.isSet(valueBean, returnType)) {
                    nullProps.add(field.getName());
                    hasDiff = true;
                    continue;
                }
                if (valueBean.equals(valueAnother)) continue;
                hasDiff = true;
                this.injectValue(diff, field.getName(), valueBean, returnType);
            }
            return (E)(hasDiff ? diff : null);
        }
        catch (Exception e) {
            throw new BeanException(e);
        }
    }

    @Override
    public int save(Object bean, Object ... forceNull) {
        return this.save(bean, true, AnsiSQLBeanSession.getProperties(forceNull));
    }

    @Override
    public int saveAll(Object bean) {
        return this.save(bean, false);
    }

    protected int save(Object bean, boolean dynUpdate, String[] nullProps) {
        if (this.secureLoadUnique(bean) != null) {
            this.update(bean, dynUpdate, nullProps);
            return 0;
        }
        this.insert(bean);
        return 1;
    }

    protected Object secureLoadUnique(Object bean) {
        try {
            return this.loadUnique(this.createBasicInstance(bean));
        }
        catch (Exception e) {
            return null;
        }
    }

    private Method findMethodToGet(Object bean, String fieldName) {
        Method m = null;
        int index = fieldName.lastIndexOf(".");
        if (index > 0) {
            String chain = fieldName.substring(0, index);
            String lastField = fieldName.substring(index + 1);
            Object deepestBean = this.getDeepestBean(bean, chain, false);
            if (deepestBean != null) {
                m = InjectionUtils.findMethodToGet(deepestBean.getClass(), lastField);
            }
        } else {
            m = InjectionUtils.findMethodToGet(bean.getClass(), fieldName);
        }
        return m;
    }

    protected QueryAndValues prepareInsertQuery(Object bean) {
        DBType type;
        String dbFieldName;
        String fieldName;
        DBField dbField;
        BeanConfig bc = this.getConfigFor((Class<? extends Object>)bean.getClass());
        if (bc == null) {
            throw new BeanException("Cannot find bean config: " + bean.getClass());
        }
        if (bc.getNumberOfFields() == 0) {
            throw new BeanException("BeanConfig has zero fields: " + bc);
        }
        StringBuilder sb = new StringBuilder(32 * bc.getNumberOfFields());
        sb.append("INSERT INTO ").append(bc.getTableName()).append("(");
        Iterator<DBField> iter = bc.pks();
        int count = 0;
        LinkedList<Value> values = new LinkedList<Value>();
        while (iter.hasNext()) {
            dbField = iter.next();
            fieldName = dbField.getName();
            dbFieldName = dbField.getDbName();
            type = dbField.getType();
            if (type instanceof AutoIncrementType || type instanceof AutoTimestampType || type instanceof NowOnUpdateTimestampType) continue;
            Object value = this.getValueFromBean(bean, fieldName);
            if (count++ > 0) {
                sb.append(',');
            }
            sb.append(dbFieldName);
            values.add(new Value(dbField, value));
        }
        iter = bc.fields();
        while (iter.hasNext()) {
            boolean isNowOnInsert;
            dbField = iter.next();
            if (dbField.isPK()) continue;
            fieldName = dbField.getName();
            dbFieldName = dbField.getDbName();
            type = dbField.getType();
            if (type instanceof AutoIncrementType || type instanceof AutoTimestampType || type instanceof NowOnUpdateTimestampType) continue;
            boolean bl = isNowOnInsert = type instanceof NowOnInsertTimestampType || type instanceof NowOnInsertAndUpdateTimestampType;
            if (!isNowOnInsert) {
                Object value = this.getValueFromBean(bean, fieldName);
                if (count++ > 0) {
                    sb.append(',');
                }
                sb.append(dbFieldName);
                values.add(new Value(dbField, value));
                continue;
            }
            if (count++ > 0) {
                sb.append(',');
            }
            sb.append(dbFieldName);
            String cmd = this.getCurrentTimestampCommand();
            if (cmd == null) {
                values.add(new Value(dbField, new Date()));
                continue;
            }
            values.add(new Value(dbField, true));
        }
        if (count == 0) {
            throw new BeanException("There is nothing to insert!");
        }
        sb.append(") VALUES(");
        Iterator valuesIter = values.iterator();
        int i = 0;
        while (valuesIter.hasNext()) {
            Value v = (Value)valuesIter.next();
            if (i > 0) {
                sb.append(',');
            }
            if (v.isSysdate) {
                sb.append(this.getCurrentTimestampCommand());
            } else {
                sb.append('?');
            }
            ++i;
        }
        sb.append(')');
        if (values.isEmpty()) {
            throw new BeanException("Bean is empty: " + bean + " / " + bc);
        }
        return new QueryAndValues(sb, values);
    }

    protected Map<String, Value> bindToInsertStatement(PreparedStatement stmt, List<Value> values) {
        Iterator<Value> iter2 = values.iterator();
        int index = 0;
        HashMap<String, Value> fieldsLoaded = new HashMap<String, Value>();
        while (iter2.hasNext()) {
            Value v = iter2.next();
            if (v.isSysdate && this.getCurrentTimestampCommand() != null) continue;
            try {
                v.field.getType().bindToStmt(stmt, ++index, v.value);
            }
            catch (Exception e) {
                throw new BeanException(e);
            }
            fieldsLoaded.put(v.field.getName(), v);
        }
        return fieldsLoaded;
    }

    @Override
    public void insert(Object bean) {
        QueryAndValues qav = this.prepareInsertQuery(bean);
        StringBuilder sb = qav.sb;
        List<Value> values = qav.values;
        if (this.conn == null) {
            throw new BeanException("Connection is null!");
        }
        PreparedStatement stmt = null;
        try {
            if (DEBUG) {
                System.out.println("INSERT SQL: " + sb.toString());
            }
            stmt = this.conn.prepareStatement(sb.toString());
            Map<String, Value> fieldsLoaded = this.bindToInsertStatement(stmt, values);
            this.dispatchBeforeInsert(bean);
            int x = stmt.executeUpdate();
            if (DEBUG_NATIVE) {
                System.out.println("INSERT SQL (NATIVE): " + stmt);
            }
            if (x > 1) {
                throw new BeanException("insert modified more than one line: " + x);
            }
            if (x == 0) {
                throw new BeanException("Nothing was inserted! Insert returned 0 rows!");
            }
            this.loaded.put(bean, fieldsLoaded);
        }
        catch (Exception e) {
            try {
                throw new BeanException(e);
            }
            catch (Throwable throwable) {
                AnsiSQLBeanSession.close(stmt);
                throw throwable;
            }
        }
        AnsiSQLBeanSession.close(stmt);
    }

    @Override
    public int deleteAll(Object bean) {
        int n;
        BeanConfig bc = this.getConfigFor((Class<? extends Object>)bean.getClass());
        if (bc.getNumberOfFields() == 0) {
            throw new BeanException("BeanConfig has zero fields: " + bc);
        }
        StringBuilder sb = new StringBuilder(32 * bc.getNumberOfFields());
        sb.append("DELETE ");
        LinkedList<Value> values = new LinkedList<Value>();
        this.prepareListQuery(sb, bc, bean, null, null, values);
        if (this.conn == null) {
            throw new BeanException("Connection is null!");
        }
        PreparedStatement stmt = null;
        try {
            if (DEBUG) {
                System.out.println("DELETE SQL: " + sb.toString());
            }
            stmt = this.conn.prepareStatement(sb.toString());
            Iterator iter2 = values.iterator();
            int index = 0;
            while (iter2.hasNext()) {
                Value v = (Value)iter2.next();
                v.field.getType().bindToStmt(stmt, ++index, v.value);
            }
            this.dispatchBeforeDelete(bean);
            int x = stmt.executeUpdate();
            if (DEBUG_NATIVE) {
                System.out.println("DELETE SQL (NATIVE): " + stmt);
            }
            this.dispatchAfterDelete(bean);
            n = x;
        }
        catch (Exception e) {
            try {
                throw new BeanException(e);
            }
            catch (Throwable throwable) {
                AnsiSQLBeanSession.close(stmt);
                throw throwable;
            }
        }
        AnsiSQLBeanSession.close(stmt);
        return n;
    }

    @Override
    public boolean delete(Object bean) {
        boolean bl;
        PreparedStatement stmt;
        block17: {
            BeanConfig bc = this.getConfigFor((Class<? extends Object>)bean.getClass());
            if (bc.getNumberOfFields() == 0) {
                throw new BeanException("BeanConfig has zero fields: " + bc);
            }
            StringBuilder sb = new StringBuilder(32 * bc.getNumberOfFields());
            sb.append("DELETE FROM ").append(bc.getTableName()).append(" WHERE ");
            if (!bc.hasPK()) {
                throw new BeanException("Cannot delete bean without a PK!");
            }
            Iterator<DBField> iter = bc.pks();
            LinkedList<Value> values = new LinkedList<Value>();
            int count = 0;
            while (iter.hasNext()) {
                Number n;
                DBField dbField = iter.next();
                String fieldName = dbField.getName();
                String dbFieldName = dbField.getDbName();
                Object value = this.getValueFromBean(bean, fieldName);
                if (value == null) {
                    throw new BeanException("pk is missing: " + dbField);
                }
                if (value instanceof Number && (n = (Number)value).doubleValue() <= 0.0) {
                    throw new BeanException("Number pk is missing: " + dbField);
                }
                if (count++ > 0) {
                    sb.append(" AND ");
                }
                sb.append(dbFieldName).append("=?");
                values.add(new Value(dbField, value));
            }
            if (values.isEmpty()) {
                throw new BeanException("Bean is empty: " + bean + " / " + bc);
            }
            if (this.conn == null) {
                throw new BeanException("Connection is null!");
            }
            stmt = null;
            if (DEBUG) {
                System.out.println("DELETE SQL: " + sb.toString());
            }
            stmt = this.conn.prepareStatement(sb.toString());
            Iterator iter2 = values.iterator();
            int index = 0;
            while (iter2.hasNext()) {
                Value v = (Value)iter2.next();
                v.field.getType().bindToStmt(stmt, ++index, v.value);
            }
            this.dispatchBeforeDelete(bean);
            int x = stmt.executeUpdate();
            if (DEBUG_NATIVE) {
                System.out.println("DELETE SQL (NATIVE): " + stmt);
            }
            if (x > 1) {
                throw new BeanException("delete modified more than one line: " + x);
            }
            if (x != 0) break block17;
            boolean bl2 = false;
            AnsiSQLBeanSession.close(stmt);
            return bl2;
        }
        try {
            this.loaded.remove(bean);
            this.dispatchAfterDelete(bean);
            bl = true;
        }
        catch (Exception e) {
            try {
                throw new BeanException(e);
            }
            catch (Throwable throwable) {
                AnsiSQLBeanSession.close(stmt);
                throw throwable;
            }
        }
        AnsiSQLBeanSession.close(stmt);
        return bl;
    }

    @Override
    public <E> List<E> loadList(E bean) {
        return this.loadListImpl(bean, null, null, null, null);
    }

    @Override
    public <E> List<E> loadList(E bean, Object ... properties) {
        return this.loadListImpl(bean, null, null, AnsiSQLBeanSession.getProperties(properties), null);
    }

    @Override
    public <E> E loadUnique(E bean) {
        return this.loadUniqueImpl(bean, null, null);
    }

    @Override
    public <E> E loadUnique(E bean, Object ... properties) {
        return this.loadUniqueImpl(bean, AnsiSQLBeanSession.getProperties(properties), null);
    }

    @Override
    public <E> E loadUniqueMinus(E bean, Object ... minus) {
        return this.loadUniqueImpl(bean, null, AnsiSQLBeanSession.getProperties(minus));
    }

    protected <E> E loadUniqueImpl(E bean, String[] properties, String[] minus) {
        E o = this.checkUnique(this.loadListImpl(bean, null, new Limit(2), properties, minus));
        if (o != null) {
            this.loadImpl(o, properties, minus);
        }
        return o;
    }

    @Override
    public <E> List<E> loadList(E bean, OrderBy orderBy) {
        return this.loadListImpl(bean, orderBy, null, null, null);
    }

    @Override
    public <E> List<E> loadList(E bean, OrderBy orderBy, Object ... properties) {
        return this.loadListImpl(bean, orderBy, null, AnsiSQLBeanSession.getProperties(properties), null);
    }

    @Override
    public <E> List<E> loadList(E bean, Limit limit) {
        return this.loadList(bean, null, limit);
    }

    @Override
    public <E> List<E> loadList(E bean, Limit limit, Object ... properties) {
        return this.loadListImpl(bean, null, limit, AnsiSQLBeanSession.getProperties(properties), null);
    }

    @Override
    public <E> List<E> loadListMinus(E bean, Object ... minus) {
        return this.loadListMinus(bean, null, null, minus);
    }

    @Override
    public <E> List<E> loadListMinus(E bean, OrderBy orderBy, Object ... minus) {
        return this.loadListMinus(bean, orderBy, null, minus);
    }

    @Override
    public <E> List<E> loadListMinus(E bean, Limit limit, Object ... minus) {
        return this.loadListMinus(bean, null, limit, minus);
    }

    protected String getDatabaseType(DBType<?> dbType) {
        return dbType.getAnsiType();
    }

    protected boolean isVarcharUnlimitedSupported() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void createTable(Class<? extends Object> beanKlass) {
        PreparedStatement stmt;
        block24: {
            BeanConfig bc = this.getConfigFor(beanKlass);
            if (bc == null) {
                throw new BeanException("Cannot find bean config: " + beanKlass);
            }
            if (bc.getNumberOfFields() == 0) {
                throw new BeanException("Cannot create table with zero columns: " + beanKlass);
            }
            StringBuilder sb = new StringBuilder(1024);
            sb.append("create table ").append(bc.getTableName()).append(" (");
            Iterator<DBField> iter = bc.fields();
            int count = 0;
            while (iter.hasNext()) {
                String dbTypeStr;
                DBField dbField = iter.next();
                DBType dbType = dbField.getType();
                if (count++ > 0) {
                    sb.append(", ");
                }
                if ((dbTypeStr = this.getDatabaseType(dbType)) == null) {
                    throw new BeanException("Invalid ANSI type for column '" + dbField.getDbName() + "' in table '" + bc.getTableName() + "'. Maybe you're using a GenericType.");
                }
                sb.append(dbField.getDbName()).append(" ").append(dbTypeStr);
                if (dbType instanceof SizedType) {
                    int size = ((SizedType)((Object)dbType)).getSize();
                    if (size <= 0 && !this.isVarcharUnlimitedSupported()) {
                        size = 200;
                    }
                    if (size > 0) {
                        sb.append("(").append(size).append(")");
                    }
                }
                if (dbType.canBeNull() && !dbField.isPK()) continue;
                sb.append(" NOT NULL");
            }
            sb.append(")");
            if (DEBUG) {
                System.out.println("CREATE TABLE SQL: " + sb.toString());
            }
            stmt = null;
            boolean autoCommit = false;
            try {
                autoCommit = this.conn.getAutoCommit();
                this.conn.setAutoCommit(false);
                stmt = this.conn.prepareStatement(sb.toString());
                stmt.executeUpdate();
                if (DEBUG_NATIVE) {
                    System.out.println("CREATE TABLE SQL (NATIVE): " + stmt);
                }
                AnsiSQLBeanSession.close(stmt);
                String pkConstraintQuery = this.createPKConstraintQuery(bc.getTableName(), bc.pks());
                if (DEBUG) {
                    System.out.println("PK CONSTRAINT QUERY: " + pkConstraintQuery);
                }
                stmt = this.conn.prepareStatement(pkConstraintQuery);
                stmt.executeUpdate();
                if (DEBUG_NATIVE) {
                    System.out.println("PK CONSTRAINT QUERY (NATIVE): " + stmt);
                }
                if (autoCommit) {
                    this.conn.commit();
                }
                if (!autoCommit) break block24;
            }
            catch (Exception e) {
                try {
                    if (!autoCommit) throw new BeanException(e);
                    try {
                        this.conn.rollback();
                        this.conn.setAutoCommit(true);
                        throw new BeanException(e);
                    }
                    catch (Exception e2) {
                        throw new BeanException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (autoCommit) {
                        try {
                            this.conn.setAutoCommit(true);
                        }
                        catch (Exception e2) {
                            throw new BeanException(e2);
                        }
                    }
                    AnsiSQLBeanSession.close(stmt);
                    throw throwable;
                }
            }
            try {
                this.conn.setAutoCommit(true);
            }
            catch (Exception e) {
                throw new BeanException(e);
            }
        }
        AnsiSQLBeanSession.close(stmt);
    }

    @Override
    public void createTables() {
        Set<BeanConfig> all = this.beanManager.getBeanConfigs();
        for (BeanConfig bc : all) {
            this.createTable(bc.getBeanClass());
        }
    }

    @Override
    public void dropTable(Class<? extends Object> beanKlass) {
        StringBuilder sb = new StringBuilder("DROP TABLE ");
        String tableName = this.buildTableName(beanKlass);
        sb.append(tableName);
        if (DEBUG) {
            System.out.println("DROP TABLE QUERY: " + sb.toString());
        }
        PreparedStatement ppst = null;
        try {
            ppst = SQLUtils.prepare(this.conn, sb.toString(), new Object[0]);
            ppst.executeUpdate();
            if (DEBUG_NATIVE) {
                System.out.println("DROP TABLE QUERY (NATIVE): " + ppst);
            }
        }
        catch (SQLException e) {
            try {
                throw new BeanException("Unable to drop table '" + tableName + "'", e);
            }
            catch (Throwable throwable) {
                SQLUtils.close(ppst);
                throw throwable;
            }
        }
        SQLUtils.close(ppst);
    }

    protected String createPKConstraintQuery(String table, Iterator<DBField> pks) {
        StringBuilder sb = new StringBuilder("alter table ");
        sb.append(table);
        sb.append(" add primary key (");
        if (pks.hasNext()) {
            sb.append(pks.next().getDbName());
        }
        while (pks.hasNext()) {
            DBField dbField = pks.next();
            sb.append(", ").append(dbField.getDbName());
        }
        return sb.append(")").toString();
    }

    private int getSize(DBType<?> dbType) {
        if (dbType instanceof SizedType) {
            SizedType st = (SizedType)((Object)dbType);
            return st.getSize();
        }
        throw new IllegalStateException("Cannot get size from type: " + dbType);
    }

    public BeanConfig getConfigFor(Class<? extends Object> clazz) {
        return this.beanManager.getBeanConfig(clazz);
    }

    @Override
    public void addTrigger(TriggerListener trigger) {
        this.dispatcher.addTrigger(trigger);
    }

    @Override
    public void removeTrigger(TriggerListener trigger) {
        this.dispatcher.removeTrigger(trigger);
    }

    protected void dispatchBeforeInsert(Object bean) {
        this.dispatchTrigger(TriggerDispatcher.Type.BEFORE_INSERT, bean);
    }

    protected void dispatchAfterInsert(Object bean) {
        this.dispatchTrigger(TriggerDispatcher.Type.AFTER_INSERT, bean);
    }

    protected void dispatchBeforeUpdate(Object bean) {
        this.dispatchTrigger(TriggerDispatcher.Type.BEFORE_UPDATE, bean);
    }

    protected void dispatchAfterUpdate(Object bean) {
        this.dispatchTrigger(TriggerDispatcher.Type.AFTER_UPDATE, bean);
    }

    protected void dispatchBeforeDelete(Object bean) {
        this.dispatchTrigger(TriggerDispatcher.Type.BEFORE_DELETE, bean);
    }

    protected void dispatchAfterDelete(Object bean) {
        this.dispatchTrigger(TriggerDispatcher.Type.AFTER_DELETE, bean);
    }

    protected void dispatchTrigger(TriggerDispatcher.Type type, Object bean) {
        TriggerEvent evt = new TriggerEvent(this, bean);
        this.dispatcher.dispatch(type, evt);
        this.getConfigFor((Class<? extends Object>)bean.getClass()).getDispatcher().dispatch(type, evt);
    }

    static void close(PreparedStatement stmt) {
        SQLUtils.close(stmt);
    }

    static void close(PreparedStatement stmt, ResultSet rset) {
        SQLUtils.close(rset, stmt);
    }

    @Override
    public <E> TableAlias<E> createTableAlias(Class<? extends E> beanClass) {
        return new TableAlias<E>(this, this.beanManager.getBeanConfig(beanClass), beanClass);
    }

    @Override
    public <E> TableAlias<E> createTableAlias(Class<? extends E> beanClass, String prefix) {
        return new TableAlias<E>(this, this.beanManager.getBeanConfig(beanClass), beanClass, prefix);
    }

    protected class Value {
        public Object value;
        public DBField field;
        public boolean isSysdate;

        private Value(DBField field, Object value, boolean isSysdate) {
            this.field = field;
            this.value = value;
            this.isSysdate = isSysdate;
        }

        public Value(DBField field, Object value) {
            this(field, value, false);
        }

        public Value(DBField field, boolean isSysdate) {
            this(field, null, isSysdate);
        }
    }

    protected class QueryAndValues {
        public StringBuilder sb;
        public List<Value> values;

        public QueryAndValues(StringBuilder sb, List<Value> values) {
            this.sb = sb;
            this.values = values;
        }
    }
}

