/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.mentabean.BeanException;
import org.mentabean.DBType;
import org.mentabean.type.SizedType;

public class BooleanStringType
implements DBType<Boolean>,
SizedType {
    private final String sTrue;
    private final String sFalse;
    private boolean canBeNull = true;

    public BooleanStringType() {
        this("T", "F");
    }

    public BooleanStringType(String sTrue, String sFalse) {
        this.sTrue = sTrue;
        this.sFalse = sFalse;
    }

    public static BooleanStringType values(String sTrue, String sFalse) {
        return new BooleanStringType(sTrue, sFalse);
    }

    @Override
    public boolean canBeNull() {
        return this.canBeNull;
    }

    @Override
    public String getAnsiType() {
        return "varchar";
    }

    public BooleanStringType nullable(boolean flag) {
        BooleanStringType b = new BooleanStringType(this.sTrue, this.sFalse);
        b.canBeNull = flag;
        return b;
    }

    public BooleanStringType size(int size) {
        throw new UnsupportedOperationException("Cannot set size of a " + this);
    }

    @Override
    public int getSize() {
        return Math.max(this.sTrue.length(), this.sFalse.length());
    }

    public boolean equals(Object obj) {
        if (obj instanceof BooleanStringType) {
            BooleanStringType bt = (BooleanStringType)obj;
            if (bt.sTrue.equals(this.sTrue) && bt.sFalse.equals(this.sFalse)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected Boolean getBooleanValue(String s) {
        if (s.equals(this.sTrue)) {
            return true;
        }
        if (s.equals(this.sFalse)) {
            return false;
        }
        return null;
    }

    private static Boolean getBoolValue(boolean b) {
        if (b) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean getFromResultSet(ResultSet rset, int index) throws SQLException {
        String s = rset.getString(index);
        if (rset.wasNull() || s == null) {
            return null;
        }
        Boolean b = this.getBooleanValue(s);
        if (b == null) {
            throw new BeanException("Don't know how to convert String to boolean:" + s);
        }
        return BooleanStringType.getBoolValue(b);
    }

    @Override
    public Boolean getFromResultSet(ResultSet rset, String field) throws SQLException {
        String s = rset.getString(field);
        if (rset.wasNull() || s == null) {
            return null;
        }
        Boolean b = this.getBooleanValue(s);
        if (b == null) {
            throw new BeanException("Don't know how to convert String to boolean: " + s);
        }
        return BooleanStringType.getBoolValue(b);
    }

    @Override
    public Class<? extends Object> getTypeClass() {
        return Boolean.class;
    }

    @Override
    public void bindToStmt(PreparedStatement stmt, int index, Boolean value) throws SQLException {
        if (value == null) {
            stmt.setString(index, null);
        } else {
            String s = value != false ? this.sTrue : this.sFalse;
            stmt.setString(index, s);
        }
    }
}

