/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.mentabean.DBType;

public class AutoTimestampType
implements DBType<Date> {
    @Override
    public String getAnsiType() {
        return "timestamp";
    }

    @Override
    public boolean canBeNull() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Date getFromResultSet(ResultSet rset, int index) throws SQLException {
        return rset.getTimestamp(index);
    }

    @Override
    public Date getFromResultSet(ResultSet rset, String field) throws SQLException {
        return rset.getTimestamp(field);
    }

    @Override
    public Class<? extends Object> getTypeClass() {
        return Date.class;
    }

    @Override
    public void bindToStmt(PreparedStatement stmt, int index, Date value) throws SQLException {
        if (value == null) {
            stmt.setTimestamp(index, null);
        } else if (value instanceof Timestamp) {
            Timestamp t = (Timestamp)value;
            stmt.setTimestamp(index, t);
        } else {
            stmt.setTimestamp(index, new Timestamp(value.getTime()));
        }
    }
}

