/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.event;

import java.util.ArrayList;
import java.util.List;
import org.mentabean.event.TriggerEvent;
import org.mentabean.event.TriggerListener;

public class TriggerDispatcher {
    private final List<TriggerListener> triggers = new ArrayList<TriggerListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrigger(TriggerListener trigger) {
        List<TriggerListener> list = this.triggers;
        synchronized (list) {
            if (!this.triggers.contains(trigger)) {
                this.triggers.add(trigger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrigger(TriggerListener trigger) {
        List<TriggerListener> list = this.triggers;
        synchronized (list) {
            this.triggers.remove(trigger);
        }
    }

    public void dispatch(Type type, TriggerEvent evt) {
        type.dispatchAll(this.triggers, evt);
    }

    public static enum Type {
        BEFORE_INSERT{

            @Override
            void fire(TriggerListener l, TriggerEvent evt) {
                l.beforeInsert(evt);
            }
        }
        ,
        AFTER_INSERT{

            @Override
            void fire(TriggerListener l, TriggerEvent evt) {
                l.afterInsert(evt);
            }
        }
        ,
        BEFORE_UPDATE{

            @Override
            void fire(TriggerListener l, TriggerEvent evt) {
                l.beforeUpdate(evt);
            }
        }
        ,
        AFTER_UPDATE{

            @Override
            void fire(TriggerListener l, TriggerEvent evt) {
                l.afterUpdate(evt);
            }
        }
        ,
        BEFORE_DELETE{

            @Override
            void fire(TriggerListener l, TriggerEvent evt) {
                l.beforeDelete(evt);
            }
        }
        ,
        AFTER_DELETE{

            @Override
            void fire(TriggerListener l, TriggerEvent evt) {
                l.afterDelete(evt);
            }
        };


        public void dispatchAll(List<TriggerListener> list, TriggerEvent evt) {
            for (TriggerListener l : list) {
                this.fire(l, evt);
            }
        }

        abstract void fire(TriggerListener var1, TriggerEvent var2);
    }
}

