/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.mentabean.util.PropertiesProxy;

public class OrderBy {
    private final Map<String, SortOrder> fields = new LinkedHashMap<String, SortOrder>();

    public void orderByAsc(String field) {
        if (field == null) {
            this.orderByAsc((Object)null);
            return;
        }
        this.fields.put(field, SortOrder.ASC);
    }

    public void orderByAsc(Object field) {
        this.orderByAsc(PropertiesProxy.getPropertyName());
    }

    public void orderByDesc(String field) {
        if (field == null) {
            this.orderByDesc((Object)null);
            return;
        }
        this.fields.put(field, SortOrder.DESC);
    }

    public void orderByDesc(Object field) {
        this.orderByDesc(PropertiesProxy.getPropertyName());
    }

    public String toString() {
        if (this.fields.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(128);
        for (String field : this.fields.keySet()) {
            SortOrder so = this.fields.get(field);
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(field).append(" ").append(so.toString().toLowerCase());
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public static enum SortOrder {
        ASC,
        DESC;

    }
}

