/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.mentabean.DBType;

public class TimestampType
implements DBType<Date> {
    private boolean canBeNull = true;

    @Override
    public boolean canBeNull() {
        return this.canBeNull;
    }

    public TimestampType nullable(boolean flag) {
        TimestampType d = new TimestampType();
        d.canBeNull = flag;
        return d;
    }

    @Override
    public String getAnsiType() {
        return "timestamp";
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Date getFromResultSet(ResultSet rset, int index) throws SQLException {
        return rset.getTimestamp(index);
    }

    @Override
    public Date getFromResultSet(ResultSet rset, String field) throws SQLException {
        return rset.getTimestamp(field);
    }

    @Override
    public Class<? extends Object> getTypeClass() {
        return Date.class;
    }

    @Override
    public void bindToStmt(PreparedStatement stmt, int index, Date value) throws SQLException {
        if (value == null) {
            stmt.setTimestamp(index, null);
        } else if (value instanceof Timestamp) {
            Timestamp t = (Timestamp)value;
            stmt.setTimestamp(index, t);
        } else {
            stmt.setTimestamp(index, new Timestamp(value.getTime()));
        }
    }
}

