/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.mentabean.DBType;

public class IntegerType
implements DBType<Integer> {
    private boolean canBeNull = true;

    @Override
    public boolean canBeNull() {
        return this.canBeNull;
    }

    public IntegerType nullable(boolean flag) {
        IntegerType d = new IntegerType();
        d.canBeNull = flag;
        return d;
    }

    @Override
    public String getAnsiType() {
        return "integer";
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Integer getFromResultSet(ResultSet rset, int index) throws SQLException {
        Integer x = rset.getInt(index);
        if (rset.wasNull()) {
            return null;
        }
        return x;
    }

    @Override
    public Integer getFromResultSet(ResultSet rset, String field) throws SQLException {
        Integer x = rset.getInt(field);
        if (rset.wasNull()) {
            return null;
        }
        return x;
    }

    @Override
    public Class<? extends Object> getTypeClass() {
        return Integer.class;
    }

    @Override
    public void bindToStmt(PreparedStatement stmt, int index, Integer value) throws SQLException {
        if (value == null) {
            stmt.setNull(index, 4);
        } else {
            stmt.setInt(index, value);
        }
    }
}

