/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.mentabean.BeanConfig;
import org.mentabean.BeanException;
import org.mentabean.BeanManager;
import org.mentabean.DBField;
import org.mentabean.DBType;
import org.mentabean.jdbc.AnsiSQLBeanSession;
import org.mentabean.type.AutoIncrementType;
import org.mentabean.util.Limit;
import org.mentabean.util.OrderBy;

public class H2BeanSession
extends AnsiSQLBeanSession {
    public H2BeanSession(BeanManager beanManager, Connection conn) {
        super(beanManager, conn);
    }

    @Override
    protected String getCurrentTimestampCommand() {
        return "sysdate";
    }

    @Override
    protected StringBuilder handleLimit(StringBuilder sb, OrderBy orderBy, Limit limit) {
        if (limit == null || limit.intValue() <= 0) {
            return sb;
        }
        StringBuilder sbLimit = new StringBuilder(sb.length() + 32);
        sbLimit.append(sb.toString()).append(" LIMIT ").append(limit);
        return sbLimit;
    }

    @Override
    protected String getDatabaseType(DBType<?> dbType) {
        if (dbType instanceof AutoIncrementType) {
            return "integer AUTO_INCREMENT";
        }
        return super.getDatabaseType(dbType);
    }

    @Override
    public void insert(Object bean) {
        ResultSet rset;
        PreparedStatement stmt;
        block18: {
            long id;
            BeanConfig bc = this.beanManager.getBeanConfig(bean.getClass());
            if (bc == null) {
                throw new BeanException("Cannot find bean config: " + bean.getClass());
            }
            DBField seqField = bc.getSequenceField();
            if (seqField != null) {
                ResultSet rset2;
                PreparedStatement stmt2;
                block17: {
                    stmt2 = null;
                    rset2 = null;
                    StringBuilder sb = new StringBuilder(128);
                    sb.append("select NEXTVAL(");
                    String seqName = bc.getSequenceName();
                    if (seqName != null) {
                        sb.append(seqName);
                    } else {
                        sb.append("seq_").append(seqField.getDbName()).append("_").append(bc.getTableName());
                    }
                    sb.append(") from ").append(bc.getTableName());
                    try {
                        stmt2 = this.conn.prepareStatement(sb.toString());
                        rset2 = stmt2.executeQuery();
                        if (!rset2.next()) break block17;
                        id = rset2.getLong(1);
                        try {
                            H2BeanSession.injectValue(bean, seqField.getName(), id, Integer.class);
                        }
                        catch (Exception e) {
                            H2BeanSession.injectValue(bean, seqField.getName(), id, Long.class);
                        }
                    }
                    catch (Exception e) {
                        try {
                            throw new BeanException(e);
                        }
                        catch (Throwable throwable) {
                            H2BeanSession.close(stmt2, rset2);
                            throw throwable;
                        }
                    }
                }
                H2BeanSession.close(stmt2, rset2);
            }
            super.insert(bean);
            DBField autoIncrement = bc.getAutoIncrementField();
            if (autoIncrement == null) {
                return;
            }
            stmt = null;
            rset = null;
            StringBuilder sb = new StringBuilder("select identity() from ");
            sb.append(bc.getTableName());
            try {
                stmt = this.conn.prepareStatement(sb.toString());
                rset = stmt.executeQuery();
                if (!rset.next()) break block18;
                id = rset.getLong(1);
                try {
                    H2BeanSession.injectValue(bean, autoIncrement.getName(), id, Integer.class);
                }
                catch (Exception e) {
                    H2BeanSession.injectValue(bean, autoIncrement.getName(), id, Long.class);
                }
            }
            catch (Exception e) {
                try {
                    throw new BeanException(e);
                }
                catch (Throwable throwable) {
                    H2BeanSession.close(stmt, rset);
                    throw throwable;
                }
            }
        }
        H2BeanSession.close(stmt, rset);
    }
}

