/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.jdbc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mentabean.BeanConfig;
import org.mentabean.BeanException;
import org.mentabean.BeanManager;
import org.mentabean.BeanSession;
import org.mentabean.DBField;
import org.mentabean.DBType;
import org.mentabean.type.AutoIncrementType;
import org.mentabean.type.AutoTimestampType;
import org.mentabean.type.NowOnInsertAndUpdateTimestampType;
import org.mentabean.type.NowOnInsertTimestampType;
import org.mentabean.type.NowOnUpdateTimestampType;
import org.mentabean.type.SizedType;
import org.mentabean.util.InjectionUtils;
import org.mentabean.util.Limit;
import org.mentabean.util.OrderBy;
import org.mentabean.util.PropertiesProxy;
import org.mentabean.util.SQLUtils;

public class AnsiSQLBeanSession
implements BeanSession {
    protected static boolean DEBUG = false;
    protected IdentityHashMap<Object, Map<String, Value>> loaded = new IdentityHashMap();
    protected Connection conn;
    protected final BeanManager beanManager;

    public AnsiSQLBeanSession(BeanManager beanManager, Connection conn) {
        this.beanManager = beanManager;
        this.conn = conn;
    }

    public static void debugSql(boolean b) {
        DEBUG = b;
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    protected String getCurrentTimestampCommand() {
        return null;
    }

    protected static Object getValueFromBean(Object bean, String fieldName) {
        return AnsiSQLBeanSession.getValueFromBean(bean, fieldName, null);
    }

    public static String[] getProperties(Object[] names) {
        if (names != null) {
            for (Object o : names) {
                if (!(o instanceof String)) continue;
                PropertiesProxy.addPropertyName((String)o);
            }
        }
        if (PropertiesProxy.hasProperties()) {
            return PropertiesProxy.getPropertyNames();
        }
        return null;
    }

    protected static Object getValueFromBean(Object bean, String fieldName, Method m) {
        int index = fieldName.lastIndexOf(".");
        if (index > 0) {
            String chain = fieldName.substring(0, index);
            String lastField = fieldName.substring(index + 1);
            Object deepestBean = AnsiSQLBeanSession.getDeepestBean(bean, chain, false);
            if (deepestBean == null) {
                return null;
            }
            return AnsiSQLBeanSession.getValueFromBean(deepestBean, lastField, m);
        }
        if (m == null) {
            m = InjectionUtils.findMethodToGet(bean.getClass(), fieldName);
        }
        if (m == null) {
            throw new BeanException("Cannot find method to get field from bean: Class: " + bean.getClass() + ", field: " + fieldName);
        }
        Object value = null;
        try {
            value = m.invoke(bean, (Object[])null);
            return value;
        }
        catch (Exception e) {
            throw new BeanException(e);
        }
    }

    private static void checkPK(Object value, DBField dbField) {
        Number n;
        if (value == null) {
            throw new BeanException("pk is missing: " + dbField);
        }
        if (value instanceof Number && (n = (Number)value).doubleValue() <= 0.0) {
            throw new BeanException("Number pk is missing: " + dbField);
        }
    }

    @Override
    public boolean load(Object bean) {
        return this.loadImpl(bean, null, null);
    }

    @Override
    public boolean load(Object bean, Object ... properties) {
        return this.loadImpl(bean, AnsiSQLBeanSession.getProperties(properties), null);
    }

    @Override
    public boolean loadMinus(Object bean, Object ... minus) {
        return this.loadImpl(bean, null, AnsiSQLBeanSession.getProperties(minus));
    }

    protected boolean loadImpl(Object bean, String[] properties, String[] minus) {
        boolean bl;
        HashMap<String, Value> fieldsLoaded;
        ResultSet rset;
        PreparedStatement stmt;
        block19: {
            BeanConfig bc = this.beanManager.getBeanConfig(bean.getClass());
            if (bc == null) {
                throw new BeanException("Cannot find bean config: " + bean.getClass());
            }
            if (bc.getNumberOfFields() == 0) {
                throw new BeanException("BeanConfig has zero fields: " + bc);
            }
            StringBuilder sb = new StringBuilder(32 * bc.getNumberOfFields());
            sb.append("SELECT ");
            Iterator<DBField> iter = bc.fields();
            int count = 0;
            while (iter.hasNext()) {
                DBField field = iter.next();
                String fieldName = field.getDbName();
                if (!field.isPK() && (properties != null && !AnsiSQLBeanSession.checkArray(fieldName, properties) || minus != null && AnsiSQLBeanSession.checkArray(fieldName, minus))) continue;
                if (count++ > 0) {
                    sb.append(',');
                }
                sb.append(fieldName);
            }
            sb.append(" FROM ").append(bc.getTableName()).append(" WHERE ");
            if (!bc.hasPK()) {
                throw new BeanException("Cannot load bean without a PK!");
            }
            iter = bc.pks();
            count = 0;
            LinkedList<Value> values = new LinkedList<Value>();
            while (iter.hasNext()) {
                DBField dbField = iter.next();
                String fieldName = dbField.getName();
                String dbFieldName = dbField.getDbName();
                Object value = AnsiSQLBeanSession.getValueFromBean(bean, fieldName);
                AnsiSQLBeanSession.checkPK(value, dbField);
                if (count++ > 0) {
                    sb.append(" AND ");
                }
                sb.append(dbFieldName).append("=?");
                values.add(new Value(dbField, value));
            }
            if (values.isEmpty()) {
                throw new BeanException("Bean is empty: " + bean + " / " + bc);
            }
            if (this.conn == null) {
                throw new BeanException("Connection is null!");
            }
            stmt = null;
            rset = null;
            if (DEBUG) {
                System.out.println("LOAD SQL: " + sb.toString());
            }
            stmt = this.conn.prepareStatement(sb.toString());
            Iterator iter2 = values.iterator();
            int index = 0;
            while (iter2.hasNext()) {
                Value v = (Value)iter2.next();
                v.field.getType().bindToStmt(stmt, ++index, v.value);
            }
            rset = stmt.executeQuery();
            index = 0;
            fieldsLoaded = new HashMap<String, Value>();
            if (rset.next()) {
                iter = bc.fields();
                while (iter.hasNext()) {
                    DBField f = iter.next();
                    String fieldName = f.getName();
                    if (!f.isPK() && (properties != null && !AnsiSQLBeanSession.checkArray(fieldName, properties) || minus != null && AnsiSQLBeanSession.checkArray(fieldName, minus))) continue;
                    DBType type = f.getType();
                    Object value = type.getFromResultSet(rset, ++index);
                    AnsiSQLBeanSession.injectValue(bean, fieldName, value, type.getTypeClass());
                    fieldsLoaded.put(fieldName, new Value(f, value));
                }
                break block19;
            }
            boolean bl2 = false;
            AnsiSQLBeanSession.close(stmt, rset);
            return bl2;
        }
        try {
            if (rset.next()) {
                throw new BeanException("Load returned more than one row!");
            }
            this.loaded.put(bean, fieldsLoaded);
            bl = true;
        }
        catch (Exception e) {
            try {
                throw new BeanException(e);
            }
            catch (Throwable throwable) {
                AnsiSQLBeanSession.close(stmt, rset);
                throw throwable;
            }
        }
        AnsiSQLBeanSession.close(stmt, rset);
        return bl;
    }

    private static Object getDeepestBean(Object target, String name, boolean create) {
        int index = name.indexOf(46);
        if (index > 0) {
            String fieldName = name.substring(0, index);
            String remainingName = name.substring(index + 1);
            Object bean = AnsiSQLBeanSession.getPropertyBean(target, fieldName, create);
            return AnsiSQLBeanSession.getDeepestBean(bean, remainingName, create);
        }
        return AnsiSQLBeanSession.getPropertyBean(target, name, create);
    }

    private static Object getPropertyBean(Object target, String name, boolean create) {
        Object value = AnsiSQLBeanSession.getValueFromBean(target, name);
        if (value == null && create) {
            Class<?> beanClass = InjectionUtils.findPropertyType(target.getClass(), name);
            if (beanClass == null) {
                throw new BeanException("Cannot find property type: " + target.getClass() + " " + name);
            }
            try {
                value = beanClass.newInstance();
            }
            catch (Exception e) {
                throw new BeanException("Cannot instantiate property type: " + beanClass, e);
            }
            AnsiSQLBeanSession.injectValue(target, name, value, beanClass);
        }
        return value;
    }

    protected static void injectValue(Object bean, String fieldName, Object value, Class<? extends Object> valueType) {
        int index = fieldName.lastIndexOf(".");
        if (index > 0) {
            if (value == null) {
                return;
            }
            String chain = fieldName.substring(0, index);
            String lastField = fieldName.substring(index + 1);
            Object deepestBean = AnsiSQLBeanSession.getDeepestBean(bean, chain, true);
            AnsiSQLBeanSession.injectValue(deepestBean, lastField, value, valueType);
            return;
        }
        Method m = InjectionUtils.findMethodToInject(bean.getClass(), fieldName, value == null ? valueType : value.getClass());
        if (m == null) {
            Long l;
            Field field = InjectionUtils.findFieldToInject(bean.getClass(), fieldName, value == null ? valueType : value.getClass());
            if (field != null) {
                if (field.getType().isPrimitive() && value == null) {
                    value = InjectionUtils.getDefaultValueForPrimitive(field.getType());
                }
                try {
                    field.set(bean, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BeanException(e);
                }
            }
            if (value instanceof Long && (l = (Long)value) <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                AnsiSQLBeanSession.injectValue(bean, fieldName, l.intValue(), Integer.class);
                return;
            }
            throw new BeanException("Cannot find field or method to inject: " + bean + " / " + fieldName);
        }
        Class<?> paramType = m.getParameterTypes()[0];
        if (paramType.isPrimitive() && value == null) {
            value = InjectionUtils.getDefaultValueForPrimitive(paramType);
        }
        try {
            m.invoke(bean, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BeanException(e);
        }
    }

    protected StringBuilder handleLimit(StringBuilder sb, OrderBy orderBy, Limit limit) {
        return sb;
    }

    @Override
    public String buildSelect(Class<? extends Object> beanClass) {
        return this.buildSelectImpl(beanClass, null, null, null);
    }

    @Override
    public String buildSelect(Class<? extends Object> beanClass, Object ... properties) {
        return this.buildSelectImpl(beanClass, null, AnsiSQLBeanSession.getProperties(properties), null);
    }

    @Override
    public String buildSelect(Class<? extends Object> beanClass, String tablePrefix) {
        return this.buildSelectImpl(beanClass, tablePrefix, null, null);
    }

    @Override
    public String buildSelect(Class<? extends Object> beanClass, String tablePrefix, Object ... properties) {
        return this.buildSelectImpl(beanClass, tablePrefix, AnsiSQLBeanSession.getProperties(properties), null);
    }

    @Override
    public String buildSelectMinus(Class<? extends Object> beanClass, Object ... minus) {
        return this.buildSelectImpl(beanClass, null, null, AnsiSQLBeanSession.getProperties(minus));
    }

    @Override
    public String buildSelectMinus(Class<? extends Object> beanClass, String tablePrefix, Object ... minus) {
        return this.buildSelectImpl(beanClass, tablePrefix, null, AnsiSQLBeanSession.getProperties(minus));
    }

    private String buildSelectImpl(Class<? extends Object> beanClass, String tablePrefix, String[] properties, String[] minus) {
        BeanConfig bc = this.beanManager.getBeanConfig(beanClass);
        if (bc == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(32 * bc.getNumberOfFields());
        Iterator<DBField> iter = bc.fields();
        int count = 0;
        while (iter.hasNext()) {
            DBField field = iter.next();
            String dbField = field.getDbName();
            String name = field.getName();
            if (!field.isPK() && (properties != null && !AnsiSQLBeanSession.checkArray(name, properties) || minus != null && AnsiSQLBeanSession.checkArray(name, minus))) continue;
            if (count++ > 0) {
                sb.append(",");
            }
            if (tablePrefix != null) {
                sb.append(tablePrefix).append('.');
                sb.append(dbField).append(' ');
                sb.append(tablePrefix).append('_').append(dbField);
                continue;
            }
            sb.append(dbField);
        }
        return sb.toString();
    }

    private static boolean checkArray(String value, String[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void populateBean(ResultSet rset, Object bean) {
        this.populateBeanImpl(rset, bean, null, null, null);
    }

    @Override
    public void populateBean(ResultSet rset, Object bean, Object ... properties) {
        this.populateBeanImpl(rset, bean, null, AnsiSQLBeanSession.getProperties(properties), null);
    }

    @Override
    public void populateBean(ResultSet rset, Object bean, String tablePrefix) {
        this.populateBeanImpl(rset, bean, tablePrefix, null, null);
    }

    @Override
    public void populateBean(ResultSet rset, Object bean, String tablePrefix, Object ... properties) {
        this.populateBeanImpl(rset, bean, tablePrefix, AnsiSQLBeanSession.getProperties(properties), null);
    }

    @Override
    public void populateBeanMinus(ResultSet rset, Object bean, Object ... minus) {
        this.populateBeanImpl(rset, bean, null, null, AnsiSQLBeanSession.getProperties(minus));
    }

    @Override
    public void populateBeanMinus(ResultSet rset, Object bean, String tablePrefix, Object ... minus) {
        this.populateBeanImpl(rset, bean, tablePrefix, null, AnsiSQLBeanSession.getProperties(minus));
    }

    private void populateBeanImpl(ResultSet rset, Object bean, String tablePrefix, String[] properties, String[] minus) {
        BeanConfig bc = this.beanManager.getBeanConfig(bean.getClass());
        if (bc == null) {
            throw new BeanException("Cannot find bean config: " + bean.getClass());
        }
        Iterator<DBField> iter = bc.fields();
        StringBuilder sbField = new StringBuilder(32);
        while (iter.hasNext()) {
            DBField f = iter.next();
            String fieldName = f.getName();
            if (!f.isPK() && (properties != null && !AnsiSQLBeanSession.checkArray(fieldName, properties) || minus != null && AnsiSQLBeanSession.checkArray(fieldName, minus))) continue;
            String dbFieldName = f.getDbName();
            DBType type = f.getType();
            sbField.setLength(0);
            if (tablePrefix != null) {
                sbField.append(tablePrefix).append('_').append(dbFieldName);
            } else {
                sbField.append(dbFieldName);
            }
            try {
                Object value = type.getFromResultSet(rset, sbField.toString());
                AnsiSQLBeanSession.injectValue(bean, fieldName, value, type.getTypeClass());
            }
            catch (Exception e) {
                throw new BeanException(e);
            }
        }
    }

    @Override
    public <E> List<E> loadListMinus(E bean, OrderBy orderBy, Limit limit, Object ... minus) {
        return this.loadListImpl(bean, orderBy, limit, null, AnsiSQLBeanSession.getProperties(minus));
    }

    private <E> E checkUnique(List<E> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            throw new BeanException("Query returned more than one bean!");
        }
        return list.get(0);
    }

    @Override
    public <E> List<E> loadList(E bean, OrderBy orderBy, Limit limit) {
        return this.loadListImpl(bean, orderBy, limit, null, null);
    }

    @Override
    public <E> List<E> loadList(E bean, OrderBy orderBy, Limit limit, Object ... properties) {
        return this.loadListImpl(bean, orderBy, limit, AnsiSQLBeanSession.getProperties(properties), null);
    }

    private <E> StringBuilder prepareListQuery(StringBuilder sb, BeanConfig bc, E bean, OrderBy orderBy, Limit limit, List<Value> values) {
        sb.append(" FROM ").append(bc.getTableName()).append(" ");
        Iterator<DBField> iter = bc.fields();
        int count = 0;
        while (iter.hasNext()) {
            DBField field = iter.next();
            String dbField = field.getDbName();
            Method m = AnsiSQLBeanSession.findMethodToGet(bean, field.getName());
            boolean isNestedProperty = field.getName().contains(".");
            if (m == null) {
                if (isNestedProperty) continue;
                throw new BeanException("Cannot find method to get field from bean: " + field.getName());
            }
            Class<?> returnType = m.getReturnType();
            Object value = AnsiSQLBeanSession.getValueFromBean(bean, field.getName(), m);
            if (!this.isSet(value, returnType)) continue;
            if (count++ > 0) {
                sb.append(" AND ");
            } else {
                sb.append(" WHERE ");
            }
            sb.append(dbField).append("=?");
            values.add(new Value(field, value));
        }
        if (orderBy != null && !orderBy.isEmpty()) {
            String[] orders;
            String orderByString = orderBy.toString();
            for (String order : orders = orderByString.trim().split("\\s*,\\s*")) {
                if (order.contains(" ")) {
                    order = order.substring(0, order.indexOf(" "));
                }
                orderByString = orderByString.replace(order, this.propertyToColumn(bc, order));
            }
            sb.append(" order by ").append(orderByString).append(" ");
        }
        sb = this.handleLimit(sb, orderBy, limit);
        return sb;
    }

    private String propertyToColumn(BeanConfig bc, String propertyName) {
        Iterator<DBField> it = bc.fields();
        while (it.hasNext()) {
            DBField field = it.next();
            if (!propertyName.equalsIgnoreCase(field.getName())) continue;
            return field.getDbName();
        }
        return propertyName;
    }

    @Override
    public int countList(Object bean) {
        return this.countListImpl(bean, null, null);
    }

    private int countListImpl(Object bean, OrderBy orderBy, Limit limit) {
        int n;
        if (limit != null && limit.intValue() == 0) {
            return 0;
        }
        BeanConfig bc = this.beanManager.getBeanConfig(bean.getClass());
        if (bc == null) {
            throw new BeanException("Cannot find bean config: " + bean.getClass());
        }
        StringBuilder sb = new StringBuilder(32 * bc.getNumberOfFields());
        sb.append("SELECT count(1)");
        LinkedList<Value> values = new LinkedList<Value>();
        sb = this.prepareListQuery(sb, bc, bean, orderBy, limit, values);
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            String sql = sb.toString();
            if (DEBUG) {
                System.out.println("COUNT LIST: " + sql);
            }
            stmt = this.conn.prepareStatement(sql);
            Iterator iter2 = values.iterator();
            int index = 0;
            while (iter2.hasNext()) {
                Value v = (Value)iter2.next();
                v.field.getType().bindToStmt(stmt, ++index, v.value);
            }
            rset = stmt.executeQuery();
            rset.next();
            n = rset.getInt(1);
        }
        catch (Exception e) {
            try {
                throw new BeanException(e);
            }
            catch (Throwable throwable) {
                AnsiSQLBeanSession.close(stmt, rset);
                throw throwable;
            }
        }
        AnsiSQLBeanSession.close(stmt, rset);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <E> List<E> loadListImpl(E bean, OrderBy orderBy, Limit limit, String[] properties, String[] minus) {
        if (limit != null && limit.intValue() == 0) {
            return new ArrayList();
        }
        BeanConfig bc = this.beanManager.getBeanConfig(bean.getClass());
        if (bc == null) {
            throw new BeanException("Cannot find bean config: " + bean.getClass());
        }
        StringBuilder sb = new StringBuilder(32 * bc.getNumberOfFields());
        Iterator<DBField> iter = bc.fields();
        sb.append("SELECT ");
        int count = 0;
        while (iter.hasNext()) {
            DBField field = iter.next();
            String dbField = field.getDbName();
            String name = field.getName();
            if (!field.isPK() && (properties != null && !AnsiSQLBeanSession.checkArray(name, properties) || minus != null && AnsiSQLBeanSession.checkArray(name, minus))) continue;
            if (count++ > 0) {
                sb.append(",");
            }
            sb.append(dbField);
        }
        LinkedList<Value> values = new LinkedList<Value>();
        sb = this.prepareListQuery(sb, bc, bean, orderBy, limit, values);
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            String sql = sb.toString();
            if (DEBUG) {
                System.out.println("LOAD LIST: " + sql);
            }
            stmt = this.conn.prepareStatement(sql);
            Iterator iter2 = values.iterator();
            int index = 0;
            while (iter2.hasNext()) {
                Value v = (Value)iter2.next();
                v.field.getType().bindToStmt(stmt, ++index, v.value);
            }
            rset = stmt.executeQuery();
            LinkedList results = new LinkedList();
            Class<?> beanKlass = bean.getClass();
            int total = 0;
            do {
                Object item;
                if (rset.next()) {
                    iter = bc.fields();
                    index = 0;
                    item = beanKlass.newInstance();
                } else {
                    LinkedList linkedList = results;
                    AnsiSQLBeanSession.close(stmt, rset);
                    return linkedList;
                }
                while (iter.hasNext()) {
                    DBField f = iter.next();
                    String fieldName = f.getName();
                    if (!f.isPK() && (properties != null && !AnsiSQLBeanSession.checkArray(fieldName, properties) || minus != null && AnsiSQLBeanSession.checkArray(fieldName, minus))) continue;
                    DBType type = f.getType();
                    Object value = type.getFromResultSet(rset, ++index);
                    AnsiSQLBeanSession.injectValue(item, fieldName, value, type.getTypeClass());
                }
                results.add(item);
            } while (limit == null || limit.intValue() <= 0 || ++total != limit.intValue());
            LinkedList linkedList = results;
            AnsiSQLBeanSession.close(stmt, rset);
            return linkedList;
        }
        catch (Exception e) {
            try {
                throw new BeanException(e);
            }
            catch (Throwable throwable) {
                AnsiSQLBeanSession.close(stmt, rset);
                throw throwable;
            }
        }
    }

    protected boolean isSet(Object value, Class<? extends Object> returnType) {
        if (value != null) {
            if (returnType.equals(Boolean.TYPE) && value instanceof Boolean) {
                boolean b = (Boolean)value;
                return b;
            }
            if (returnType.equals(Character.TYPE) && value instanceof Character) {
                char c = ((Character)value).charValue();
                return c != '\u0000';
            }
            if (returnType.isPrimitive() && !returnType.equals(Boolean.TYPE) && !returnType.equals(Character.TYPE) && value instanceof Number) {
                Number n = (Number)value;
                if (n.intValue() != 0) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    public int update(Object bean) {
        return this.update(bean, true);
    }

    @Override
    public int updateAll(Object bean) {
        return this.update(bean, false);
    }

    private int update(Object bean, boolean dynUpdate) {
        int n;
        PreparedStatement stmt;
        LinkedList<Value> values;
        Map<String, Value> fieldsLoaded;
        block32: {
            DBField dbField;
            fieldsLoaded = this.loaded.get(bean);
            BeanConfig bc = this.beanManager.getBeanConfig(bean.getClass());
            if (bc == null) {
                throw new BeanException("Cannot find bean config: " + bean.getClass());
            }
            if (bc.getNumberOfFields() == 0) {
                throw new BeanException("BeanConfig has zero fields: " + bc);
            }
            StringBuilder sb = new StringBuilder(32 * bc.getNumberOfFields());
            sb.append("UPDATE ").append(bc.getTableName()).append(" SET ");
            Iterator<DBField> iter = bc.fields();
            int count = 0;
            values = new LinkedList<Value>();
            while (iter.hasNext()) {
                DBType type;
                dbField = iter.next();
                if (dbField.isPK() || (type = dbField.getType()) instanceof AutoIncrementType || type instanceof AutoTimestampType) continue;
                boolean isNowOnUpdate = type instanceof NowOnUpdateTimestampType || type instanceof NowOnInsertAndUpdateTimestampType;
                String fieldName = dbField.getName();
                String dbFieldName = dbField.getDbName();
                if (!isNowOnUpdate) {
                    Method m = AnsiSQLBeanSession.findMethodToGet(bean, fieldName);
                    Object value = null;
                    Class<?> returnType = null;
                    boolean isNestedProperty = fieldName.contains(".");
                    if (m == null && !isNestedProperty) {
                        throw new BeanException("Cannot find method to get field from bean: " + fieldName);
                    }
                    if (m != null) {
                        returnType = m.getReturnType();
                        value = AnsiSQLBeanSession.getValueFromBean(bean, fieldName, m);
                    }
                    boolean update = false;
                    if (!dynUpdate) {
                        update = true;
                    } else if (fieldsLoaded != null) {
                        Value v = fieldsLoaded.get(fieldName);
                        if (v != null) {
                            update = value == null && v.value != null ? true : (value != null && v.value == null ? true : (value == null && v.value == null ? false : !value.equals(v.value)));
                        }
                    } else {
                        update = this.isSet(value, returnType);
                    }
                    if (!update) continue;
                    if (count++ > 0) {
                        sb.append(',');
                    }
                    sb.append(dbFieldName).append("=?");
                    values.add(new Value(dbField, value));
                    continue;
                }
                if (count++ > 0) {
                    sb.append(',');
                }
                sb.append(dbFieldName).append("=");
                String nowCommand = this.getCurrentTimestampCommand();
                if (nowCommand == null) {
                    sb.append("?");
                    values.add(new Value(dbField, new Date()));
                    continue;
                }
                sb.append(nowCommand);
            }
            if (count == 0) {
                return 0;
            }
            sb.append(" WHERE ");
            if (!bc.hasPK()) {
                throw new BeanException("Cannot update bean without a PK!");
            }
            iter = bc.pks();
            count = 0;
            while (iter.hasNext()) {
                Number n2;
                dbField = iter.next();
                String fieldName = dbField.getName();
                String dbFieldName = dbField.getDbName();
                Object value = AnsiSQLBeanSession.getValueFromBean(bean, fieldName);
                if (value == null) {
                    throw new BeanException("pk is missing: " + dbField);
                }
                if (value instanceof Number && (n2 = (Number)value).doubleValue() <= 0.0) {
                    throw new BeanException("Number pk is missing: " + dbField);
                }
                if (count++ > 0) {
                    sb.append(" AND ");
                }
                sb.append(dbFieldName).append("=?");
                values.add(new Value(dbField, value));
            }
            if (values.isEmpty()) {
                throw new BeanException("Bean is empty: " + bean + " / " + bc);
            }
            if (this.conn == null) {
                throw new BeanException("Connection is null!");
            }
            stmt = null;
            if (DEBUG) {
                System.out.println("UPDATE SQL: " + sb.toString());
            }
            stmt = this.conn.prepareStatement(sb.toString());
            Iterator iter2 = values.iterator();
            int index = 0;
            while (iter2.hasNext()) {
                Value v = (Value)iter2.next();
                v.field.getType().bindToStmt(stmt, ++index, v.value);
            }
            int x = stmt.executeUpdate();
            if (x > 1) {
                throw new BeanException("update modified more than one line: " + x);
            }
            if (x != 0) break block32;
            int n2 = 0;
            AnsiSQLBeanSession.close(stmt);
            return n2;
        }
        try {
            if (fieldsLoaded != null) {
                for (Value v : values) {
                    Value vv;
                    if (v.field.isPK() || (vv = fieldsLoaded.get(v.field.getName())) == null) continue;
                    vv.value = v.value;
                }
            }
            n = 1;
        }
        catch (Exception e) {
            try {
                throw new BeanException(e);
            }
            catch (Throwable throwable) {
                AnsiSQLBeanSession.close(stmt);
                throw throwable;
            }
        }
        AnsiSQLBeanSession.close(stmt);
        return n;
    }

    private static Method findMethodToGet(Object bean, String fieldName) {
        Method m = null;
        int index = fieldName.lastIndexOf(".");
        if (index > 0) {
            String chain = fieldName.substring(0, index);
            String lastField = fieldName.substring(index + 1);
            Object deepestBean = AnsiSQLBeanSession.getDeepestBean(bean, chain, false);
            if (deepestBean != null) {
                m = InjectionUtils.findMethodToGet(deepestBean.getClass(), lastField);
            }
        } else {
            m = InjectionUtils.findMethodToGet(bean.getClass(), fieldName);
        }
        return m;
    }

    protected QueryAndValues prepareInsertQuery(Object bean) {
        DBType type;
        String dbFieldName;
        String fieldName;
        DBField dbField;
        BeanConfig bc = this.beanManager.getBeanConfig(bean.getClass());
        if (bc == null) {
            throw new BeanException("Cannot find bean config: " + bean.getClass());
        }
        if (bc.getNumberOfFields() == 0) {
            throw new BeanException("BeanConfig has zero fields: " + bc);
        }
        StringBuilder sb = new StringBuilder(32 * bc.getNumberOfFields());
        sb.append("INSERT INTO ").append(bc.getTableName()).append("(");
        Iterator<DBField> iter = bc.pks();
        int count = 0;
        LinkedList<Value> values = new LinkedList<Value>();
        while (iter.hasNext()) {
            dbField = iter.next();
            fieldName = dbField.getName();
            dbFieldName = dbField.getDbName();
            type = dbField.getType();
            if (type instanceof AutoIncrementType || type instanceof AutoTimestampType || type instanceof NowOnUpdateTimestampType) continue;
            Object value = AnsiSQLBeanSession.getValueFromBean(bean, fieldName);
            if (count++ > 0) {
                sb.append(',');
            }
            sb.append(dbFieldName);
            values.add(new Value(dbField, value));
        }
        iter = bc.fields();
        while (iter.hasNext()) {
            boolean isNowOnInsert;
            dbField = iter.next();
            if (dbField.isPK()) continue;
            fieldName = dbField.getName();
            dbFieldName = dbField.getDbName();
            type = dbField.getType();
            if (type instanceof AutoIncrementType || type instanceof AutoTimestampType || type instanceof NowOnUpdateTimestampType) continue;
            boolean bl = isNowOnInsert = type instanceof NowOnInsertTimestampType || type instanceof NowOnInsertAndUpdateTimestampType;
            if (!isNowOnInsert) {
                Object value = AnsiSQLBeanSession.getValueFromBean(bean, fieldName);
                if (count++ > 0) {
                    sb.append(',');
                }
                sb.append(dbFieldName);
                values.add(new Value(dbField, value));
                continue;
            }
            if (count++ > 0) {
                sb.append(',');
            }
            sb.append(dbFieldName);
            String cmd = this.getCurrentTimestampCommand();
            if (cmd == null) {
                values.add(new Value(dbField, new Date()));
                continue;
            }
            values.add(new Value(dbField, true));
        }
        if (count == 0) {
            throw new BeanException("There is nothing to insert!");
        }
        sb.append(") VALUES(");
        Iterator valuesIter = values.iterator();
        int i = 0;
        while (valuesIter.hasNext()) {
            Value v = (Value)valuesIter.next();
            if (i > 0) {
                sb.append(',');
            }
            if (v.isSysdate) {
                sb.append(this.getCurrentTimestampCommand());
            } else {
                sb.append('?');
            }
            ++i;
        }
        sb.append(')');
        if (values.isEmpty()) {
            throw new BeanException("Bean is empty: " + bean + " / " + bc);
        }
        return new QueryAndValues(sb, values);
    }

    protected Map<String, Value> bindToInsertStatement(PreparedStatement stmt, List<Value> values) {
        Iterator<Value> iter2 = values.iterator();
        int index = 0;
        HashMap<String, Value> fieldsLoaded = new HashMap<String, Value>();
        while (iter2.hasNext()) {
            Value v = iter2.next();
            if (v.isSysdate && this.getCurrentTimestampCommand() != null) continue;
            try {
                v.field.getType().bindToStmt(stmt, ++index, v.value);
            }
            catch (Exception e) {
                throw new BeanException(e);
            }
            fieldsLoaded.put(v.field.getName(), v);
        }
        return fieldsLoaded;
    }

    @Override
    public void insert(Object bean) {
        QueryAndValues qav = this.prepareInsertQuery(bean);
        StringBuilder sb = qav.sb;
        List<Value> values = qav.values;
        if (this.conn == null) {
            throw new BeanException("Connection is null!");
        }
        PreparedStatement stmt = null;
        try {
            if (DEBUG) {
                System.out.println("INSERT SQL: " + sb.toString());
            }
            stmt = this.conn.prepareStatement(sb.toString());
            Map<String, Value> fieldsLoaded = this.bindToInsertStatement(stmt, values);
            int x = stmt.executeUpdate();
            if (x > 1) {
                throw new BeanException("insert modified more than one line: " + x);
            }
            if (x == 0) {
                throw new BeanException("Nothing was inserted! Insert returned 0 rows!");
            }
            this.loaded.put(bean, fieldsLoaded);
        }
        catch (Exception e) {
            try {
                throw new BeanException(e);
            }
            catch (Throwable throwable) {
                AnsiSQLBeanSession.close(stmt);
                throw throwable;
            }
        }
        AnsiSQLBeanSession.close(stmt);
    }

    @Override
    public boolean delete(Object bean) {
        boolean bl;
        PreparedStatement stmt;
        block16: {
            BeanConfig bc = this.beanManager.getBeanConfig(bean.getClass());
            if (bc.getNumberOfFields() == 0) {
                throw new BeanException("BeanConfig has zero fields: " + bc);
            }
            StringBuilder sb = new StringBuilder(32 * bc.getNumberOfFields());
            sb.append("DELETE FROM ").append(bc.getTableName()).append(" WHERE ");
            if (!bc.hasPK()) {
                throw new BeanException("Cannot delete bean without a PK!");
            }
            Iterator<DBField> iter = bc.pks();
            LinkedList<Value> values = new LinkedList<Value>();
            int count = 0;
            while (iter.hasNext()) {
                Number n;
                DBField dbField = iter.next();
                String fieldName = dbField.getName();
                String dbFieldName = dbField.getDbName();
                Object value = AnsiSQLBeanSession.getValueFromBean(bean, fieldName);
                if (value == null) {
                    throw new BeanException("pk is missing: " + dbField);
                }
                if (value instanceof Number && (n = (Number)value).doubleValue() <= 0.0) {
                    throw new BeanException("Number pk is missing: " + dbField);
                }
                if (count++ > 0) {
                    sb.append(" AND ");
                }
                sb.append(dbFieldName).append("=?");
                values.add(new Value(dbField, value));
            }
            if (values.isEmpty()) {
                throw new BeanException("Bean is empty: " + bean + " / " + bc);
            }
            if (this.conn == null) {
                throw new BeanException("Connection is null!");
            }
            stmt = null;
            if (DEBUG) {
                System.out.println("DELETE SQL: " + sb.toString());
            }
            stmt = this.conn.prepareStatement(sb.toString());
            Iterator iter2 = values.iterator();
            int index = 0;
            while (iter2.hasNext()) {
                Value v = (Value)iter2.next();
                v.field.getType().bindToStmt(stmt, ++index, v.value);
            }
            int x = stmt.executeUpdate();
            if (x > 1) {
                throw new BeanException("delete modified more than one line: " + x);
            }
            if (x != 0) break block16;
            boolean bl2 = false;
            AnsiSQLBeanSession.close(stmt);
            return bl2;
        }
        try {
            this.loaded.remove(bean);
            bl = true;
        }
        catch (Exception e) {
            try {
                throw new BeanException(e);
            }
            catch (Throwable throwable) {
                AnsiSQLBeanSession.close(stmt);
                throw throwable;
            }
        }
        AnsiSQLBeanSession.close(stmt);
        return bl;
    }

    @Override
    public <E> List<E> loadList(E bean) {
        return this.loadListImpl(bean, null, null, null, null);
    }

    @Override
    public <E> List<E> loadList(E bean, Object ... properties) {
        return this.loadListImpl(bean, null, null, AnsiSQLBeanSession.getProperties(properties), null);
    }

    @Override
    public <E> E loadUnique(E bean) {
        return this.loadUniqueImpl(bean, null, null);
    }

    @Override
    public <E> E loadUnique(E bean, Object ... properties) {
        return this.loadUniqueImpl(bean, AnsiSQLBeanSession.getProperties(properties), null);
    }

    @Override
    public <E> E loadUniqueMinus(E bean, Object ... minus) {
        return this.loadUniqueImpl(bean, null, AnsiSQLBeanSession.getProperties(minus));
    }

    protected <E> E loadUniqueImpl(E bean, String[] properties, String[] minus) {
        E o = this.checkUnique(this.loadListImpl(bean, null, new Limit(2), properties, minus));
        if (o != null) {
            this.load(o);
        }
        return o;
    }

    @Override
    public <E> List<E> loadList(E bean, OrderBy orderBy) {
        return this.loadListImpl(bean, orderBy, null, null, null);
    }

    @Override
    public <E> List<E> loadList(E bean, OrderBy orderBy, Object ... properties) {
        return this.loadListImpl(bean, orderBy, null, AnsiSQLBeanSession.getProperties(properties), null);
    }

    @Override
    public <E> List<E> loadList(E bean, Limit limit) {
        return this.loadList(bean, null, limit);
    }

    @Override
    public <E> List<E> loadList(E bean, Limit limit, Object ... properties) {
        return this.loadListImpl(bean, null, limit, AnsiSQLBeanSession.getProperties(properties), null);
    }

    @Override
    public <E> List<E> loadListMinus(E bean, Object ... minus) {
        return this.loadListMinus(bean, null, null, minus);
    }

    @Override
    public <E> List<E> loadListMinus(E bean, OrderBy orderBy, Object ... minus) {
        return this.loadListMinus(bean, orderBy, null, minus);
    }

    @Override
    public <E> List<E> loadListMinus(E bean, Limit limit, Object ... minus) {
        return this.loadListMinus(bean, null, limit, minus);
    }

    protected String getDatabaseType(DBType<?> dbType) {
        return dbType.getAnsiType();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void createTable(Class<? extends Object> beanKlass) {
        BeanConfig bc = this.beanManager.getBeanConfig(beanKlass);
        if (bc == null) {
            throw new BeanException("Cannot find bean config: " + beanKlass);
        }
        if (bc.getNumberOfFields() == 0) {
            throw new BeanException("Cannot create table with zero columns: " + beanKlass);
        }
        StringBuilder sb = new StringBuilder(1024);
        sb.append("create table ").append(bc.getTableName()).append(" (");
        Iterator<DBField> iter = bc.fields();
        int count = 0;
        while (iter.hasNext()) {
            DBField dbField = iter.next();
            DBType dbType = dbField.getType();
            if (count++ > 0) {
                sb.append(", ");
            }
            sb.append(dbField.getDbName()).append(" ").append(this.getDatabaseType(dbType));
            if (dbType instanceof SizedType) {
                SizedType st = (SizedType)((Object)dbType);
                sb.append("(").append(st.getSize()).append(")");
            }
            if (dbType.canBeNull() && !dbField.isPK()) continue;
            sb.append(" NOT NULL");
        }
        sb.append(")");
        if (DEBUG) {
            System.out.println("CREATE TABLE SQL: " + sb.toString());
        }
        PreparedStatement stmt = null;
        boolean autoCommit = false;
        try {
            autoCommit = this.conn.getAutoCommit();
            this.conn.setAutoCommit(false);
            stmt = this.conn.prepareStatement(sb.toString());
            stmt.executeUpdate();
            AnsiSQLBeanSession.close(stmt);
            String pkConstraintQuery = this.createPKConstraintQuery(bc.getTableName(), bc.pks());
            if (DEBUG) {
                System.out.println("PK CONSTRAINT QUERY: " + pkConstraintQuery);
            }
            stmt = this.conn.prepareStatement(pkConstraintQuery);
            stmt.executeUpdate();
            if (autoCommit) {
                this.conn.commit();
            }
            if (!autoCommit) return;
        }
        catch (Exception e) {
            try {
                if (!autoCommit) throw new BeanException(e);
                try {
                    this.conn.rollback();
                    this.conn.setAutoCommit(true);
                    throw new BeanException(e);
                }
                catch (Exception e2) {
                    throw new BeanException(e2);
                }
            }
            catch (Throwable throwable) {
                if (!autoCommit) throw throwable;
                try {
                    this.conn.setAutoCommit(true);
                    AnsiSQLBeanSession.close(stmt);
                    throw throwable;
                }
                catch (Exception e2) {
                    throw new BeanException(e2);
                }
            }
        }
        try {
            this.conn.setAutoCommit(true);
            AnsiSQLBeanSession.close(stmt);
            return;
        }
        catch (Exception e) {
            throw new BeanException(e);
        }
    }

    @Override
    public void createTables() {
        Set<BeanConfig> all = this.beanManager.getBeanConfigs();
        for (BeanConfig bc : all) {
            this.createTable(bc.getBeanClass());
        }
    }

    protected String createPKConstraintQuery(String table, Iterator<DBField> pks) {
        StringBuilder sb = new StringBuilder("alter table ");
        sb.append(table);
        sb.append(" add primary key (");
        if (pks.hasNext()) {
            sb.append(pks.next().getDbName());
        }
        while (pks.hasNext()) {
            DBField dbField = pks.next();
            sb.append(", ").append(dbField.getDbName());
        }
        return sb.append(")").toString();
    }

    private int getSize(DBType<?> dbType) {
        if (dbType instanceof SizedType) {
            SizedType st = (SizedType)((Object)dbType);
            return st.getSize();
        }
        throw new IllegalStateException("Cannot get size from type: " + dbType);
    }

    static void close(PreparedStatement stmt) {
        SQLUtils.close(stmt);
    }

    static void close(PreparedStatement stmt, ResultSet rset) {
        SQLUtils.close(rset, stmt);
    }

    protected class Value {
        public Object value;
        public DBField field;
        public boolean isSysdate;

        private Value(DBField field, Object value, boolean isSysdate) {
            this.field = field;
            this.value = value;
            this.isSysdate = isSysdate;
        }

        public Value(DBField field, Object value) {
            this(field, value, false);
        }

        public Value(DBField field, boolean isSysdate) {
            this(field, null, isSysdate);
        }
    }

    protected class QueryAndValues {
        public StringBuilder sb;
        public List<Value> values;

        public QueryAndValues(StringBuilder sb, List<Value> values) {
            this.sb = sb;
            this.values = values;
        }
    }
}

