/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import org.mentabean.BeanException;

public class PropertiesProxy {
    private String chainProp;
    private static final ThreadLocal<List<String>> propertyNames = new ThreadLocal();

    public PropertiesProxy(String chainProp) {
        this.chainProp = chainProp;
    }

    public static <E> E create(Class<E> klass) {
        PropertiesProxy pp = new PropertiesProxy(null);
        return pp.createInternal(klass);
    }

    public static String getPropertyName() {
        List<String> list = propertyNames.get();
        if (list == null || list.size() != 1) {
            throw new BeanException("Was not able to get property name through the proxy!");
        }
        String propName = list.get(0);
        list.clear();
        return propName;
    }

    public static void addPropertyName(String name) {
        List<String> list = propertyNames.get();
        if (list == null) {
            list = new LinkedList<String>();
            propertyNames.set(list);
        }
        list.add(name);
    }

    public static boolean hasProperties() {
        List<String> list = propertyNames.get();
        return list != null && list.size() > 0;
    }

    public static String[] getPropertyNames() {
        List<String> list = propertyNames.get();
        if (list == null || list.size() == 0) {
            throw new BeanException("Was not able to get property names through the proxy!");
        }
        String[] array = new String[list.size()];
        array = list.toArray(array);
        list.clear();
        return array;
    }

    private static String getPropName(Method method) {
        String propName;
        String methodName = method.getName();
        Class<?> propType = method.getReturnType();
        if (propType.equals(Void.class)) {
            return null;
        }
        Class<?>[] params = method.getParameterTypes();
        if (params != null && params.length > 0) {
            return null;
        }
        if (methodName.startsWith("get") && methodName.length() > 3) {
            propName = methodName.substring(3);
        } else if (methodName.startsWith("is") && methodName.length() > 2 && (propType.equals(Boolean.TYPE) || propType.equals(Boolean.class))) {
            propName = methodName.substring(2);
        } else {
            return null;
        }
        propName = propName.substring(0, 1).toLowerCase() + propName.substring(1);
        if (propName.equals("class")) {
            return null;
        }
        return propName;
    }

    private <E> E createInternal(Class<E> klass) {
        try {
            ProxyFactory factory = new ProxyFactory();
            factory.setSuperclass(klass);
            factory.setFilter(new MethodFilter(){

                @Override
                public boolean isHandled(Method m) {
                    return PropertiesProxy.getPropName(m) != null;
                }
            });
            MethodHandler handler = new MethodHandler(){

                @Override
                public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
                    LinkedList<String> list = (LinkedList<String>)propertyNames.get();
                    if (list == null) {
                        list = new LinkedList<String>();
                        propertyNames.set(list);
                    }
                    String propName = PropertiesProxy.getPropName(thisMethod);
                    if (PropertiesProxy.this.chainProp != null) {
                        list.add(PropertiesProxy.this.chainProp + "." + propName);
                        list.remove(PropertiesProxy.this.chainProp);
                    } else {
                        list.add(propName);
                    }
                    Class<?> propType = thisMethod.getReturnType();
                    if (propType.equals(Boolean.TYPE)) {
                        return false;
                    }
                    if (propType.equals(Character.TYPE)) {
                        return Character.valueOf('\u0000');
                    }
                    if (propType.equals(Byte.TYPE)) {
                        return (byte)0;
                    }
                    if (propType.equals(Long.TYPE)) {
                        return 0L;
                    }
                    if (propType.equals(Integer.TYPE)) {
                        return 0;
                    }
                    if (propType.equals(Short.TYPE)) {
                        return (short)0;
                    }
                    if (propType.equals(Float.TYPE)) {
                        return Float.valueOf(0.0f);
                    }
                    if (propType.equals(Double.TYPE)) {
                        return 0.0;
                    }
                    if (Modifier.isFinal(propType.getModifiers())) {
                        return null;
                    }
                    PropertiesProxy proxy = new PropertiesProxy(PropertiesProxy.this.chainProp != null ? PropertiesProxy.this.chainProp + "." + propName : propName);
                    return proxy.createInternal(propType);
                }
            };
            return (E)factory.create(new Class[0], new Object[0], handler);
        }
        catch (Exception e) {
            throw new BeanException(e);
        }
    }
}

