/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.mentabean.DBType;

public class LongType
implements DBType<Long> {
    private boolean canBeNull = true;

    @Override
    public boolean canBeNull() {
        return this.canBeNull;
    }

    public LongType nullable(boolean flag) {
        LongType d = new LongType();
        d.canBeNull = flag;
        return d;
    }

    @Override
    public String getAnsiType() {
        return "integer";
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Long getFromResultSet(ResultSet rset, int index) throws SQLException {
        Long x = rset.getLong(index);
        if (rset.wasNull()) {
            return null;
        }
        return x;
    }

    @Override
    public Long getFromResultSet(ResultSet rset, String field) throws SQLException {
        Long x = rset.getLong(field);
        if (rset.wasNull()) {
            return null;
        }
        return x;
    }

    @Override
    public Class<? extends Object> getTypeClass() {
        return Long.class;
    }

    @Override
    public void bindToStmt(PreparedStatement stmt, int index, Long value) throws SQLException {
        if (value == null) {
            stmt.setNull(index, -5);
        } else {
            stmt.setLong(index, value);
        }
    }
}

