/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.mentabean.BeanConfig;
import org.mentabean.BeanException;
import org.mentabean.BeanManager;
import org.mentabean.DBField;
import org.mentabean.DBType;
import org.mentabean.jdbc.AnsiSQLBeanSession;
import org.mentabean.type.AutoIncrementType;
import org.mentabean.util.Limit;
import org.mentabean.util.OrderBy;

public class MySQLBeanSession
extends AnsiSQLBeanSession {
    public MySQLBeanSession(BeanManager beanManager, Connection conn) {
        super(beanManager, conn);
    }

    @Override
    protected String getCurrentTimestampCommand() {
        return "now()";
    }

    @Override
    protected String getDatabaseType(DBType<?> dbType) {
        if (dbType instanceof AutoIncrementType) {
            return "integer AUTO_INCREMENT";
        }
        return super.getDatabaseType(dbType);
    }

    @Override
    protected StringBuilder handleLimit(StringBuilder sb, OrderBy orderBy, Limit limit) {
        if (limit == null || limit.intValue() <= 0) {
            return sb;
        }
        StringBuilder sbLimit = new StringBuilder(sb.length() + 32);
        sbLimit.append(sb.toString()).append(" LIMIT ").append(limit);
        return sbLimit;
    }

    @Override
    public void insert(Object bean) {
        super.insert(bean);
        BeanConfig bc = this.beanManager.getBeanConfig(bean.getClass());
        DBField autoIncrement = bc.getAutoIncrementField();
        if (autoIncrement == null) {
            return;
        }
        PreparedStatement stmt = null;
        ResultSet rset = null;
        StringBuilder sb = new StringBuilder("select last_insert_id() from ");
        sb.append(bc.getTableName());
        try {
            stmt = this.conn.prepareStatement(sb.toString());
            rset = stmt.executeQuery();
            if (rset.next()) {
                int id = rset.getInt(1);
                MySQLBeanSession.injectValue(bean, autoIncrement.getName(), id, Integer.class);
            }
        }
        catch (Exception e) {
            try {
                throw new BeanException(e);
            }
            catch (Throwable throwable) {
                MySQLBeanSession.close(stmt, rset);
                throw throwable;
            }
        }
        MySQLBeanSession.close(stmt, rset);
    }
}

