/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.h2.util.New;
import org.h2.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiDimension
implements Comparator<long[]> {
    private static final MultiDimension INSTANCE = new MultiDimension();

    private MultiDimension() {
    }

    public static MultiDimension getInstance() {
        return INSTANCE;
    }

    public long interleave(int[] nArray) {
        long l;
        int n = nArray.length;
        int n2 = 64 / n;
        long l2 = 1L << n2;
        long l3 = 0L;
        for (int i = 0; i < n; ++i) {
            long l4 = nArray[i];
            if (l4 < 0L || l4 > l2) {
                throw new IllegalArgumentException("value out of range; value=" + nArray[i] + " min=0 max=" + l2);
            }
            for (int j = 0; j < n2; ++j) {
                l3 |= (l4 & 1L << j) << i + (n - 1) * j;
            }
        }
        if (n == 2 && (l = this.getMorton2(nArray[0], nArray[1])) != l3) {
            throw new IllegalArgumentException("test");
        }
        return l3;
    }

    public int deinterleave(long l, int n, int n2) {
        int n3 = 64 / n;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            n4 = (int)((long)n4 | l >> n2 + (n - 1) * i & 1L << i);
        }
        return n4;
    }

    public String generatePreparedQuery(String string, String string2, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder("SELECT D.* FROM ");
        stringBuilder.append(StringUtils.quoteIdentifier(string)).append(" D, TABLE(_FROM_ BIGINT=?, _TO_ BIGINT=?) WHERE ").append(StringUtils.quoteIdentifier(string2)).append(" BETWEEN _FROM_ AND _TO_");
        for (String string3 : stringArray) {
            stringBuilder.append(" AND ").append(StringUtils.quoteIdentifier(string3)).append("+1 BETWEEN ?+1 AND ?+1");
        }
        return stringBuilder.toString();
    }

    public ResultSet getResult(PreparedStatement preparedStatement, int[] nArray, int[] nArray2) throws SQLException {
        int n;
        long[][] lArray = this.getMortonRanges(nArray, nArray2);
        int n2 = lArray.length;
        Long[] longArray = new Long[n2];
        Long[] longArray2 = new Long[n2];
        for (n = 0; n < n2; ++n) {
            longArray[n] = lArray[n][0];
            longArray2[n] = lArray[n][1];
        }
        preparedStatement.setObject(1, longArray);
        preparedStatement.setObject(2, longArray2);
        n2 = nArray.length;
        int n3 = 3;
        for (n = 0; n < n2; ++n) {
            preparedStatement.setInt(n3++, nArray[n]);
            preparedStatement.setInt(n3++, nArray2[n]);
        }
        return preparedStatement.executeQuery();
    }

    private long[][] getMortonRanges(int[] nArray, int[] nArray2) {
        int n;
        int n2 = nArray.length;
        if (nArray2.length != n2) {
            throw new IllegalArgumentException("dimensions mismatch");
        }
        for (n = 0; n < n2; ++n) {
            if (nArray[n] <= nArray2[n]) continue;
            int n3 = nArray[n];
            nArray[n] = nArray2[n];
            nArray2[n] = n3;
        }
        n = this.getSize(nArray, nArray2, n2);
        ArrayList<long[]> arrayList = New.arrayList();
        this.addMortonRanges(arrayList, nArray, nArray2, n2, 0);
        this.optimize(arrayList, n);
        long[][] lArray = new long[arrayList.size()][2];
        arrayList.toArray((T[])lArray);
        return lArray;
    }

    private long getMorton2(int n, int n2) {
        long l = 0L;
        for (int i = 0; i < 32; ++i) {
            l |= ((long)n & 1L << i) << i;
            l |= ((long)n2 & 1L << i) << i + 1;
        }
        return l;
    }

    private int getSize(int[] nArray, int[] nArray2, int n) {
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            int n3 = nArray2[i] - nArray[i];
            n2 *= n3 + 1;
        }
        return n2;
    }

    private void optimize(ArrayList<long[]> arrayList, int n) {
        Collections.sort(arrayList, this);
        int n2 = 10;
        while (true) {
            long[] lArray;
            Object object;
            int n3;
            for (n3 = 0; n3 < arrayList.size() - 1; ++n3) {
                object = arrayList.get(n3);
                if (object[1] + (long)n2 < (lArray = arrayList.get(n3 + 1))[0]) continue;
                object[1] = lArray[1];
                arrayList.remove(n3 + 1);
                --n3;
            }
            n3 = 0;
            object = arrayList.iterator();
            while (object.hasNext()) {
                lArray = (long[])object.next();
                n3 = (int)((long)n3 + (lArray[1] - lArray[0] + 1L));
            }
            if (n3 > 2 * n || arrayList.size() < 3) break;
            n2 += n2 / 2;
        }
    }

    @Override
    public int compare(long[] lArray, long[] lArray2) {
        return lArray[0] > lArray2[0] ? 1 : -1;
    }

    private void addMortonRanges(ArrayList<long[]> arrayList, int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 > 100) {
            throw new IllegalArgumentException("Stop");
        }
        int n3 = 0;
        int n4 = 0;
        long l = 1L;
        for (int i = 0; i < n; ++i) {
            int n5 = nArray2[i] - nArray[i];
            if (n5 < 0) {
                throw new IllegalArgumentException("Stop");
            }
            if ((l *= (long)(n5 + 1)) < 0L) {
                throw new IllegalArgumentException("Stop");
            }
            if (n5 <= n4) continue;
            n4 = n5;
            n3 = i;
        }
        long l2 = this.interleave(nArray);
        long l3 = this.interleave(nArray2);
        if (l3 < l2) {
            throw new IllegalArgumentException("Stop");
        }
        long l4 = l3 - l2 + 1L;
        if (l4 == l) {
            long[] lArray = new long[]{l2, l3};
            arrayList.add(lArray);
        } else {
            int n6 = this.findMiddle(nArray[n3], nArray2[n3]);
            int n7 = nArray2[n3];
            nArray2[n3] = n6;
            this.addMortonRanges(arrayList, nArray, nArray2, n, n2 + 1);
            nArray2[n3] = n7;
            n7 = nArray[n3];
            nArray[n3] = n6 + 1;
            this.addMortonRanges(arrayList, nArray, nArray2, n, n2 + 1);
            nArray[n3] = n7;
        }
    }

    private int roundUp(int n, int n2) {
        return n + n2 - 1 & -n2;
    }

    private int findMiddle(int n, int n2) {
        int n3;
        int n4 = n2 - n - 1;
        if (n4 == 0) {
            return n;
        }
        if (n4 == 1) {
            return n + 1;
        }
        int n5 = 0;
        while (1 << n5 < n4) {
            ++n5;
        }
        if ((n3 = this.roundUp(n + 2, 1 << --n5) - 1) <= n || n3 >= n2) {
            throw new IllegalArgumentException("stop");
        }
        return n3;
    }
}

