/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.util;

import java.lang.reflect.Constructor;
import java.util.LinkedList;

public class FindConstructor {
    public static Constructor<? extends Object> getConstructor(Class<? extends Object> source, Class<? extends Object>[] parameterTypes) throws NoSuchMethodException {
        return FindConstructor.internalFind(source.getConstructors(), parameterTypes);
    }

    public static Constructor<? extends Object> getDeclaredConstructor(Class<? extends Object> source, Class<? extends Object>[] parameterTypes) throws NoSuchMethodException {
        return FindConstructor.internalFind(source.getDeclaredConstructors(), parameterTypes);
    }

    private static Constructor<? extends Object> internalFind(Constructor<? extends Object>[] toTest, Class<? extends Object>[] parameterTypes) throws NoSuchMethodException {
        int l = parameterTypes.length;
        LinkedList<Constructor<? extends Object>> applicableMethods = new LinkedList<Constructor<? extends Object>>();
        for (int i = 0; i < toTest.length; ++i) {
            int j;
            Class<?>[] params = toTest[i].getParameterTypes();
            if (params.length != l) continue;
            for (j = 0; j < l && params[j].isAssignableFrom(parameterTypes[j]); ++j) {
            }
            if (j != l) continue;
            applicableMethods.add(toTest[i]);
        }
        int size = applicableMethods.size();
        if (size == 0) {
            throw new NoSuchMethodException("No such constructor!");
        }
        if (size == 1) {
            return (Constructor)applicableMethods.get(0);
        }
        int maximallySpecific = -1;
        for (int i = 0; i < size; ++i) {
            int j;
            Constructor current = (Constructor)applicableMethods.get(i);
            Class<?>[] currentParams = current.getParameterTypes();
            Class currentDeclarer = current.getDeclaringClass();
            for (j = 0; j < size; ++j) {
                int k;
                if (i == j) continue;
                Constructor test = (Constructor)applicableMethods.get(j);
                Class<?>[] testParams = test.getParameterTypes();
                Class testDeclarer = test.getDeclaringClass();
                if (!testDeclarer.isAssignableFrom(currentDeclarer)) break;
                for (k = 0; k < l && testParams[k].isAssignableFrom(currentParams[k]); ++k) {
                }
                if (k != l) break;
            }
            if (j != size) continue;
            if (maximallySpecific != -1) {
                throw new NoSuchMethodException("Ambiguous method search - more than one maximally specific method");
            }
            maximallySpecific = i;
        }
        if (maximallySpecific == -1) {
            throw new NoSuchMethodException("No maximally specific method.");
        }
        return (Constructor)applicableMethods.get(maximallySpecific);
    }
}

