/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.mentabean.BeanConfig;
import org.mentabean.BeanException;
import org.mentabean.BeanManager;
import org.mentabean.DBField;
import org.mentabean.jdbc.AnsiSQLBeanSession;

public class PostgreSQLBeanSession
extends AnsiSQLBeanSession {
    public PostgreSQLBeanSession(BeanManager beanManager, Connection conn) {
        super(beanManager, conn);
    }

    @Override
    protected String getCurrentTimestampCommand() {
        return "current_timestamp";
    }

    @Override
    protected StringBuilder handleLimit(StringBuilder sb, String orderBy, int limit) {
        if (limit == -1) {
            return sb;
        }
        StringBuilder sbLimit = new StringBuilder(sb.length() + 32);
        sbLimit.append(sb.toString()).append(" LIMIT ").append(limit);
        return sbLimit;
    }

    @Override
    public void insert(Object bean) {
        ResultSet rset;
        PreparedStatement stmt;
        block9: {
            BeanConfig bc = this.beanManager.getBeanConfig(bean.getClass());
            if (bc == null) {
                throw new BeanException("Cannot find bean config: " + bean.getClass());
            }
            DBField seqField = bc.getSequenceField();
            if (seqField == null) {
                super.insert(bean);
                return;
            }
            String seqName = bc.getSequenceName();
            if (seqName == null) {
                seqName = bc.getTableName() + "_seq";
            }
            stmt = null;
            rset = null;
            StringBuilder sb = new StringBuilder();
            sb.append("select nextval ('").append(seqName).append("')");
            try {
                stmt = this.conn.prepareStatement(sb.toString());
                rset = stmt.executeQuery();
                if (!rset.next()) break block9;
                long id = rset.getLong(1);
                try {
                    PostgreSQLBeanSession.injectValue(bean, seqField.getName(), id, Integer.class);
                }
                catch (Exception e) {
                    PostgreSQLBeanSession.injectValue(bean, seqField.getName(), id, Long.class);
                }
            }
            catch (Exception e) {
                try {
                    throw new BeanException("Error preparing statement", e);
                }
                catch (Throwable throwable) {
                    PostgreSQLBeanSession.close(stmt, rset);
                    throw throwable;
                }
            }
        }
        PostgreSQLBeanSession.close(stmt, rset);
        super.insert(bean);
    }
}

