/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.util;

import java.lang.reflect.Method;
import java.util.Date;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import org.mentabean.BeanException;

public class PropertiesProxy {
    private static final ThreadLocal<String> propertyNames = new ThreadLocal();

    public static String get() {
        String propName = propertyNames.get();
        if (propName == null) {
            throw new BeanException("Was not able to get property name through the proxy!");
        }
        return propName;
    }

    private static String getPropName(Method method) {
        String propName;
        String methodName = method.getName();
        Class<?> propType = method.getReturnType();
        if (propType.equals(Void.class)) {
            return null;
        }
        Class<?>[] params = method.getParameterTypes();
        if (params != null && params.length > 0) {
            return null;
        }
        if (methodName.startsWith("get") && methodName.length() > 3) {
            propName = methodName.substring(3);
        } else if (methodName.startsWith("is") && methodName.length() > 2 && (propType.equals(Boolean.TYPE) || propType.equals(Boolean.class))) {
            propName = methodName.substring(2);
        } else {
            return null;
        }
        propName = propName.substring(0, 1).toLowerCase() + propName.substring(1);
        if (propName.equals("class")) {
            return null;
        }
        return propName;
    }

    public static <E> E create(Class<E> klass) {
        try {
            ProxyFactory factory = new ProxyFactory();
            factory.setSuperclass(klass);
            factory.setFilter(new MethodFilter(){

                @Override
                public boolean isHandled(Method m) {
                    return PropertiesProxy.getPropName(m) != null;
                }
            });
            MethodHandler handler = new MethodHandler(){

                @Override
                public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
                    propertyNames.set(PropertiesProxy.getPropName(thisMethod));
                    Class<?> propType = thisMethod.getReturnType();
                    if (propType.equals(Boolean.TYPE)) {
                        return false;
                    }
                    if (propType.equals(Character.TYPE)) {
                        return Character.valueOf('\u0000');
                    }
                    if (propType.equals(Byte.TYPE)) {
                        return (byte)0;
                    }
                    if (propType.equals(Long.TYPE)) {
                        return 0L;
                    }
                    if (propType.equals(Integer.TYPE)) {
                        return 0;
                    }
                    if (propType.equals(Short.TYPE)) {
                        return (short)0;
                    }
                    if (propType.equals(Float.TYPE)) {
                        return Float.valueOf(0.0f);
                    }
                    if (propType.equals(Double.TYPE)) {
                        return 0.0;
                    }
                    return null;
                }
            };
            return (E)factory.create(new Class[0], new Object[0], handler);
        }
        catch (Exception e) {
            throw new BeanException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        PropertiesProxy.field("age");
        System.out.println();
        User user = PropertiesProxy.create(User.class);
        PropertiesProxy.field(user.getAge());
        PropertiesProxy.field(user.getUsername());
        PropertiesProxy.field(user.isBlah1());
        PropertiesProxy.field(user.getBlah2());
        PropertiesProxy.field(Character.valueOf(user.getBlah3()));
        PropertiesProxy.field(user.getBlah4());
        PropertiesProxy.field(user.getBlah5());
        PropertiesProxy.field(user.getBlah6());
    }

    public static void field(String propName) {
        if (propName == null) {
            PropertiesProxy.field((Object)null);
        } else {
            System.out.println("hardcoded propName: " + propName);
        }
    }

    public static void field(Object propName) {
        propName = PropertiesProxy.get();
        System.out.println("proxified propName: " + propName);
    }

    public static class User {
        private int age;
        private String username;
        private boolean blah1;
        private Boolean blah2;
        private char blah3;
        private long blah4;
        private Long blah5;
        private Date blah6;

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public boolean isBlah1() {
            return this.blah1;
        }

        public void setBlah1(boolean blah1) {
            this.blah1 = blah1;
        }

        public Boolean getBlah2() {
            return this.blah2;
        }

        public void setBlah2(Boolean blah2) {
            this.blah2 = blah2;
        }

        public char getBlah3() {
            return this.blah3;
        }

        public void setBlah3(char blah3) {
            this.blah3 = blah3;
        }

        public long getBlah4() {
            return this.blah4;
        }

        public void setBlah4(long blah4) {
            this.blah4 = blah4;
        }

        public Long getBlah5() {
            return this.blah5;
        }

        public void setBlah5(Long blah5) {
            this.blah5 = blah5;
        }

        public Date getBlah6() {
            return this.blah6;
        }

        public void setBlah6(Date blah6) {
            this.blah6 = blah6;
        }
    }
}

