/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.mentabean.BeanException;
import org.mentabean.util.ScriptRunner;

public class SQLUtils {
    public static void executeScript(Connection conn, String file, String charset) {
        FileInputStream fis = null;
        BufferedReader br = null;
        try {
            ScriptRunner script = new ScriptRunner(conn);
            fis = new FileInputStream(file);
            br = charset != null ? new BufferedReader(new InputStreamReader((InputStream)fis, charset)) : new BufferedReader(new InputStreamReader(fis));
            script.runScript(br);
        }
        catch (Exception e) {
            throw new BeanException(e);
        }
    }

    public static boolean checkIfTableExists(Connection conn, String tableName) {
        ResultSet rset = null;
        try {
            DatabaseMetaData dbm = conn.getMetaData();
            rset = dbm.getTables(null, null, null, new String[]{"TABLE"});
            while (rset.next()) {
                String tn = rset.getString("TABLE_NAME");
                if (!tn.equalsIgnoreCase(tableName)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new BeanException(e);
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void close(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                throw new BeanException(e);
            }
        }
    }

    public static void close(ResultSet rset, Statement stmt) {
        SQLException bad = null;
        if (rset != null) {
            try {
                rset.close();
            }
            catch (SQLException e) {
                bad = e;
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                bad = e;
            }
        }
        if (bad != null) {
            throw new BeanException(bad);
        }
    }

    public static void close(Statement stmt, Connection conn) {
        SQLException bad = null;
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                bad = e;
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                bad = e;
            }
        }
        if (bad != null) {
            throw new BeanException(bad);
        }
    }

    public static void close(ResultSet rset, Statement stmt, Connection conn) {
        SQLException bad = null;
        if (rset != null) {
            try {
                rset.close();
            }
            catch (SQLException e) {
                bad = e;
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                bad = e;
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                bad = e;
            }
        }
        if (bad != null) {
            throw new BeanException(bad);
        }
    }

    public static int fillStatement(PreparedStatement stmt, Object ... params) {
        return SQLUtils.fillStatementIndx(stmt, 1, params);
    }

    public static int fillStatementIndx(PreparedStatement stmt, int indx, Object ... params) {
        try {
            for (Object obj : params) {
                stmt.setObject(indx++, obj);
            }
            return indx;
        }
        catch (Exception e) {
            throw new BeanException("Error setting values for statement", e);
        }
    }
}

