/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mentabean.DBField;
import org.mentabean.DBType;
import org.mentabean.type.AutoIncrementType;
import org.mentabean.type.SequenceType;

public class BeanConfig {
    private final Map<String, DBField> fieldList = new LinkedHashMap<String, DBField>();
    private final Map<String, DBField> pkList = new LinkedHashMap<String, DBField>();
    private final Class<? extends Object> beanClass;
    private final String tableName;
    private DBField sequence = null;
    private String sequenceName = null;
    private DBField autoincrement = null;

    public BeanConfig(Class<? extends Object> beanClass, String tableName) {
        this.beanClass = beanClass;
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Class<? extends Object> getBeanClass() {
        return this.beanClass;
    }

    private DBField findDBField(String name) {
        return this.fieldList.get(name);
    }

    public BeanConfig addSequenceName(String seqNameInDb) {
        if (this.sequence == null) {
            throw new IllegalStateException("There is no sequence field defined!");
        }
        this.sequenceName = seqNameInDb;
        return this;
    }

    public BeanConfig seq(String seqNameInDb) {
        return this.addSequenceName(seqNameInDb);
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    private BeanConfig addField(String name, String dbName, DBType<? extends Object> type, boolean isPK) {
        if (!isPK) {
            if (type instanceof SequenceType) {
                throw new IllegalStateException("A sequence type can only be a primary key!");
            }
            if (type instanceof AutoIncrementType) {
                throw new IllegalStateException("A auto-increment type can only be a primary key!");
            }
        }
        DBField f = new DBField(name, dbName, type, isPK);
        this.fieldList.remove(name);
        this.fieldList.put(name, f);
        if (isPK) {
            this.pkList.remove(name);
            this.pkList.put(name, f);
            if (type instanceof SequenceType) {
                if (this.sequence != null) {
                    throw new IllegalStateException("A bean can have only one sequence field!");
                }
                this.sequence = f;
            } else if (type instanceof AutoIncrementType) {
                if (this.autoincrement != null) {
                    throw new IllegalStateException("A bean can have only one auto-increment field!");
                }
                this.autoincrement = f;
            }
        }
        return this;
    }

    public DBField getAutoIncrementField() {
        return this.autoincrement;
    }

    public DBField getSequenceField() {
        return this.sequence;
    }

    public BeanConfig field(String name, DBType<? extends Object> type) {
        return this.addField(name, name, type, false);
    }

    public BeanConfig field(String name, String dbName, DBType<? extends Object> type) {
        return this.addField(name, dbName, type, false);
    }

    public BeanConfig pk(String name, DBType<? extends Object> type) {
        return this.addField(name, name, type, true);
    }

    public BeanConfig pk(String name, String dbName, DBType<? extends Object> type) {
        return this.addField(name, dbName, type, true);
    }

    public int getNumberOfFields() {
        return this.fieldList.size();
    }

    public int getNumberOfPKs() {
        return this.pkList.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("BeanConfig: ").append(this.beanClass.getName()).append(" tableName=").append(this.tableName);
        return sb.toString();
    }

    public Iterator<DBField> fields() {
        return this.fieldList.values().iterator();
    }

    public boolean hasPK() {
        return !this.pkList.isEmpty();
    }

    public Iterator<DBField> pks() {
        return this.pkList.values().iterator();
    }
}

