/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.table.Column;
import org.h2.value.Value;
import org.h2.value.ValueString;

public class Explain
extends Prepared {
    private Prepared command;
    private LocalResult result;
    private boolean executeCommand;

    public Explain(Session session) {
        super(session);
    }

    public void setCommand(Prepared prepared) {
        this.command = prepared;
    }

    public void prepare() {
        this.command.prepare();
    }

    public void setExecuteCommand(boolean bl) {
        this.executeCommand = bl;
    }

    public ResultInterface queryMeta() {
        return this.query(-1);
    }

    public ResultInterface query(int n) {
        Column column = new Column("PLAN", 13);
        ExpressionColumn expressionColumn = new ExpressionColumn(this.session.getDatabase(), column);
        Expression[] expressionArray = new Expression[]{expressionColumn};
        this.result = new LocalResult(this.session, expressionArray, 1);
        if (n >= 0) {
            if (this.executeCommand) {
                if (this.command.isQuery()) {
                    this.command.query(n);
                } else {
                    this.command.update();
                }
            }
            String string = this.command.getPlanSQL();
            this.add(string);
        }
        this.result.done();
        return this.result;
    }

    private void add(String string) {
        Value[] valueArray = new Value[]{ValueString.get(string)};
        this.result.addRow(valueArray);
    }

    public boolean isQuery() {
        return true;
    }

    public boolean isTransactional() {
        return true;
    }

    public boolean isReadOnly() {
        return true;
    }
}

