/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.util;

import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mentabean.util.FindMethod;

public class InjectionUtils {
    public static char PREFIX_SEPARATOR = (char)46;
    private static Map<Class<? extends Object>, Map<String, Object>> settersMaps = new HashMap<Class<? extends Object>, Map<String, Object>>();
    private static Map<Class<? extends Object>, Map<String, Object>> fieldsMaps = new HashMap<Class<? extends Object>, Map<String, Object>>();

    public static void prepareForInjection(Class<? extends Object> klass, Map<String, Object> setters, Map<String, Object> fields) {
        StringBuffer sb = new StringBuffer(32);
        Method[] methods = klass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            String name = m.getName();
            Class<?>[] types = m.getParameterTypes();
            if (!name.startsWith("set") || name.length() <= 3 || types.length != 1) continue;
            String var = name.substring(3);
            if (var.length() > 1) {
                sb.delete(0, sb.length());
                sb.append(var.substring(0, 1).toLowerCase());
                sb.append(var.substring(1));
                var = sb.toString();
            } else {
                var = var.toLowerCase();
            }
            m.setAccessible(true);
            if (setters.containsKey(var)) {
                ArrayList<Method> list;
                Object obj = setters.get(var);
                if (obj instanceof List) {
                    list = (ArrayList<Method>)obj;
                    list.add(m);
                    continue;
                }
                if (!(obj instanceof Method)) continue;
                list = new ArrayList<Method>();
                list.add((Method)obj);
                list.add(m);
                setters.put(var, list);
                continue;
            }
            setters.put(var, m);
        }
        if (fields == null) {
            return;
        }
        Field[] f = klass.getDeclaredFields();
        for (int i = 0; i < f.length; ++i) {
            Field field = f[i];
            field.setAccessible(true);
            String name = field.getName();
            if (setters.containsKey(name)) {
                Object obj = setters.get(name);
                if (obj instanceof Method) {
                    Method m = (Method)obj;
                    Class<?>[] types = m.getParameterTypes();
                    Class<?> type = field.getType();
                    if (type.isAssignableFrom(types[0])) {
                        continue;
                    }
                } else if (obj instanceof List) {
                    List list = (List)obj;
                    Iterator iter = list.iterator();
                    boolean found = false;
                    while (iter.hasNext()) {
                        Method m = (Method)iter.next();
                        Class<?>[] types = m.getParameterTypes();
                        Class<?> type = field.getType();
                        if (!type.isAssignableFrom(types[0])) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
            }
            fields.put(name, field);
        }
    }

    public static boolean checkPrimitives(Class<? extends Object> target, Class<? extends Object> source) {
        if (target.equals(Integer.TYPE) && source.equals(Integer.class)) {
            return true;
        }
        if (target.equals(Boolean.TYPE) && source.equals(Boolean.class)) {
            return true;
        }
        if (target.equals(Byte.TYPE) && source.equals(Byte.class)) {
            return true;
        }
        if (target.equals(Short.TYPE) && source.equals(Short.class)) {
            return true;
        }
        if (target.equals(Character.TYPE) && source.equals(Character.class)) {
            return true;
        }
        if (target.equals(Long.TYPE) && source.equals(Long.class)) {
            return true;
        }
        if (target.equals(Float.TYPE) && source.equals(Float.class)) {
            return true;
        }
        return target.equals(Double.TYPE) && source.equals(Double.class);
    }

    public static Object tryToConvert(Object source, Class<? extends Object> targetType) {
        return InjectionUtils.tryToConvert(source, targetType, false);
    }

    public static Object tryToConvert(Object source, Class<?> targetType, boolean tryNumber) {
        String value = null;
        if (source instanceof String) {
            value = (String)source;
        } else if (tryNumber && source instanceof Number) {
            value = source.toString();
        } else {
            return null;
        }
        Constable newValue = null;
        String className = targetType.getName();
        if (className.equals("int") || className.equals("java.lang.Integer")) {
            int x = -1;
            try {
                x = Integer.parseInt(value);
            }
            catch (Exception e) {
                return null;
            }
            newValue = new Integer(x);
        } else if (className.equals("short") || className.equals("java.lang.Short")) {
            short x = -1;
            try {
                x = Short.parseShort(value);
            }
            catch (Exception e) {
                return null;
            }
            newValue = new Short(x);
        } else if (className.equals("char") || className.equals("java.lang.Character")) {
            if (value.length() != 1) {
                return null;
            }
            newValue = new Character(value.charAt(0));
        } else if (className.equals("long") || className.equals("java.lang.Long")) {
            long x = -1L;
            try {
                x = Long.parseLong(value);
            }
            catch (Exception e) {
                return null;
            }
            newValue = new Long(x);
        } else if (className.equals("float") || className.equals("java.lang.Float")) {
            float x = -1.0f;
            try {
                x = Float.parseFloat(value);
            }
            catch (Exception e) {
                return null;
            }
            newValue = new Float(x);
        } else if (className.equals("double") || className.equals("java.lang.Double")) {
            double x = -1.0;
            try {
                x = Double.parseDouble(value);
            }
            catch (Exception e) {
                return null;
            }
            newValue = new Double(x);
        } else if (className.equals("boolean") || className.equals("java.lang.Boolean")) {
            try {
                int x = Integer.parseInt(value);
                if (x == 1) {
                    newValue = Boolean.TRUE;
                }
                if (x == 0) {
                    newValue = Boolean.FALSE;
                }
                return null;
            }
            catch (Exception e) {
                if (value.equalsIgnoreCase("true") || value.equals("on")) {
                    newValue = Boolean.TRUE;
                }
                if (value.equalsIgnoreCase("false")) {
                    newValue = Boolean.FALSE;
                }
                return null;
            }
        } else if (targetType.isEnum()) {
            try {
                Class<?> k = targetType;
                newValue = Enum.valueOf(k, value);
            }
            catch (Exception e) {
                return null;
            }
        }
        return newValue;
    }

    public static Object shouldConvertToNull(Object value, Class<? extends Object> targetType) {
        if (targetType.equals(String.class)) {
            return value;
        }
        if (targetType.isPrimitive()) {
            return value;
        }
        return null;
    }

    public static Class<? extends Object> getPrimitiveFrom(Object w) {
        if (w instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (w instanceof Byte) {
            return Byte.TYPE;
        }
        if (w instanceof Short) {
            return Short.TYPE;
        }
        if (w instanceof Character) {
            return Character.TYPE;
        }
        if (w instanceof Integer) {
            return Integer.TYPE;
        }
        if (w instanceof Long) {
            return Long.TYPE;
        }
        if (w instanceof Float) {
            return Float.TYPE;
        }
        if (w instanceof Double) {
            return Double.TYPE;
        }
        return null;
    }

    public static Class<? extends Object> getPrimitiveFrom(Class<? extends Object> klass) {
        String s = klass.getName();
        if (s.equals("java.lang.Boolean")) {
            return Boolean.TYPE;
        }
        if (s.equals("java.lang.Byte")) {
            return Byte.TYPE;
        }
        if (s.equals("java.lang.Short")) {
            return Short.TYPE;
        }
        if (s.equals("java.lang.Character")) {
            return Character.TYPE;
        }
        if (s.equals("java.lang.Integer")) {
            return Integer.TYPE;
        }
        if (s.equals("java.lang.Long")) {
            return Long.TYPE;
        }
        if (s.equals("java.lang.Float")) {
            return Float.TYPE;
        }
        if (s.equals("java.lang.Double")) {
            return Double.TYPE;
        }
        return null;
    }

    public static Field getField(Object target, String name) {
        return InjectionUtils.getField(target.getClass(), name);
    }

    public static Field getField(Class<? extends Object> target, String name) {
        Field[] fields = target.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!name.equals(fields[i].getName())) continue;
            return fields[i];
        }
        return null;
    }

    public static Method findMethodToGet(Class<? extends Object> target, String name) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("is").append(name.substring(0, 1).toUpperCase());
        if (name.length() > 1) {
            sb.append(name.substring(1));
        }
        try {
            return target.getMethod(sb.toString(), null);
        }
        catch (Exception e) {
            sb.setLength(0);
            sb.append("get").append(name.substring(0, 1).toUpperCase());
            if (name.length() > 1) {
                sb.append(name.substring(1));
            }
            try {
                return target.getMethod(sb.toString(), null);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static Method findMethodToInject(Class<? extends Object> target, String name, Class<? extends Object> source) {
        Class<? extends Object> primitive;
        StringBuffer sb = new StringBuffer(128);
        sb.append("set").append(name.substring(0, 1).toUpperCase());
        if (name.length() > 1) {
            sb.append(name.substring(1));
        }
        String methodName = sb.toString();
        Method m = null;
        try {
            m = FindMethod.getMethod(target, methodName, new Class[]{source});
        }
        catch (Exception e) {
            // empty catch block
        }
        if (m == null && (primitive = InjectionUtils.getPrimitiveFrom(source)) != null) {
            try {
                m = target.getMethod(methodName, primitive);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (m != null) {
            m.setAccessible(true);
        }
        return m;
    }

    public static Field findFieldToInject(Class<? extends Object> target, String name, Class<? extends Object> source) {
        Class<? extends Object> type;
        Field f = InjectionUtils.getField(target, name);
        if (f != null && ((type = f.getType()).isAssignableFrom(source) || InjectionUtils.checkPrimitives(type, source))) {
            f.setAccessible(true);
            return f;
        }
        return null;
    }

    private static final boolean isBlank(Object value) {
        String s;
        return value != null && value instanceof String && (s = ((String)value).trim()).length() == 0;
    }

    public static boolean inject(Method m, Object target, Object value, boolean tryToConvert, boolean tryingToConvertBoolean) throws Exception {
        Class<?> type = m.getParameterTypes()[0];
        if (tryingToConvertBoolean) {
            if (value == null && (type.equals(Boolean.class) || type.equals(Boolean.TYPE))) {
                value = Boolean.FALSE;
            } else {
                return false;
            }
        }
        if (value == null || type.isAssignableFrom(value.getClass()) || InjectionUtils.checkPrimitives(type, value.getClass()) || tryToConvert && (InjectionUtils.isBlank(value) && (value = InjectionUtils.shouldConvertToNull(value, type)) == null || (value = InjectionUtils.tryToConvert(value, type)) != null)) {
            try {
                m.invoke(target, value);
                return true;
            }
            catch (Exception e) {
                System.err.println("Error injecting by method: " + value + " in " + target + " thru " + m);
                e.printStackTrace();
                throw e;
            }
        }
        return false;
    }

    public static boolean hasDefaultConstructor(Class<? extends Object> klass) {
        try {
            return klass.getConstructor(null) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getProperty(Object bean, String nameProperty) throws Exception {
        Field[] fields;
        Method[] methods;
        if (nameProperty == null || nameProperty.equals("")) {
            return null;
        }
        String methodName = InjectionUtils.getter(nameProperty);
        Class<?> clazz = bean.getClass();
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != 0) continue;
            Object value = method.invoke(bean, (Object[])null);
            if (value == null) {
                return null;
            }
            return value.toString();
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            if (!field.getName().equals(nameProperty)) continue;
            Object value = field.get(bean);
            if (value == null) {
                return null;
            }
            return value.toString();
        }
        return null;
    }

    private static String getter(String name) {
        StringBuilder sb = new StringBuilder(name.length() + 3);
        sb.append("get").append(name.substring(0, 1).toUpperCase());
        if (name.length() > 1) {
            sb.append(name.substring(1));
        }
        return sb.toString();
    }

    public static void beanToMap(Object bean, Map<String, String> map) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (bean != null) {
            for (Method method : bean.getClass().getMethods()) {
                String name = method.getName();
                if (name.length() <= 3 || !name.startsWith("get") || name.equals("getClass") || method.getParameterTypes().length != 0) continue;
                method.setAccessible(true);
                Object value = method.invoke(bean, new Object[0]);
                map.put(name, value.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getObject(Object target, Provider provider, boolean tryField, String prefix, boolean tryToConvert, boolean convertBoolean, boolean allowRecursion) throws Exception {
        Object value;
        boolean hasValue;
        Map<String, Object> fields;
        Map<String, Object> setters;
        Class<?> targetClass = target.getClass();
        Map<Class<? extends Object>, Map<String, Object>> map = settersMaps;
        synchronized (map) {
            setters = settersMaps.get(targetClass);
            fields = fieldsMaps.get(targetClass);
        }
        if (setters == null) {
            setters = new HashMap<String, Object>();
            fields = null;
            if (tryField) {
                fields = new HashMap<String, Object>();
            }
            InjectionUtils.prepareForInjection(targetClass, setters, fields);
            map = settersMaps;
            synchronized (map) {
                settersMaps.put(targetClass, setters);
                fieldsMaps.put(targetClass, fields);
            }
        }
        block8: for (String var : setters.keySet()) {
            hasValue = provider.hasValue(var);
            value = provider.get(var);
            boolean tryingToConvertBoolean = false;
            if (value == null && !hasValue) {
                if (!convertBoolean) continue;
                tryingToConvertBoolean = true;
            }
            Object obj = setters.get(var);
            List list = null;
            Method m2 = null;
            if (obj instanceof List) {
                list = (List)obj;
            } else {
                m2 = (Method)setters.get(var);
            }
            if (m2 != null) {
                Class<?> type;
                if (InjectionUtils.inject(m2, target, value, tryToConvert, tryingToConvertBoolean) || !allowRecursion || (type = m2.getParameterTypes()[0]).getName().startsWith("java.") || type.isPrimitive() || !InjectionUtils.hasDefaultConstructor(type)) continue;
                Object param = type.newInstance();
                InjectionUtils.getObject(param, provider, true, prefix, true, true, false);
                InjectionUtils.inject(m2, target, param, false, false);
                continue;
            }
            Iterator it = list.iterator();
            boolean injected = false;
            while (it.hasNext()) {
                m2 = (Method)it.next();
                if (!InjectionUtils.inject(m2, target, value, tryToConvert, tryingToConvertBoolean)) continue;
                injected = true;
                break;
            }
            if (injected || !allowRecursion) continue;
            for (Method m2 : list) {
                Class<?> type = m2.getParameterTypes()[0];
                if (type.getName().startsWith("java.") || type.isPrimitive() || !InjectionUtils.hasDefaultConstructor(type)) continue;
                Object param = type.newInstance();
                InjectionUtils.getObject(param, provider, true, prefix, true, true, false);
                if (!InjectionUtils.inject(m2, target, param, false, false)) continue;
                continue block8;
            }
        }
        if (fields != null) {
            for (String var : fields.keySet()) {
                hasValue = provider.hasValue(var);
                value = provider.get(var);
                Field f = (Field)fields.get(var);
                Class<?> type = f.getType();
                if (convertBoolean && value == null && !hasValue && (type.equals(Boolean.class) || type.equals(Boolean.TYPE))) {
                    value = Boolean.FALSE;
                }
                if (value == null && !hasValue || value != null && !type.isAssignableFrom(value.getClass()) && !InjectionUtils.checkPrimitives(type, value.getClass()) && (!tryToConvert || (!InjectionUtils.isBlank(value) || (value = InjectionUtils.shouldConvertToNull(value, type)) != null) && (value = InjectionUtils.tryToConvert(value, type)) == null)) continue;
                try {
                    f.set(target, value);
                }
                catch (Exception e) {
                    System.err.println("Error injecting by field: " + value + " in " + target);
                    e.printStackTrace();
                    throw e;
                }
            }
        }
    }

    public static interface Provider {
        public Object get(String var1);

        public boolean hasValue(String var1);
    }
}

