/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.mentabean.DBType;

public class BooleanIntType
implements DBType<Boolean> {
    private boolean canBeNull = true;

    @Override
    public boolean canBeNull() {
        return this.canBeNull;
    }

    public BooleanIntType nullable(boolean flag) {
        BooleanIntType b = new BooleanIntType();
        b.canBeNull = flag;
        return b;
    }

    @Override
    public String getAnsiType() {
        return "smallint";
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static Boolean getBoolValue(int x) throws SQLException {
        if (x == 1) {
            return Boolean.TRUE;
        }
        if (x == 0) {
            return Boolean.FALSE;
        }
        throw new SQLException("integer is not 0 or 1: " + x);
    }

    @Override
    public Boolean getFromResultSet(ResultSet rset, int index) throws SQLException {
        int x = rset.getInt(index);
        return BooleanIntType.getBoolValue(x);
    }

    @Override
    public Boolean getFromResultSet(ResultSet rset, String field) throws SQLException {
        int x = rset.getInt(field);
        return BooleanIntType.getBoolValue(x);
    }

    @Override
    public Class<? extends Object> getTypeClass() {
        return Boolean.class;
    }

    @Override
    public void bindToStmt(PreparedStatement stmt, int index, Boolean value) throws SQLException {
        if (value == null) {
            stmt.setInt(index, 0);
        } else if (value instanceof Boolean) {
            int x = value != false ? 1 : 0;
            stmt.setInt(index, x);
        }
    }
}

