/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean;

public class BeanException
extends RuntimeException {
    protected final Throwable rootCause;

    public BeanException() {
        this.rootCause = null;
    }

    public BeanException(Throwable e) {
        super(BeanException.getMsg(e), e);
        Throwable root = BeanException.getRootCause(e);
        this.setStackTrace(root.getStackTrace());
        this.rootCause = root == this ? null : root;
    }

    public BeanException(String msg) {
        super(msg);
        this.rootCause = null;
    }

    public BeanException(String msg, Throwable e) {
        super(msg, e);
        Throwable root = BeanException.getRootCause(e);
        this.setStackTrace(root.getStackTrace());
        this.rootCause = root == this ? null : root;
    }

    private static String getMsg(Throwable t) {
        Throwable root = BeanException.getRootCause(t);
        String msg = root.getMessage();
        if (!(msg != null && msg.length() != 0 || (msg = t.getMessage()) != null && msg.length() != 0)) {
            return root.getClass().getName();
        }
        return msg;
    }

    private static Throwable getRootCause(Throwable t) {
        Throwable root = t.getCause();
        if (root == null) {
            return t;
        }
        while (root.getCause() != null) {
            root = root.getCause();
        }
        return root;
    }

    @Override
    public Throwable getCause() {
        return this.rootCause;
    }
}

