package org.mentabean.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;

public class SQLUtils {
	
	public static void executeScript(Connection conn, String file, String charset) {
		
		FileInputStream fis = null;
		BufferedReader br = null;
		
		try {

			ScriptRunner script = new ScriptRunner(conn);
			
			fis = new FileInputStream(file);
			
			if (charset != null) {
			
				br = new BufferedReader(new InputStreamReader(fis, charset));
				
			} else {
				
				br = new BufferedReader(new InputStreamReader(fis));
			}
			
			script.runScript(br);
			
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	public static boolean checkIfTableExists(Connection conn, String tableName) {
		ResultSet rset = null;
		try {
			DatabaseMetaData dbm = conn.getMetaData();
		    rset = dbm.getTables(null, null, null, new String[] { "TABLE" });
		    while(rset.next()) {
		    	String tn = rset.getString("TABLE_NAME");
		    	if (tn.equalsIgnoreCase(tableName)) return true;
		    }
		    return false;
		} catch(Exception e) {
			throw new RuntimeException(e);
		} finally {
			if (rset != null) try { rset.close(); } catch(Exception e) { e.printStackTrace(); }
		}
	}
}