/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * MentaBean => http://www.mentabean.org
 * Author: Sergio Oliveira Jr. (sergio.oliveira.jr@gmail.com)
 */
package org.mentabean;

/**
 * A base implementation of MentaBean to be used by composition.
 * 
 * @author sergio.oliveira.jr@gmail.com
 */
public class BaseMentaBean implements MentaBean {

	private final BeanSession session;
	private final Object bean;

	public BaseMentaBean(Object bean, BeanSession session) {
		this.bean = bean;
		this.session = session;
	}

	@Override
	public void insert() {
		session.insert(bean);
	}

	@Override
	public boolean load() {
		return session.load(bean);
	}

	@Override
	public boolean update() {
		return session.update(bean) == 1;
	}

	@Override
	public boolean updateAll() {
		return session.updateAll(bean) == 1;
	}

	@Override
	public boolean delete() {
		return session.delete(bean);
	}
}