/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.mentabean.DBType;

public class BooleanStringType
implements DBType<Boolean> {
    private final String sTrue;
    private final String sFalse;

    public BooleanStringType() {
        this("T", "F");
    }

    public BooleanStringType(String sTrue, String sFalse) {
        this.sTrue = sTrue;
        this.sFalse = sFalse;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BooleanStringType) {
            BooleanStringType bt = (BooleanStringType)obj;
            if (bt.sTrue.equals(this.sTrue) && bt.sFalse.equals(this.sFalse)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected boolean getBooleanValue(String s) throws SQLException {
        if (s == null) {
            return false;
        }
        if (s.equals("T")) {
            return true;
        }
        if (s.equals("F")) {
            return false;
        }
        if (s.equals("0")) {
            return false;
        }
        if (s.equals("1")) {
            return true;
        }
        if (s.equals("true")) {
            return true;
        }
        if (s.equals("false")) {
            return false;
        }
        throw new SQLException("value is not a boolean: " + s);
    }

    private static Boolean getBoolValue(boolean b) {
        if (b) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean getFromResultSet(ResultSet rset, int index) throws SQLException {
        String s = rset.getString(index);
        boolean b = this.getBooleanValue(s);
        return BooleanStringType.getBoolValue(b);
    }

    @Override
    public Boolean getFromResultSet(ResultSet rset, String field) throws SQLException {
        String s = rset.getString(field);
        boolean b = this.getBooleanValue(s);
        return BooleanStringType.getBoolValue(b);
    }

    @Override
    public Class<? extends Object> getTypeClass() {
        return Boolean.class;
    }

    @Override
    public void bindToStmt(PreparedStatement stmt, int index, Boolean value) throws SQLException {
        if (value == null) {
            stmt.setString(index, null);
        } else {
            String s = value != false ? this.sTrue : this.sFalse;
            stmt.setString(index, s);
        }
    }
}

