/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.mentabean.BeanConfig;
import org.mentabean.BeanException;
import org.mentabean.BeanManager;
import org.mentabean.DBField;
import org.mentabean.jdbc.JdbcBeanSession;

public class MySQLBeanSession
extends JdbcBeanSession {
    public MySQLBeanSession(BeanManager beanManager, Connection conn) {
        super(beanManager, conn);
    }

    @Override
    protected String getNow() {
        return "now()";
    }

    @Override
    protected StringBuilder handleLimit(StringBuilder sb, String orderBy, int limit) {
        if (limit == -1) {
            return sb;
        }
        StringBuilder sbLimit = new StringBuilder(sb.length() + 32);
        sbLimit.append(sb.toString()).append(" LIMIT ").append(limit);
        return sbLimit;
    }

    @Override
    public void insert(Object bean) {
        super.insert(bean);
        BeanConfig bc = this.beanManager.getBeanConfig(bean.getClass());
        DBField autoIncrement = bc.getAutoIncrementField();
        if (autoIncrement == null) {
            return;
        }
        PreparedStatement stmt = null;
        ResultSet rset = null;
        StringBuilder sb = new StringBuilder("select last_insert_id() from ");
        sb.append(bc.getTableName());
        try {
            stmt = this.conn.prepareStatement(sb.toString());
            rset = stmt.executeQuery();
            if (rset.next()) {
                int id = rset.getInt(1);
                MySQLBeanSession.injectValue(bean, autoIncrement.getName(), id, Integer.class);
            }
        }
        catch (Exception e) {
            try {
                throw new BeanException(e);
            }
            catch (Throwable throwable) {
                MySQLBeanSession.close(stmt, rset);
                throw throwable;
            }
        }
        MySQLBeanSession.close(stmt, rset);
    }
}

