/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean.jdbc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mentabean.BeanConfig;
import org.mentabean.BeanException;
import org.mentabean.BeanManager;
import org.mentabean.BeanSession;
import org.mentabean.DBField;
import org.mentabean.DBType;
import org.mentabean.type.AutoIncrementType;
import org.mentabean.type.AutoTimestampType;
import org.mentabean.type.DateType;
import org.mentabean.type.TimeType;
import org.mentabean.type.TimestampType;
import org.mentabean.util.InjectionUtils;

public class JdbcBeanSession
implements BeanSession {
    protected static boolean DEBUG = false;
    protected IdentityHashMap<Object, Map<String, Value>> loaded = new IdentityHashMap();
    protected Connection conn;
    protected final BeanManager beanManager;

    public JdbcBeanSession(BeanManager beanManager, Connection conn) {
        this.beanManager = beanManager;
        this.conn = conn;
    }

    public static void debugSql(boolean b) {
        DEBUG = b;
    }

    public Connection getConnection() {
        return this.conn;
    }

    protected String getNow() {
        return null;
    }

    protected static Object getValueFromBean(Object bean, String fieldName) {
        return JdbcBeanSession.getValueFromBean(bean, fieldName, null);
    }

    protected static Object getValueFromBean(Object bean, String fieldName, Method m) {
        if (m == null) {
            m = InjectionUtils.findMethodToGet(bean.getClass(), fieldName);
        }
        if (m == null) {
            throw new BeanException("Cannot find method to get field from bean: " + fieldName);
        }
        Object value = null;
        try {
            value = m.invoke(bean, (Object[])null);
            return value;
        }
        catch (Exception e) {
            throw new BeanException(e);
        }
    }

    private static void checkPK(Object value, DBField dbField) {
        Number n;
        if (value == null) {
            throw new BeanException("pk is missing: " + dbField);
        }
        if (value instanceof Number && (n = (Number)value).doubleValue() <= 0.0) {
            throw new BeanException("Number pk is missing: " + dbField);
        }
    }

    @Override
    public boolean load(Object bean) {
        boolean bl;
        HashMap<String, Value> fieldsLoaded;
        ResultSet rset;
        PreparedStatement stmt;
        block19: {
            BeanConfig bc = this.beanManager.getBeanConfig(bean.getClass());
            if (bc == null) {
                throw new BeanException("Cannot find bean config: " + bean.getClass());
            }
            if (bc.getNumberOfFields() == 0) {
                throw new BeanException("BeanConfig has zero fields: " + bc);
            }
            StringBuilder sb = new StringBuilder(32 * bc.getNumberOfFields());
            sb.append("SELECT ");
            Iterator<DBField> iter = bc.fields();
            int count = 0;
            while (iter.hasNext()) {
                String fieldName = iter.next().getDbName();
                if (count++ > 0) {
                    sb.append(',');
                }
                sb.append(fieldName);
            }
            sb.append(" FROM ").append(bc.getTableName()).append(" WHERE ");
            if (!bc.hasPK()) {
                throw new BeanException("Cannot load bean without a PK!");
            }
            iter = bc.pks();
            count = 0;
            LinkedList<Value> values = new LinkedList<Value>();
            while (iter.hasNext()) {
                DBField dbField = iter.next();
                String fieldName = dbField.getName();
                String dbFieldName = dbField.getDbName();
                Object value = JdbcBeanSession.getValueFromBean(bean, fieldName);
                JdbcBeanSession.checkPK(value, dbField);
                if (count++ > 0) {
                    sb.append(" AND ");
                }
                sb.append(dbFieldName).append("=?");
                values.add(new Value(dbField, value));
            }
            if (values.isEmpty()) {
                throw new BeanException("Bean is empty: " + bean + " / " + bc);
            }
            if (this.conn == null) {
                throw new BeanException("Connection is null!");
            }
            stmt = null;
            rset = null;
            if (DEBUG) {
                System.out.println("LOAD SQL: " + sb.toString());
            }
            stmt = this.conn.prepareStatement(sb.toString());
            Iterator iter2 = values.iterator();
            int index = 0;
            while (iter2.hasNext()) {
                Value v = (Value)iter2.next();
                v.field.getType().bindToStmt(stmt, ++index, v.value);
            }
            rset = stmt.executeQuery();
            index = 0;
            fieldsLoaded = new HashMap<String, Value>();
            if (rset.next()) {
                iter = bc.fields();
                while (iter.hasNext()) {
                    DBField f = iter.next();
                    String fieldName = f.getName();
                    DBType type = f.getType();
                    Object value = type.getFromResultSet(rset, ++index);
                    JdbcBeanSession.injectValue(bean, fieldName, value, type.getTypeClass());
                    fieldsLoaded.put(fieldName, new Value(f, value));
                }
                break block19;
            }
            boolean bl2 = false;
            JdbcBeanSession.close(stmt, rset);
            return bl2;
        }
        try {
            if (rset.next()) {
                throw new BeanException("Load returned more than one row!");
            }
            this.loaded.put(bean, fieldsLoaded);
            bl = true;
        }
        catch (Exception e) {
            try {
                throw new BeanException(e);
            }
            catch (Throwable throwable) {
                JdbcBeanSession.close(stmt, rset);
                throw throwable;
            }
        }
        JdbcBeanSession.close(stmt, rset);
        return bl;
    }

    protected static void injectValue(Object bean, String fieldName, Object value, Class<? extends Object> valueType) {
        Method m = InjectionUtils.findMethodToInject(bean.getClass(), fieldName, value == null ? valueType : value.getClass());
        if (m == null) {
            Field field = InjectionUtils.findFieldToInject(bean.getClass(), fieldName, value == null ? valueType : value.getClass());
            if (field != null) {
                try {
                    field.set(bean, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BeanException(e);
                }
            }
            throw new BeanException("Cannot find field or method to inject: " + bean + " / " + fieldName);
        }
        try {
            m.invoke(bean, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BeanException(e);
        }
    }

    protected StringBuilder handleLimit(StringBuilder sb, String orderBy, int limit) {
        return sb;
    }

    public String buildSelect(Class<? extends Object> beanClass) {
        return this.buildSelectImpl(beanClass, null, null);
    }

    public String buildSelect(Class<? extends Object> beanClass, String tablePrefix) {
        return this.buildSelectImpl(beanClass, tablePrefix, null);
    }

    public String buildSelectMinus(Class<? extends Object> beanClass, String[] minus) {
        return this.buildSelectImpl(beanClass, null, minus);
    }

    public String buildSelectMinus(Class<? extends Object> beanClass, String tablePrefix, String[] minus) {
        return this.buildSelectImpl(beanClass, tablePrefix, minus);
    }

    private String buildSelectImpl(Class<? extends Object> beanClass, String tablePrefix, String[] minus) {
        BeanConfig bc = this.beanManager.getBeanConfig(beanClass);
        if (bc == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(32 * bc.getNumberOfFields());
        Iterator<DBField> iter = bc.fields();
        int count = 0;
        while (iter.hasNext()) {
            String name;
            DBField field = iter.next();
            String dbField = field.getDbName();
            if (minus != null && minus.length > 0 && JdbcBeanSession.checkArray(name = field.getName(), minus)) continue;
            if (count++ > 0) {
                sb.append(",");
            }
            if (tablePrefix != null) {
                sb.append(tablePrefix).append('.');
                sb.append(dbField).append(' ');
                sb.append(tablePrefix).append('_').append(dbField);
                continue;
            }
            sb.append(dbField);
        }
        return sb.toString();
    }

    private static boolean checkArray(String value, String[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    public void populateBean(ResultSet rset, Object bean) {
        this.populateBeanImpl(rset, bean, null, null);
    }

    public void populateBean(ResultSet rset, Object bean, String tablePrefix) {
        this.populateBeanImpl(rset, bean, tablePrefix, null);
    }

    public void populateBeanMinus(ResultSet rset, Object bean, String[] minus) {
        this.populateBeanImpl(rset, bean, null, minus);
    }

    public void populateBeanMinus(ResultSet rset, Object bean, String tablePrefix, String[] minus) {
        this.populateBeanImpl(rset, bean, tablePrefix, minus);
    }

    private void populateBeanImpl(ResultSet rset, Object bean, String tablePrefix, String[] minus) {
        BeanConfig bc = this.beanManager.getBeanConfig(bean.getClass());
        if (bc == null) {
            throw new BeanException("Cannot find bean config: " + bean.getClass());
        }
        Iterator<DBField> iter = bc.fields();
        StringBuilder sbField = new StringBuilder(32);
        while (iter.hasNext()) {
            DBField f = iter.next();
            String fieldName = f.getName();
            if (minus != null && minus.length > 0 && JdbcBeanSession.checkArray(fieldName, minus)) continue;
            String dbFieldName = f.getDbName();
            DBType type = f.getType();
            sbField.setLength(0);
            if (tablePrefix != null) {
                sbField.append(tablePrefix).append('_').append(dbFieldName);
            } else {
                sbField.append(dbFieldName);
            }
            try {
                Object value = type.getFromResultSet(rset, sbField.toString());
                JdbcBeanSession.injectValue(bean, fieldName, value, type.getTypeClass());
            }
            catch (Exception e) {
                throw new BeanException(e);
            }
        }
    }

    public <E> List<E> loadListMinus(E bean, String[] minus, String orderBy, int limit) {
        return this.loadListImpl(bean, minus, orderBy, limit);
    }

    private <E> E checkUnique(List<E> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            throw new BeanException("Query returned more than one bean!");
        }
        return list.get(0);
    }

    @Override
    public <E> List<E> loadList(E bean, String orderBy, int limit) {
        return this.loadListImpl(bean, null, orderBy, limit);
    }

    private <E> StringBuilder prepareListQuery(StringBuilder sb, BeanConfig bc, E bean, String orderBy, int limit, List<Value> values) {
        sb.append(" FROM ").append(bc.getTableName()).append(" ");
        Iterator<DBField> iter = bc.fields();
        int count = 0;
        while (iter.hasNext()) {
            DBField field = iter.next();
            String dbField = field.getDbName();
            Method m = InjectionUtils.findMethodToGet(bean.getClass(), field.getName());
            if (m == null) {
                throw new BeanException("Cannot find method to get field from bean: " + field.getName());
            }
            Class<?> returnType = m.getReturnType();
            Object value = JdbcBeanSession.getValueFromBean(bean, field.getName(), m);
            if (!this.isSet(value, returnType)) continue;
            if (count++ > 0) {
                sb.append(" AND ");
            } else {
                sb.append(" WHERE ");
            }
            sb.append(dbField).append("=?");
            values.add(new Value(field, value));
        }
        if (orderBy != null) {
            sb.append(" order by ").append(orderBy).append(" ");
        }
        sb = this.handleLimit(sb, orderBy, limit);
        return sb;
    }

    @Override
    public int countList(Object bean) {
        return this.countListImpl(bean, null, null, -1);
    }

    private int countListImpl(Object bean, String[] minus, String orderBy, int limit) {
        int n;
        if (limit == 0) {
            return 0;
        }
        BeanConfig bc = this.beanManager.getBeanConfig(bean.getClass());
        if (bc == null) {
            throw new BeanException("Cannot find bean config: " + bean.getClass());
        }
        StringBuilder sb = new StringBuilder(32 * bc.getNumberOfFields());
        sb.append("SELECT count(1)");
        LinkedList<Value> values = new LinkedList<Value>();
        sb = this.prepareListQuery(sb, bc, bean, orderBy, limit, values);
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            String sql = sb.toString();
            if (DEBUG) {
                System.out.println("COUNT LIST: " + sql);
            }
            stmt = this.conn.prepareStatement(sql);
            Iterator iter2 = values.iterator();
            int index = 0;
            while (iter2.hasNext()) {
                Value v = (Value)iter2.next();
                v.field.getType().bindToStmt(stmt, ++index, v.value);
            }
            rset = stmt.executeQuery();
            rset.next();
            n = rset.getInt(1);
        }
        catch (Exception e) {
            try {
                throw new BeanException(e);
            }
            catch (Throwable throwable) {
                JdbcBeanSession.close(stmt, rset);
                throw throwable;
            }
        }
        JdbcBeanSession.close(stmt, rset);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <E> List<E> loadListImpl(E bean, String[] minus, String orderBy, int limit) {
        if (limit == 0) {
            return new ArrayList();
        }
        BeanConfig bc = this.beanManager.getBeanConfig(bean.getClass());
        if (bc == null) {
            throw new BeanException("Cannot find bean config: " + bean.getClass());
        }
        StringBuilder sb = new StringBuilder(32 * bc.getNumberOfFields());
        Iterator<DBField> iter = bc.fields();
        sb.append("SELECT ");
        int count = 0;
        while (iter.hasNext()) {
            DBField field = iter.next();
            String dbField = field.getDbName();
            String name = field.getName();
            if (JdbcBeanSession.checkArray(name, minus)) continue;
            if (count++ > 0) {
                sb.append(",");
            }
            sb.append(dbField);
        }
        LinkedList<Value> values = new LinkedList<Value>();
        sb = this.prepareListQuery(sb, bc, bean, orderBy, limit, values);
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            String sql = sb.toString();
            if (DEBUG) {
                System.out.println("LOAD LIST: " + sql);
            }
            stmt = this.conn.prepareStatement(sql);
            Iterator iter2 = values.iterator();
            int index = 0;
            while (iter2.hasNext()) {
                Value v = (Value)iter2.next();
                v.field.getType().bindToStmt(stmt, ++index, v.value);
            }
            rset = stmt.executeQuery();
            LinkedList results = new LinkedList();
            Class<?> beanKlass = bean.getClass();
            int total = 0;
            do {
                Object item;
                if (rset.next()) {
                    iter = bc.fields();
                    index = 0;
                    item = beanKlass.newInstance();
                } else {
                    LinkedList linkedList = results;
                    JdbcBeanSession.close(stmt, rset);
                    return linkedList;
                }
                while (iter.hasNext()) {
                    DBField f = iter.next();
                    String fieldName = f.getName();
                    if (JdbcBeanSession.checkArray(fieldName, minus)) continue;
                    DBType type = f.getType();
                    Object value = type.getFromResultSet(rset, ++index);
                    JdbcBeanSession.injectValue(item, fieldName, value, type.getTypeClass());
                }
                results.add(item);
            } while (limit <= 0 || ++total != limit);
            LinkedList linkedList = results;
            JdbcBeanSession.close(stmt, rset);
            return linkedList;
        }
        catch (Exception e) {
            try {
                throw new BeanException(e);
            }
            catch (Throwable throwable) {
                JdbcBeanSession.close(stmt, rset);
                throw throwable;
            }
        }
    }

    protected boolean isSet(Object value, Class<? extends Object> returnType) {
        if (value != null) {
            if (returnType.equals(Boolean.TYPE) && value instanceof Boolean) {
                boolean b = (Boolean)value;
                return b;
            }
            if (returnType.equals(Character.TYPE) && value instanceof Character) {
                char c = ((Character)value).charValue();
                return c != '\u0000';
            }
            if (returnType.isPrimitive() && !returnType.equals(Boolean.TYPE) && !returnType.equals(Character.TYPE) && value instanceof Number) {
                Number n = (Number)value;
                if (n.intValue() != 0) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    public int update(Object bean) {
        return this.update(bean, true);
    }

    @Override
    public int updateAll(Object bean) {
        return this.update(bean, false);
    }

    private int update(Object bean, boolean dynUpdate) {
        int n;
        PreparedStatement stmt;
        LinkedList<Value> values;
        Map<String, Value> fieldsLoaded;
        block28: {
            DBField dbField;
            fieldsLoaded = this.loaded.get(bean);
            BeanConfig bc = this.beanManager.getBeanConfig(bean.getClass());
            if (bc == null) {
                throw new BeanException("Cannot find bean config: " + bean.getClass());
            }
            if (bc.getNumberOfFields() == 0) {
                throw new BeanException("BeanConfig has zero fields: " + bc);
            }
            StringBuilder sb = new StringBuilder(32 * bc.getNumberOfFields());
            sb.append("UPDATE ").append(bc.getTableName()).append(" SET ");
            Iterator<DBField> iter = bc.fields();
            int count = 0;
            values = new LinkedList<Value>();
            while (iter.hasNext()) {
                DBType type;
                dbField = iter.next();
                if (dbField.isPK() || (type = dbField.getType()) instanceof AutoIncrementType || type instanceof AutoTimestampType) continue;
                String fieldName = dbField.getName();
                String dbFieldName = dbField.getDbName();
                Method m = InjectionUtils.findMethodToGet(bean.getClass(), fieldName);
                if (m == null) {
                    throw new BeanException("Cannot find method to get field from bean: " + fieldName);
                }
                Class<?> returnType = m.getReturnType();
                Object value = JdbcBeanSession.getValueFromBean(bean, fieldName, m);
                boolean update = false;
                if (!dynUpdate) {
                    update = true;
                } else if (fieldsLoaded != null) {
                    Value v = fieldsLoaded.get(fieldName);
                    if (v != null) {
                        update = value == null && v.value != null ? true : (value != null && v.value == null ? true : (value == null && v.value == null ? false : !value.equals(v.value)));
                    }
                } else {
                    update = this.isSet(value, returnType);
                }
                if (!update) continue;
                if (count++ > 0) {
                    sb.append(',');
                }
                sb.append(dbFieldName).append("=?");
                values.add(new Value(dbField, value));
            }
            if (count == 0) {
                return 0;
            }
            sb.append(" WHERE ");
            if (!bc.hasPK()) {
                throw new BeanException("Cannot update bean without a PK!");
            }
            iter = bc.pks();
            count = 0;
            while (iter.hasNext()) {
                Number n2;
                dbField = iter.next();
                String fieldName = dbField.getName();
                String dbFieldName = dbField.getDbName();
                Object value = JdbcBeanSession.getValueFromBean(bean, fieldName);
                if (value == null) {
                    throw new BeanException("pk is missing: " + dbField);
                }
                if (value instanceof Number && (n2 = (Number)value).doubleValue() <= 0.0) {
                    throw new BeanException("Number pk is missing: " + dbField);
                }
                if (count++ > 0) {
                    sb.append(" AND ");
                }
                sb.append(dbFieldName).append("=?");
                values.add(new Value(dbField, value));
            }
            if (values.isEmpty()) {
                throw new BeanException("Bean is empty: " + bean + " / " + bc);
            }
            if (this.conn == null) {
                throw new BeanException("Connection is null!");
            }
            stmt = null;
            if (DEBUG) {
                System.out.println("UPDATE SQL: " + sb.toString());
            }
            stmt = this.conn.prepareStatement(sb.toString());
            Iterator iter2 = values.iterator();
            int index = 0;
            while (iter2.hasNext()) {
                Value v = (Value)iter2.next();
                v.field.getType().bindToStmt(stmt, ++index, v.value);
            }
            int x = stmt.executeUpdate();
            if (x > 1) {
                throw new BeanException("update modified more than one line: " + x);
            }
            if (x != 0) break block28;
            int n2 = 0;
            JdbcBeanSession.close(stmt);
            return n2;
        }
        try {
            if (fieldsLoaded != null) {
                for (Value v : values) {
                    Value vv;
                    if (v.field.isPK() || (vv = fieldsLoaded.get(v.field.getName())) == null) continue;
                    vv.value = v.value;
                }
            }
            n = 1;
        }
        catch (Exception e) {
            try {
                throw new BeanException(e);
            }
            catch (Throwable throwable) {
                JdbcBeanSession.close(stmt);
                throw throwable;
            }
        }
        JdbcBeanSession.close(stmt);
        return n;
    }

    @Override
    public void insert(Object bean) {
        Object value;
        DBType type;
        String dbFieldName;
        String fieldName;
        DBField dbField;
        BeanConfig bc = this.beanManager.getBeanConfig(bean.getClass());
        if (bc == null) {
            throw new BeanException("Cannot find bean config: " + bean.getClass());
        }
        if (bc.getNumberOfFields() == 0) {
            throw new BeanException("BeanConfig has zero fields: " + bc);
        }
        StringBuilder sb = new StringBuilder(32 * bc.getNumberOfFields());
        sb.append("INSERT INTO ").append(bc.getTableName()).append("(");
        Iterator<DBField> iter = bc.pks();
        int count = 0;
        LinkedList<Value> values = new LinkedList<Value>();
        while (iter.hasNext()) {
            dbField = iter.next();
            fieldName = dbField.getName();
            dbFieldName = dbField.getDbName();
            type = dbField.getType();
            if (type instanceof AutoIncrementType || type instanceof AutoTimestampType) continue;
            value = JdbcBeanSession.getValueFromBean(bean, fieldName);
            if (count++ > 0) {
                sb.append(',');
            }
            sb.append(dbFieldName);
            values.add(new Value(dbField, value));
        }
        iter = bc.fields();
        while (iter.hasNext()) {
            dbField = iter.next();
            if (dbField.isPK()) continue;
            fieldName = dbField.getName();
            dbFieldName = dbField.getDbName();
            type = dbField.getType();
            if (type instanceof AutoIncrementType || type instanceof AutoTimestampType) continue;
            value = JdbcBeanSession.getValueFromBean(bean, fieldName);
            boolean isSysdate = false;
            if (type instanceof DateType || type instanceof TimeType || type instanceof TimestampType) {
                boolean bl = isSysdate = dbField.isDefaultToNow() && value == null;
                if (isSysdate && this.getNow() == null) {
                    value = new Date();
                }
            }
            if (count++ > 0) {
                sb.append(',');
            }
            sb.append(dbFieldName);
            values.add(new Value(dbField, value, isSysdate));
        }
        if (count == 0) {
            throw new BeanException("There is nothing to insert!");
        }
        sb.append(") VALUES(");
        Iterator valuesIter = values.iterator();
        int i = 0;
        while (valuesIter.hasNext()) {
            Value v = (Value)valuesIter.next();
            if (i > 0) {
                sb.append(',');
            }
            if (v.isSysdate && this.getNow() != null) {
                sb.append(this.getNow());
            } else {
                sb.append('?');
            }
            ++i;
        }
        sb.append(')');
        if (values.isEmpty()) {
            throw new BeanException("Bean is empty: " + bean + " / " + bc);
        }
        if (this.conn == null) {
            throw new BeanException("Connection is null!");
        }
        PreparedStatement stmt = null;
        try {
            if (DEBUG) {
                System.out.println("INSERT SQL: " + sb.toString());
            }
            stmt = this.conn.prepareStatement(sb.toString());
            Iterator iter2 = values.iterator();
            int index = 0;
            HashMap<String, Value> fieldsLoaded = new HashMap<String, Value>();
            while (iter2.hasNext()) {
                Value v = (Value)iter2.next();
                if (v.isSysdate && this.getNow() != null) continue;
                v.field.getType().bindToStmt(stmt, ++index, v.value);
                fieldsLoaded.put(v.field.getName(), v);
            }
            int x = stmt.executeUpdate();
            if (x > 1) {
                throw new BeanException("insert modified more than one line: " + x);
            }
            if (x == 0) {
                throw new BeanException("Nothing was inserted! Insert returned 0 rows!");
            }
            this.loaded.put(bean, fieldsLoaded);
        }
        catch (Exception e) {
            try {
                throw new BeanException(e);
            }
            catch (Throwable throwable) {
                JdbcBeanSession.close(stmt);
                throw throwable;
            }
        }
        JdbcBeanSession.close(stmt);
    }

    @Override
    public boolean delete(Object bean) {
        boolean bl;
        PreparedStatement stmt;
        block16: {
            BeanConfig bc = this.beanManager.getBeanConfig(bean.getClass());
            if (bc.getNumberOfFields() == 0) {
                throw new BeanException("BeanConfig has zero fields: " + bc);
            }
            StringBuilder sb = new StringBuilder(32 * bc.getNumberOfFields());
            sb.append("DELETE FROM ").append(bc.getTableName()).append(" WHERE ");
            if (!bc.hasPK()) {
                throw new BeanException("Cannot delete bean without a PK!");
            }
            Iterator<DBField> iter = bc.pks();
            LinkedList<Value> values = new LinkedList<Value>();
            int count = 0;
            while (iter.hasNext()) {
                Number n;
                DBField dbField = iter.next();
                String fieldName = dbField.getName();
                String dbFieldName = dbField.getDbName();
                Object value = JdbcBeanSession.getValueFromBean(bean, fieldName);
                if (value == null) {
                    throw new BeanException("pk is missing: " + dbField);
                }
                if (value instanceof Number && (n = (Number)value).doubleValue() <= 0.0) {
                    throw new BeanException("Number pk is missing: " + dbField);
                }
                if (count++ > 0) {
                    sb.append(" AND ");
                }
                sb.append(dbFieldName).append("=?");
                values.add(new Value(dbField, value));
            }
            if (values.isEmpty()) {
                throw new BeanException("Bean is empty: " + bean + " / " + bc);
            }
            if (this.conn == null) {
                throw new BeanException("Connection is null!");
            }
            stmt = null;
            if (DEBUG) {
                System.out.println("DELETE SQL: " + sb.toString());
            }
            stmt = this.conn.prepareStatement(sb.toString());
            Iterator iter2 = values.iterator();
            int index = 0;
            while (iter2.hasNext()) {
                Value v = (Value)iter2.next();
                v.field.getType().bindToStmt(stmt, ++index, v.value);
            }
            int x = stmt.executeUpdate();
            if (x > 1) {
                throw new BeanException("delete modified more than one line: " + x);
            }
            if (x != 0) break block16;
            boolean bl2 = false;
            JdbcBeanSession.close(stmt);
            return bl2;
        }
        try {
            this.loaded.remove(bean);
            bl = true;
        }
        catch (Exception e) {
            try {
                throw new BeanException(e);
            }
            catch (Throwable throwable) {
                JdbcBeanSession.close(stmt);
                throw throwable;
            }
        }
        JdbcBeanSession.close(stmt);
        return bl;
    }

    @Override
    public <E> List<E> loadList(E bean) {
        return this.loadList(bean, null, -1);
    }

    @Override
    public <E> E loadUnique(E bean) {
        return this.checkUnique(this.loadList(bean, null, 2));
    }

    @Override
    public <E> List<E> loadList(E bean, String orderBy) {
        return this.loadList(bean, orderBy, -1);
    }

    @Override
    public <E> List<E> loadList(E bean, int limit) {
        return this.loadList(bean, null, limit);
    }

    public <E> List<E> loadListMinus(E bean, String[] minus) {
        return this.loadListMinus(bean, minus, null, -1);
    }

    public <E> List<E> loadListMinus(E bean, String[] minus, String orderBy) {
        return this.loadListMinus(bean, minus, orderBy, -1);
    }

    public <E> List<E> loadListMinus(E bean, String[] minus, int limit) {
        return this.loadListMinus(bean, minus, null, limit);
    }

    static void close(PreparedStatement stmt) {
        JdbcBeanSession.close(stmt, null);
    }

    static void close(PreparedStatement stmt, ResultSet rset) {
        if (rset != null) {
            try {
                rset.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class Value {
        public Object value;
        public DBField field;
        public boolean isSysdate;

        public Value(DBField field, Object value, boolean isSysdate) {
            this.field = field;
            this.value = value;
            this.isSysdate = isSysdate;
        }

        public Value(DBField field, Object value) {
            this(field, value, false);
        }
    }
}

