/*
 * Decompiled with CFR 0.152.
 */
package org.mentabean;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.mentabean.DBField;
import org.mentabean.DBType;
import org.mentabean.type.AutoIncrementType;
import org.mentabean.type.SequenceType;

public class BeanConfig {
    private final List<DBField> fieldList = new LinkedList<DBField>();
    private final List<DBField> pkList = new LinkedList<DBField>();
    private final Class<? extends Object> beanClass;
    private final String tableName;
    private DBField sequence = null;
    private DBField autoincrement = null;

    public BeanConfig(Class<? extends Object> beanClass, String tableName) {
        this.beanClass = beanClass;
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Class<? extends Object> getBeanClass() {
        return this.beanClass;
    }

    private DBField findDBField(String name) {
        for (DBField f : this.fieldList) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    private BeanConfig addField(String name, String dbName, DBType type, boolean isPK) {
        if (!isPK) {
            if (type instanceof SequenceType) {
                throw new IllegalStateException("A sequence type can only be a primary key!");
            }
            if (type instanceof AutoIncrementType) {
                throw new IllegalStateException("A auto-increment type can only be a primary key!");
            }
        }
        DBField f = new DBField(name, dbName, type, isPK);
        this.fieldList.add(f);
        if (isPK) {
            this.pkList.add(f);
            if (type instanceof SequenceType) {
                if (this.sequence != null) {
                    throw new IllegalStateException("A bean can have only one sequence field!");
                }
                this.sequence = f;
            } else if (type instanceof AutoIncrementType) {
                if (this.autoincrement != null) {
                    throw new IllegalStateException("A bean can have only one auto-increment field!");
                }
                this.autoincrement = f;
            }
        }
        return this;
    }

    public DBField getAutoIncrementField() {
        return this.autoincrement;
    }

    public DBField getSequenceField() {
        return this.sequence;
    }

    public BeanConfig defaultToNow(String name) {
        DBField f = this.findDBField(name);
        if (f == null) {
            throw new IllegalArgumentException("Cannot find field with name: " + name);
        }
        f.setDefaultToNow(true);
        return this;
    }

    public BeanConfig field(String name, DBType type) {
        return this.addField(name, name, type, false);
    }

    public BeanConfig field(String name, String dbName, DBType type) {
        return this.addField(name, dbName, type, false);
    }

    public BeanConfig pk(String name, DBType type) {
        return this.addField(name, name, type, true);
    }

    public BeanConfig pk(String name, String dbName, DBType type) {
        return this.addField(name, dbName, type, true);
    }

    public int getNumberOfFields() {
        return this.fieldList.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("BeanConfig: ").append(this.beanClass.getName()).append(" tableName=").append(this.tableName);
        return sb.toString();
    }

    public Iterator<DBField> fields() {
        return this.fieldList.iterator();
    }

    public boolean hasPK() {
        return !this.pkList.isEmpty();
    }

    public Iterator<DBField> pks() {
        return this.pkList.iterator();
    }
}

