/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.servicecatalog;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import io.fabric8.kubernetes.model.annotation.ApiGroup;
import io.fabric8.kubernetes.model.annotation.ApiVersion;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.jsonschema2pojo.Jackson2Annotator;

public class ServiceCatalogTypeAnnotator
extends Jackson2Annotator {
    private final Map<String, JDefinedClass> pendingResources = new HashMap<String, JDefinedClass>();
    private final Map<String, JDefinedClass> pendingLists = new HashMap<String, JDefinedClass>();

    public void propertyOrder(JDefinedClass clazz, JsonNode propertiesNode) {
        clazz.annotate(JsonDeserialize.class).param("using", JsonDeserializer.None.class);
        clazz.annotate(ToString.class);
        clazz.annotate(EqualsAndHashCode.class);
        try {
            JAnnotationUse buildable = clazz.annotate(Buildable.class).param("editableEnabled", false).param("validationEnabled", true).param("generateBuilderPackage", false).param("builderPackage", "io.fabric8.kubernetes.api.builder");
            buildable.paramArray("inline").annotate(Inline.class).param("type", (JType)new JCodeModel()._class("io.fabric8.kubernetes.api.model.Doneable")).param("prefix", "Doneable").param("value", "done");
            buildable.paramArray("refs").annotate(BuildableReference.class).param("value", (JType)new JCodeModel()._class("io.fabric8.kubernetes.api.model.ObjectMeta"));
        }
        catch (JClassAlreadyExistsException e) {
            e.printStackTrace();
        }
        if (clazz.fields().containsKey("kind") && clazz.fields().containsKey("metadata")) {
            String resourceName;
            if (clazz.name().endsWith("List")) {
                resourceName = clazz.name().substring(0, clazz.name().length() - 4);
                this.pendingLists.put(resourceName, clazz);
            } else {
                resourceName = clazz.name();
                this.pendingResources.put(clazz.name(), clazz);
            }
            if (this.pendingResources.containsKey(resourceName) && this.pendingLists.containsKey(resourceName)) {
                JDefinedClass resourceClass = this.pendingResources.get(resourceName);
                JDefinedClass resourceListClass = this.pendingLists.get(resourceName);
                String apiVersion = propertiesNode.get("apiVersion").get("default").toString().replaceAll(Pattern.quote("\""), "");
                String apiGroup = "";
                if (apiVersion.contains("/")) {
                    apiGroup = apiVersion.substring(0, apiVersion.lastIndexOf("/"));
                    apiVersion = apiVersion.substring(apiGroup.length() + 1);
                }
                resourceClass.annotate(ApiVersion.class).param("value", apiVersion);
                resourceClass.annotate(ApiGroup.class).param("value", apiGroup);
                resourceListClass.annotate(ApiVersion.class).param("value", apiVersion);
                resourceListClass.annotate(ApiGroup.class).param("value", apiGroup);
                JAnnotationArrayMember arrayMember = resourceClass.annotate(VelocityTransformations.class).paramArray("value");
                arrayMember.annotate(VelocityTransformation.class).param("value", "/manifest.vm").param("outputPath", "servicecatalog.properties").param("gather", true);
                this.pendingLists.remove(resourceName);
                this.pendingResources.remove(resourceName);
            }
        }
    }

    public void propertyInclusion(JDefinedClass clazz, JsonNode schema) {
    }

    public void propertyField(JFieldVar field, JDefinedClass clazz, String propertyName, JsonNode propertyNode) {
    }

    public void propertyGetter(JMethod getter, String propertyName) {
    }

    public void propertySetter(JMethod setter, String propertyName) {
    }

    public void anyGetter(JMethod getter) {
    }

    public void anySetter(JMethod setter) {
    }

    public void enumCreatorMethod(JMethod creatorMethod) {
    }

    public void enumValueMethod(JMethod valueMethod) {
    }

    public void enumConstant(JEnumConstant constant, String value) {
    }

    public boolean isAdditionalPropertiesSupported() {
        return true;
    }

    public void additionalPropertiesField(JFieldVar field, JDefinedClass clazz, String propertyName) {
    }
}

