/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.boot.narayana.openshift.recovery;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import me.snowdrop.boot.narayana.openshift.recovery.PodStatus;
import me.snowdrop.boot.narayana.openshift.recovery.PodStatusManager;
import me.snowdrop.boot.narayana.openshift.recovery.StatefulsetRecoveryControllerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class StatefulsetRecoveryController {
    private static final Logger LOG = LoggerFactory.getLogger(StatefulsetRecoveryController.class);
    private StatefulsetRecoveryControllerProperties properties;
    private PodStatusManager podStatusManager;

    public StatefulsetRecoveryController(StatefulsetRecoveryControllerProperties properties, PodStatusManager podStatusManager) {
        this.properties = Objects.requireNonNull(properties, "No properties set");
        this.podStatusManager = Objects.requireNonNull(podStatusManager, "No podStatusManager set");
        Objects.requireNonNull(properties.getStatefulset(), "statefulset property missing in recovery controller configuration");
        Objects.requireNonNull(properties.getCurrentPodName(), "current-pod-name property missing in recovery controller configuration");
        Objects.requireNonNull(Long.valueOf(properties.getPeriod()), "period property missing in recovery controller configuration");
    }

    @Scheduled(fixedDelayString="${snowdrop.narayana.openshift.recovery.period:30000}", initialDelayString="${snowdrop.narayana.openshift.recovery.period:30000}")
    public void periodicCheck() throws Exception {
        if (this.properties.isEnabledOnAllPods() || this.isMainStatefulsetPod()) {
            try (DefaultOpenShiftClient client = new DefaultOpenShiftClient();){
                Set pendingPods = this.podStatusManager.getAllPodsStatus().entrySet().stream().filter(e -> !Optional.of(PodStatus.STOPPED).equals(e.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
                LOG.debug("Found {} pods not stopped: {}", (Object)pendingPods.size(), pendingPods);
                int minReplicas = 0;
                for (String podName : pendingPods) {
                    LOG.debug("Retrieving pod {} from Openshift", (Object)podName);
                    Pod pod = (Pod)((PodResource)client.pods().withName(podName)).get();
                    if (pod == null) {
                        LOG.debug("Pod {} not found in Openshift", (Object)podName);
                        OptionalInt prg = this.getProgressiveNumber(podName);
                        if (!prg.isPresent()) {
                            LOG.warn("Status manager contains pods not belonging to the Statefulset: {}", (Object)podName);
                            continue;
                        }
                        minReplicas = Math.max(minReplicas, prg.getAsInt() + 1);
                        continue;
                    }
                    LOG.debug("Pod {} is running on Openshift", (Object)podName);
                }
                LOG.debug("StatefulSet requires a minimum of {} replicas", (Object)minReplicas);
                if (minReplicas > 1) {
                    StatefulSet statefulSet = (StatefulSet)((RollableScalableResource)client.apps().statefulSets().withName(this.properties.getStatefulset())).get();
                    if (statefulSet == null) {
                        LOG.warn("Cannot find StatefulSet named {} in namespace", (Object)this.properties.getStatefulset());
                    } else {
                        int replicas = statefulSet.getSpec().getReplicas();
                        if (replicas > 0 && replicas < minReplicas) {
                            LOG.warn("Pod {}-{} has pending work and must be restored again", (Object)this.properties.getStatefulset(), (Object)(minReplicas - 1));
                            LOG.debug("Scaling the statefulset back to {} replicas", (Object)minReplicas);
                            ((RollableScalableResource)client.apps().statefulSets().withName(this.properties.getStatefulset())).scale(minReplicas);
                            LOG.info("Statefulset {} successfully scaled to {} replicas", (Object)this.properties.getStatefulset(), (Object)minReplicas);
                        } else if (replicas == 0) {
                            LOG.debug("StatefulSet {} is going to be shut down. Controller will not interfere", (Object)this.properties.getStatefulset(), (Object)replicas);
                        } else {
                            LOG.debug("StatefulSet {} has a sufficient number of replicas: {} >= {}", new Object[]{this.properties.getStatefulset(), replicas, minReplicas});
                        }
                    }
                }
            }
        }
    }

    private boolean isMainStatefulsetPod() {
        return this.getProgressiveNumber(this.properties.getCurrentPodName()).equals(OptionalInt.of(0));
    }

    private OptionalInt getProgressiveNumber(String podName) {
        try {
            return OptionalInt.of(Integer.parseInt(podName.substring(this.properties.getStatefulset().length() + 1), 10));
        }
        catch (Exception e) {
            LOG.warn("Cannot extract progressive number from pod name: " + podName);
            return OptionalInt.empty();
        }
    }
}

