/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.adapter.solarwinds;

import io.fabric8.kubernetes.api.builder.v5_1.VisitableBuilder;
import me.snowdrop.istio.mixer.adapter.solarwinds.Solarwinds;
import me.snowdrop.istio.mixer.adapter.solarwinds.SolarwindsFluent;
import me.snowdrop.istio.mixer.adapter.solarwinds.SolarwindsFluentImpl;

public class SolarwindsBuilder
extends SolarwindsFluentImpl<SolarwindsBuilder>
implements VisitableBuilder<Solarwinds, SolarwindsBuilder> {
    SolarwindsFluent<?> fluent;
    Boolean validationEnabled;

    public SolarwindsBuilder() {
        this(true);
    }

    public SolarwindsBuilder(Boolean validationEnabled) {
        this(new Solarwinds(), validationEnabled);
    }

    public SolarwindsBuilder(SolarwindsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SolarwindsBuilder(SolarwindsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Solarwinds(), validationEnabled);
    }

    public SolarwindsBuilder(SolarwindsFluent<?> fluent, Solarwinds instance) {
        this(fluent, instance, true);
    }

    public SolarwindsBuilder(SolarwindsFluent<?> fluent, Solarwinds instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAppopticsAccessToken(instance.getAppopticsAccessToken());
        fluent.withAppopticsBatchSize(instance.getAppopticsBatchSize());
        fluent.withLogs(instance.getLogs());
        fluent.withMetrics(instance.getMetrics());
        fluent.withPapertrailLocalRetentionDuration(instance.getPapertrailLocalRetentionDuration());
        fluent.withPapertrailUrl(instance.getPapertrailUrl());
        this.validationEnabled = validationEnabled;
    }

    public SolarwindsBuilder(Solarwinds instance) {
        this(instance, (Boolean)true);
    }

    public SolarwindsBuilder(Solarwinds instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAppopticsAccessToken(instance.getAppopticsAccessToken());
        this.withAppopticsBatchSize(instance.getAppopticsBatchSize());
        this.withLogs(instance.getLogs());
        this.withMetrics(instance.getMetrics());
        this.withPapertrailLocalRetentionDuration(instance.getPapertrailLocalRetentionDuration());
        this.withPapertrailUrl(instance.getPapertrailUrl());
        this.validationEnabled = validationEnabled;
    }

    public Solarwinds build() {
        Solarwinds buildable = new Solarwinds(this.fluent.getAppopticsAccessToken(), this.fluent.getAppopticsBatchSize(), this.fluent.getLogs(), this.fluent.getMetrics(), this.fluent.getPapertrailLocalRetentionDuration(), this.fluent.getPapertrailUrl());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SolarwindsBuilder that = (SolarwindsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

