/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.adapter.prometheus;

import io.fabric8.kubernetes.api.builder.v5_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_1.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.mixer.adapter.prometheus.Explicit;
import me.snowdrop.istio.mixer.adapter.prometheus.ExplicitFluent;

public class ExplicitFluentImpl<A extends ExplicitFluent<A>>
extends BaseFluent<A>
implements ExplicitFluent<A> {
    private List<Double> bounds;

    public ExplicitFluentImpl() {
    }

    public ExplicitFluentImpl(Explicit instance) {
        this.withBounds(instance.getBounds());
    }

    @Override
    public A addToBounds(int index, Double item) {
        if (this.bounds == null) {
            this.bounds = new ArrayList<Double>();
        }
        this.bounds.add(index, item);
        return (A)this;
    }

    @Override
    public A setToBounds(int index, Double item) {
        if (this.bounds == null) {
            this.bounds = new ArrayList<Double>();
        }
        this.bounds.set(index, item);
        return (A)this;
    }

    @Override
    public A addToBounds(Double ... items) {
        if (this.bounds == null) {
            this.bounds = new ArrayList<Double>();
        }
        for (Double item : items) {
            this.bounds.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToBounds(Collection<Double> items) {
        if (this.bounds == null) {
            this.bounds = new ArrayList<Double>();
        }
        for (Double item : items) {
            this.bounds.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromBounds(Double ... items) {
        for (Double item : items) {
            if (this.bounds == null) continue;
            this.bounds.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromBounds(Collection<Double> items) {
        for (Double item : items) {
            if (this.bounds == null) continue;
            this.bounds.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Double> getBounds() {
        return this.bounds;
    }

    @Override
    public Double getBound(int index) {
        return this.bounds.get(index);
    }

    @Override
    public Double getFirstBound() {
        return this.bounds.get(0);
    }

    @Override
    public Double getLastBound() {
        return this.bounds.get(this.bounds.size() - 1);
    }

    @Override
    public Double getMatchingBound(Predicate<Double> predicate) {
        for (Double item : this.bounds) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingBound(Predicate<Double> predicate) {
        for (Double item : this.bounds) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withBounds(List<Double> bounds) {
        if (this.bounds != null) {
            this._visitables.get((Object)"bounds").removeAll(this.bounds);
        }
        if (bounds != null) {
            this.bounds = new ArrayList<Double>();
            for (Double item : bounds) {
                this.addToBounds(item);
            }
        } else {
            this.bounds = null;
        }
        return (A)this;
    }

    @Override
    public A withBounds(Double ... bounds) {
        if (this.bounds != null) {
            this.bounds.clear();
        }
        if (bounds != null) {
            for (Double item : bounds) {
                this.addToBounds(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasBounds() {
        return this.bounds != null && !this.bounds.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExplicitFluentImpl that = (ExplicitFluentImpl)o;
        return !(this.bounds != null ? !this.bounds.equals(that.bounds) : that.bounds != null);
    }
}

