/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.adapter.cloudwatch;

import io.fabric8.kubernetes.api.builder.v5_1.VisitableBuilder;
import me.snowdrop.istio.mixer.adapter.cloudwatch.Cloudwatch;
import me.snowdrop.istio.mixer.adapter.cloudwatch.CloudwatchFluent;
import me.snowdrop.istio.mixer.adapter.cloudwatch.CloudwatchFluentImpl;

public class CloudwatchBuilder
extends CloudwatchFluentImpl<CloudwatchBuilder>
implements VisitableBuilder<Cloudwatch, CloudwatchBuilder> {
    CloudwatchFluent<?> fluent;
    Boolean validationEnabled;

    public CloudwatchBuilder() {
        this(true);
    }

    public CloudwatchBuilder(Boolean validationEnabled) {
        this(new Cloudwatch(), validationEnabled);
    }

    public CloudwatchBuilder(CloudwatchFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CloudwatchBuilder(CloudwatchFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Cloudwatch(), validationEnabled);
    }

    public CloudwatchBuilder(CloudwatchFluent<?> fluent, Cloudwatch instance) {
        this(fluent, instance, true);
    }

    public CloudwatchBuilder(CloudwatchFluent<?> fluent, Cloudwatch instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLogGroupName(instance.getLogGroupName());
        fluent.withLogStreamName(instance.getLogStreamName());
        fluent.withLogs(instance.getLogs());
        fluent.withMetricInfo(instance.getMetricInfo());
        fluent.withNamespace(instance.getNamespace());
        this.validationEnabled = validationEnabled;
    }

    public CloudwatchBuilder(Cloudwatch instance) {
        this(instance, (Boolean)true);
    }

    public CloudwatchBuilder(Cloudwatch instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLogGroupName(instance.getLogGroupName());
        this.withLogStreamName(instance.getLogStreamName());
        this.withLogs(instance.getLogs());
        this.withMetricInfo(instance.getMetricInfo());
        this.withNamespace(instance.getNamespace());
        this.validationEnabled = validationEnabled;
    }

    public Cloudwatch build() {
        Cloudwatch buildable = new Cloudwatch(this.fluent.getLogGroupName(), this.fluent.getLogStreamName(), this.fluent.getLogs(), this.fluent.getMetricInfo(), this.fluent.getNamespace());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CloudwatchBuilder that = (CloudwatchBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

