/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.client.internal.handler.networking.v1alpha3;

import io.fabric8.kubernetes.api.model.v5_1.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_1.ListOptions;
import io.fabric8.kubernetes.clnt.v5_1.Config;
import io.fabric8.kubernetes.clnt.v5_1.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_1.Watch;
import io.fabric8.kubernetes.clnt.v5_1.Watcher;
import io.fabric8.kubernetes.clnt.v5_1.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_1.dsl.Resource;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import me.snowdrop.istio.api.networking.v1alpha3.ServiceEntry;
import me.snowdrop.istio.api.networking.v1alpha3.ServiceEntryBuilder;
import me.snowdrop.istio.client.internal.operation.networking.v1alpha3.ServiceEntryOperationImpl;
import okhttp3.OkHttpClient;

public class ServiceEntryHandler
implements ResourceHandler<ServiceEntry, ServiceEntryBuilder> {
    public String getKind() {
        return ServiceEntry.class.getSimpleName();
    }

    public String getApiVersion() {
        return "networking.istio.io/v1alpha3";
    }

    public ServiceEntry create(OkHttpClient client, Config config, String namespace, ServiceEntry item) {
        return (ServiceEntry)new ServiceEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).create((Object[])new ServiceEntry[0]);
    }

    public ServiceEntry replace(OkHttpClient client, Config config, String namespace, ServiceEntry item) {
        return (ServiceEntry)((Resource)new ServiceEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public ServiceEntry reload(OkHttpClient client, Config config, String namespace, ServiceEntry item) {
        return (ServiceEntry)((Gettable)((Resource)new ServiceEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public ServiceEntryBuilder edit(ServiceEntry item) {
        return new ServiceEntryBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ServiceEntry item) {
        return new ServiceEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).delete((Object[])new ServiceEntry[]{item});
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ServiceEntry item, Watcher<ServiceEntry> watcher) {
        return ((Resource)new ServiceEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ServiceEntry item, String resourceVersion, Watcher<ServiceEntry> watcher) {
        return ((Resource)new ServiceEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ServiceEntry item, ListOptions listOptions, Watcher<ServiceEntry> watcher) {
        return ((Resource)new ServiceEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(listOptions, watcher);
    }

    public ServiceEntry waitUntilReady(OkHttpClient client, Config config, String namespace, ServiceEntry item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ServiceEntry)((Resource)new ServiceEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public ServiceEntry waitUntilCondition(OkHttpClient client, Config config, String namespace, ServiceEntry item, Predicate<ServiceEntry> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ServiceEntry)((Resource)new ServiceEntryOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

