/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.v5_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_1.Nested;
import io.fabric8.kubernetes.api.builder.v5_1.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.snowdrop.istio.api.networking.v1alpha3.GatewaySpec;
import me.snowdrop.istio.api.networking.v1alpha3.GatewaySpecFluent;
import me.snowdrop.istio.api.networking.v1alpha3.Server;
import me.snowdrop.istio.api.networking.v1alpha3.ServerBuilder;
import me.snowdrop.istio.api.networking.v1alpha3.ServerFluentImpl;

public class GatewaySpecFluentImpl<A extends GatewaySpecFluent<A>>
extends BaseFluent<A>
implements GatewaySpecFluent<A> {
    private Map<String, String> selector;
    private List<ServerBuilder> servers;

    public GatewaySpecFluentImpl() {
    }

    public GatewaySpecFluentImpl(GatewaySpec instance) {
        this.withSelector(instance.getSelector());
        this.withServers(instance.getServers());
    }

    @Override
    public A addToSelector(String key, String value) {
        if (this.selector == null && key != null && value != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToSelector(Map<String, String> map) {
        if (this.selector == null && map != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.selector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(String key) {
        if (this.selector == null) {
            return (A)this;
        }
        if (key != null && this.selector != null) {
            this.selector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(Map<String, String> map) {
        if (this.selector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.selector == null) continue;
                this.selector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getSelector() {
        return this.selector;
    }

    @Override
    public A withSelector(Map<String, String> selector) {
        this.selector = selector == null ? null : new LinkedHashMap<String, String>(selector);
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public A addToServers(int index, Server item) {
        if (this.servers == null) {
            this.servers = new ArrayList<ServerBuilder>();
        }
        ServerBuilder builder = new ServerBuilder(item);
        this._visitables.get((Object)"servers").add(index >= 0 ? index : this._visitables.get((Object)"servers").size(), builder);
        this.servers.add(index >= 0 ? index : this.servers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToServers(int index, Server item) {
        if (this.servers == null) {
            this.servers = new ArrayList<ServerBuilder>();
        }
        ServerBuilder builder = new ServerBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"servers").size()) {
            this._visitables.get((Object)"servers").add(builder);
        } else {
            this._visitables.get((Object)"servers").set(index, builder);
        }
        if (index < 0 || index >= this.servers.size()) {
            this.servers.add(builder);
        } else {
            this.servers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToServers(Server ... items) {
        if (this.servers == null) {
            this.servers = new ArrayList<ServerBuilder>();
        }
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get((Object)"servers").add(builder);
            this.servers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToServers(Collection<Server> items) {
        if (this.servers == null) {
            this.servers = new ArrayList<ServerBuilder>();
        }
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get((Object)"servers").add(builder);
            this.servers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromServers(Server ... items) {
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get((Object)"servers").remove(builder);
            if (this.servers == null) continue;
            this.servers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServers(Collection<Server> items) {
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get((Object)"servers").remove(builder);
            if (this.servers == null) continue;
            this.servers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromServers(Predicate<ServerBuilder> predicate) {
        if (this.servers == null) {
            return (A)this;
        }
        Iterator<ServerBuilder> each = this.servers.iterator();
        List visitables = this._visitables.get((Object)"servers");
        while (each.hasNext()) {
            ServerBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Server> getServers() {
        return GatewaySpecFluentImpl.build(this.servers);
    }

    @Override
    public List<Server> buildServers() {
        return GatewaySpecFluentImpl.build(this.servers);
    }

    @Override
    public Server buildServer(int index) {
        return this.servers.get(index).build();
    }

    @Override
    public Server buildFirstServer() {
        return this.servers.get(0).build();
    }

    @Override
    public Server buildLastServer() {
        return this.servers.get(this.servers.size() - 1).build();
    }

    @Override
    public Server buildMatchingServer(Predicate<ServerBuilder> predicate) {
        for (ServerBuilder item : this.servers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingServer(Predicate<ServerBuilder> predicate) {
        for (ServerBuilder item : this.servers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withServers(List<Server> servers) {
        if (this.servers != null) {
            this._visitables.get((Object)"servers").removeAll(this.servers);
        }
        if (servers != null) {
            this.servers = new ArrayList<ServerBuilder>();
            for (Server item : servers) {
                this.addToServers(item);
            }
        } else {
            this.servers = null;
        }
        return (A)this;
    }

    @Override
    public A withServers(Server ... servers) {
        if (this.servers != null) {
            this.servers.clear();
        }
        if (servers != null) {
            for (Server item : servers) {
                this.addToServers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServers() {
        return this.servers != null && !this.servers.isEmpty();
    }

    @Override
    public GatewaySpecFluent.ServersNested<A> addNewServer() {
        return new ServersNestedImpl();
    }

    @Override
    public GatewaySpecFluent.ServersNested<A> addNewServerLike(Server item) {
        return new ServersNestedImpl(-1, item);
    }

    @Override
    public GatewaySpecFluent.ServersNested<A> setNewServerLike(int index, Server item) {
        return new ServersNestedImpl(index, item);
    }

    @Override
    public GatewaySpecFluent.ServersNested<A> editServer(int index) {
        if (this.servers.size() <= index) {
            throw new RuntimeException("Can't edit servers. Index exceeds size.");
        }
        return this.setNewServerLike(index, this.buildServer(index));
    }

    @Override
    public GatewaySpecFluent.ServersNested<A> editFirstServer() {
        if (this.servers.size() == 0) {
            throw new RuntimeException("Can't edit first servers. The list is empty.");
        }
        return this.setNewServerLike(0, this.buildServer(0));
    }

    @Override
    public GatewaySpecFluent.ServersNested<A> editLastServer() {
        int index = this.servers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last servers. The list is empty.");
        }
        return this.setNewServerLike(index, this.buildServer(index));
    }

    @Override
    public GatewaySpecFluent.ServersNested<A> editMatchingServer(Predicate<ServerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.servers.size(); ++i) {
            if (!predicate.apply(this.servers.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching servers. No match found.");
        }
        return this.setNewServerLike(index, this.buildServer(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GatewaySpecFluentImpl that = (GatewaySpecFluentImpl)o;
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        return !(this.servers != null ? !this.servers.equals(that.servers) : that.servers != null);
    }

    public class ServersNestedImpl<N>
    extends ServerFluentImpl<GatewaySpecFluent.ServersNested<N>>
    implements GatewaySpecFluent.ServersNested<N>,
    Nested<N> {
        private final ServerBuilder builder;
        private final int index;

        ServersNestedImpl(int index, Server item) {
            this.index = index;
            this.builder = new ServerBuilder(this, item);
        }

        ServersNestedImpl() {
            this.index = -1;
            this.builder = new ServerBuilder(this);
        }

        @Override
        public N and() {
            return (N)GatewaySpecFluentImpl.this.setToServers(this.index, this.builder.build());
        }

        @Override
        public N endServer() {
            return this.and();
        }
    }
}

