/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.v4_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_10.Nested;
import io.fabric8.kubernetes.api.builder.v4_10.Predicate;
import io.fabric8.kubernetes.api.model.v4_10.ListMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import me.snowdrop.istio.api.policy.v1beta1.Instance;
import me.snowdrop.istio.api.policy.v1beta1.InstanceBuilder;
import me.snowdrop.istio.api.policy.v1beta1.InstanceFluentImpl;
import me.snowdrop.istio.api.policy.v1beta1.InstanceList;
import me.snowdrop.istio.api.policy.v1beta1.InstanceListFluent;

public class InstanceListFluentImpl<A extends InstanceListFluent<A>>
extends BaseFluent<A>
implements InstanceListFluent<A> {
    private String apiVersion;
    private List<InstanceBuilder> items;
    private String kind;
    private ListMeta metadata;

    public InstanceListFluentImpl() {
    }

    public InstanceListFluentImpl(InstanceList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToItems(int index, Instance item) {
        if (this.items == null) {
            this.items = new ArrayList<InstanceBuilder>();
        }
        InstanceBuilder builder = new InstanceBuilder(item);
        this._visitables.get((Object)"items").add(index >= 0 ? index : this._visitables.get((Object)"items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, Instance item) {
        if (this.items == null) {
            this.items = new ArrayList<InstanceBuilder>();
        }
        InstanceBuilder builder = new InstanceBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"items").size()) {
            this._visitables.get((Object)"items").add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(Instance ... items) {
        if (this.items == null) {
            this.items = new ArrayList<InstanceBuilder>();
        }
        for (Instance item : items) {
            InstanceBuilder builder = new InstanceBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<Instance> items) {
        if (this.items == null) {
            this.items = new ArrayList<InstanceBuilder>();
        }
        for (Instance item : items) {
            InstanceBuilder builder = new InstanceBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(Instance ... items) {
        for (Instance item : items) {
            InstanceBuilder builder = new InstanceBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<Instance> items) {
        for (Instance item : items) {
            InstanceBuilder builder = new InstanceBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<InstanceBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<InstanceBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            InstanceBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Instance> getItems() {
        return InstanceListFluentImpl.build(this.items);
    }

    @Override
    public List<Instance> buildItems() {
        return InstanceListFluentImpl.build(this.items);
    }

    @Override
    public Instance buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public Instance buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public Instance buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public Instance buildMatchingItem(Predicate<InstanceBuilder> predicate) {
        for (InstanceBuilder item : this.items) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<InstanceBuilder> predicate) {
        for (InstanceBuilder item : this.items) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<Instance> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<InstanceBuilder>();
            for (Instance item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(Instance ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (Instance item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public InstanceListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public InstanceListFluent.ItemsNested<A> addNewItemLike(Instance item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public InstanceListFluent.ItemsNested<A> setNewItemLike(int index, Instance item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public InstanceListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public InstanceListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public InstanceListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public InstanceListFluent.ItemsNested<A> editMatchingItem(Predicate<InstanceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply((Object)this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceListFluentImpl that = (InstanceListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null);
    }

    public class ItemsNestedImpl<N>
    extends InstanceFluentImpl<InstanceListFluent.ItemsNested<N>>
    implements InstanceListFluent.ItemsNested<N>,
    Nested<N> {
        private final InstanceBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, Instance item) {
            this.index = index;
            this.builder = new InstanceBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new InstanceBuilder(this);
        }

        @Override
        public N and() {
            return (N)InstanceListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

