/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.internal;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import me.snowdrop.istio.api.IstioSpec;

public class IstioSpecRegistry {
    private static final String ISTIO_PACKAGE_PREFIX = "me.snowdrop.istio.";
    private static final String ISTIO_API_PACKAGE_PREFIX = "me.snowdrop.istio.api.";
    private static final String ISTIO_MIXER_TEMPLATE_PACKAGE_PREFIX = "me.snowdrop.istio.mixer.template.";
    private static final String ISTIO_ADAPTER_PACKAGE_PREFIX = "me.snowdrop.istio.adapter.";
    private static final Map<String, CRDInfo> crdInfos = new HashMap<String, CRDInfo>();

    private static CRDInfo getCRDInfoFrom(Map.Entry<Object, Object> entry) {
        Object packageName;
        String[] versionAndClass = String.valueOf(entry.getKey()).split("\\.");
        String kind = versionAndClass[1];
        String className = kind.contains("entry") ? kind.replace("entry", "Entry") : (kind.contains("Msg") ? kind.replace("Msg", "") : (kind.contains("nothing") ? kind.replace("nothing", "Nothing") : (kind.contains("key") ? kind.replace("key", "Key") : (kind.contains("span") ? kind.replace("span", "Span") : kind))));
        char c = className.charAt(0);
        className = className.replaceFirst("" + c, "" + Character.toTitleCase(c));
        String[] crdDetail = String.valueOf(entry.getValue()).split("\\|");
        String name = crdDetail[0].trim();
        String istioLabel = crdDetail[1].trim().substring(crdDetail[1].lastIndexOf(61));
        String version = versionAndClass[0];
        switch (istioLabel) {
            case "mixer-adapter": {
                packageName = ISTIO_ADAPTER_PACKAGE_PREFIX + kind.toLowerCase() + ".";
                break;
            }
            case "mixer-instance": {
                packageName = ISTIO_MIXER_TEMPLATE_PACKAGE_PREFIX + kind.toLowerCase() + ".";
                break;
            }
            case "core": {
                packageName = "me.snowdrop.istio.api.policy.v1beta1.";
                break;
            }
            default: {
                String group = CRDInfo.getGroup(name);
                packageName = ISTIO_API_PACKAGE_PREFIX + group + "." + version + ".";
            }
        }
        return new CRDInfo(kind, version, name, (String)packageName + className);
    }

    public static String unvisitedCRDNames() {
        return crdInfos.values().stream().filter(CRDInfo::isUnvisited).map(CRDInfo::toString).collect(Collectors.joining("\n"));
    }

    public static Class<? extends IstioSpec> resolveIstioSpecForKind(String name) {
        CRDInfo crdInfo = crdInfos.get(name);
        if (crdInfo != null) {
            crdInfo.visited = true;
            Optional<Class<? extends IstioSpec>> result = crdInfo.clazz;
            if (!result.isPresent()) {
                Class<? extends IstioSpec> clazz = IstioSpecRegistry.loadClassIfExists(crdInfo.className);
                crdInfo.clazz = Optional.of(clazz);
                return clazz;
            }
            return result.get();
        }
        return null;
    }

    public static String getKindFor(Class<? extends IstioSpec> spec) {
        try {
            return spec.newInstance().getKind();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Optional<CRDInfo> getCRDInfo(String simpleClassName, String version) {
        String key = IstioSpecRegistry.getCRDKeyFrom(simpleClassName, version);
        CRDInfo crd = crdInfos.get(key);
        if (crd != null) {
            crd.visited = true;
            return Optional.of(crd);
        }
        return Optional.empty();
    }

    private static String getCRDKeyFrom(String simpleClassName, String version) {
        Object key = simpleClassName;
        if (simpleClassName.endsWith("Spec")) {
            key = simpleClassName.substring(0, simpleClassName.indexOf("Spec"));
        }
        if (((String)key).equals("Instance") || ((String)key).equals("Handler")) {
            version = "v1alpha2";
        }
        key = version + (String)key;
        return ((String)key).toLowerCase();
    }

    private static String getCRDKeyFrom(Map.Entry<Object, Object> propEntry) {
        String[] versionAndClass = String.valueOf(propEntry.getKey()).split("\\.");
        return IstioSpecRegistry.getCRDKeyFrom(versionAndClass[1], versionAndClass[0]);
    }

    public static Set<String> getKnownKinds() {
        return crdInfos.keySet();
    }

    private static Class<? extends IstioSpec> loadClassIfExists(String className) {
        try {
            Class<?> loaded = IstioSpecRegistry.class.getClassLoader().loadClass(className);
            if (IstioSpec.class.isAssignableFrom(loaded)) {
                return loaded.asSubclass(IstioSpec.class);
            }
            throw new IllegalArgumentException(String.format("%s is not an implementation of %s", className, IstioSpec.class.getSimpleName()));
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(String.format("Cannot load class: %s", className), t);
        }
    }

    public static void main(String[] args) {
        System.out.println(crdInfos.values().stream().collect(Collectors.groupingBy(CRDInfo::getGroup)).entrySet().stream().map(entry -> (String)entry.getKey() + ":\n\t" + ((List)entry.getValue()).stream().map(Object::toString).sorted(String::compareToIgnoreCase).collect(Collectors.joining("\n\t"))).collect(Collectors.joining("\n")));
    }

    static {
        Properties crdFile = new Properties();
        try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("istio-crd.properties");){
            crdFile.load(inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't load Istio CRD information from classpath", e);
        }
        crdInfos.putAll(crdFile.entrySet().stream().collect(Collectors.toMap(IstioSpecRegistry::getCRDKeyFrom, IstioSpecRegistry::getCRDInfoFrom)));
    }

    public static class CRDInfo {
        private final String kind;
        private final String version;
        private final String crdName;
        private final String className;
        private Optional<Class<? extends IstioSpec>> clazz = Optional.empty();
        private boolean visited;

        public CRDInfo(String kind, String version, String crdName, String className) {
            this.kind = kind;
            this.version = version;
            this.crdName = crdName;
            this.className = className;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CRDInfo crdInfo = (CRDInfo)o;
            return this.kind.equals(crdInfo.kind);
        }

        public int hashCode() {
            return this.kind.hashCode();
        }

        public String toString() {
            return this.kind + ":\t" + this.crdName + "\t=>\t" + this.className;
        }

        public String getGroup() {
            return CRDInfo.getGroup(this.crdName);
        }

        static String getGroup(String crdName) {
            int beginIndex = crdName.indexOf(46);
            return crdName.substring(beginIndex + 1, crdName.indexOf(46, beginIndex + 1));
        }

        public String getAPIVersion() {
            return this.crdName.substring(this.crdName.indexOf(".") + 1) + "/" + this.version;
        }

        public String getPlural() {
            return CRDInfo.getPlural(this.crdName);
        }

        public String getKind() {
            return this.kind;
        }

        static String getPlural(String crdName) {
            int endIndex = crdName.indexOf(46);
            return crdName.substring(0, endIndex);
        }

        boolean isUnvisited() {
            return !this.visited;
        }
    }
}

