/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api;

import io.fabric8.kubernetes.api.builder.v4_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_10.Predicate;
import io.fabric8.kubernetes.api.model.v4_10.ListMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.api.IstioResource;
import me.snowdrop.istio.api.IstioResourceList;
import me.snowdrop.istio.api.IstioResourceListFluent;

public class IstioResourceListFluentImpl<A extends IstioResourceListFluent<A>>
extends BaseFluent<A>
implements IstioResourceListFluent<A> {
    private String apiVersion;
    private List<IstioResource> items;
    private String kind;
    private ListMeta metadata;

    public IstioResourceListFluentImpl() {
    }

    public IstioResourceListFluentImpl(IstioResourceList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToItems(int index, IstioResource item) {
        if (this.items == null) {
            this.items = new ArrayList<IstioResource>();
        }
        this.items.add(index, item);
        return (A)this;
    }

    @Override
    public A setToItems(int index, IstioResource item) {
        if (this.items == null) {
            this.items = new ArrayList<IstioResource>();
        }
        this.items.set(index, item);
        return (A)this;
    }

    @Override
    public A addToItems(IstioResource ... items) {
        if (this.items == null) {
            this.items = new ArrayList<IstioResource>();
        }
        for (IstioResource item : items) {
            this.items.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<IstioResource> items) {
        if (this.items == null) {
            this.items = new ArrayList<IstioResource>();
        }
        for (IstioResource item : items) {
            this.items.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(IstioResource ... items) {
        for (IstioResource item : items) {
            if (this.items == null) continue;
            this.items.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<IstioResource> items) {
        for (IstioResource item : items) {
            if (this.items == null) continue;
            this.items.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<IstioResource> getItems() {
        return this.items;
    }

    @Override
    public IstioResource getItem(int index) {
        return this.items.get(index);
    }

    @Override
    public IstioResource getFirstItem() {
        return this.items.get(0);
    }

    @Override
    public IstioResource getLastItem() {
        return this.items.get(this.items.size() - 1);
    }

    @Override
    public IstioResource getMatchingItem(Predicate<IstioResource> predicate) {
        for (IstioResource item : this.items) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<IstioResource> predicate) {
        for (IstioResource item : this.items) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<IstioResource> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<IstioResource>();
            for (IstioResource item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(IstioResource ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (IstioResource item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IstioResourceListFluentImpl that = (IstioResourceListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null);
    }
}

