/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.v4_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_10.Nested;
import io.fabric8.kubernetes.api.builder.v4_10.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import me.snowdrop.istio.api.networking.v1beta1.Port;
import me.snowdrop.istio.api.networking.v1beta1.PortBuilder;
import me.snowdrop.istio.api.networking.v1beta1.PortFluentImpl;
import me.snowdrop.istio.api.networking.v1beta1.ServiceEntryLocation;
import me.snowdrop.istio.api.networking.v1beta1.ServiceEntryResolution;
import me.snowdrop.istio.api.networking.v1beta1.ServiceEntrySpec;
import me.snowdrop.istio.api.networking.v1beta1.ServiceEntrySpecFluent;
import me.snowdrop.istio.api.networking.v1beta1.WorkloadEntrySpec;
import me.snowdrop.istio.api.networking.v1beta1.WorkloadEntrySpecBuilder;
import me.snowdrop.istio.api.networking.v1beta1.WorkloadEntrySpecFluentImpl;
import me.snowdrop.istio.api.networking.v1beta1.WorkloadSelector;
import me.snowdrop.istio.api.networking.v1beta1.WorkloadSelectorBuilder;
import me.snowdrop.istio.api.networking.v1beta1.WorkloadSelectorFluentImpl;

public class ServiceEntrySpecFluentImpl<A extends ServiceEntrySpecFluent<A>>
extends BaseFluent<A>
implements ServiceEntrySpecFluent<A> {
    private List<String> addresses;
    private List<WorkloadEntrySpecBuilder> endpoints;
    private List<String> exportTo;
    private List<String> hosts;
    private ServiceEntryLocation location;
    private List<PortBuilder> ports;
    private ServiceEntryResolution resolution;
    private List<String> subjectAltNames;
    private WorkloadSelectorBuilder workloadSelector;

    public ServiceEntrySpecFluentImpl() {
    }

    public ServiceEntrySpecFluentImpl(ServiceEntrySpec instance) {
        this.withAddresses(instance.getAddresses());
        this.withEndpoints(instance.getEndpoints());
        this.withExportTo(instance.getExportTo());
        this.withHosts(instance.getHosts());
        this.withLocation(instance.getLocation());
        this.withPorts(instance.getPorts());
        this.withResolution(instance.getResolution());
        this.withSubjectAltNames(instance.getSubjectAltNames());
        this.withWorkloadSelector(instance.getWorkloadSelector());
    }

    @Override
    public A addToAddresses(int index, String item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        this.addresses.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAddresses(int index, String item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        this.addresses.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAddresses(String ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.addresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAddresses(Collection<String> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.addresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAddresses(String ... items) {
        for (String item : items) {
            if (this.addresses == null) continue;
            this.addresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAddresses(Collection<String> items) {
        for (String item : items) {
            if (this.addresses == null) continue;
            this.addresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAddresses() {
        return this.addresses;
    }

    @Override
    public String getAddress(int index) {
        return this.addresses.get(index);
    }

    @Override
    public String getFirstAddress() {
        return this.addresses.get(0);
    }

    @Override
    public String getLastAddress() {
        return this.addresses.get(this.addresses.size() - 1);
    }

    @Override
    public String getMatchingAddress(Predicate<String> predicate) {
        for (String item : this.addresses) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAddress(Predicate<String> predicate) {
        for (String item : this.addresses) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAddresses(List<String> addresses) {
        if (this.addresses != null) {
            this._visitables.get((Object)"addresses").removeAll(this.addresses);
        }
        if (addresses != null) {
            this.addresses = new ArrayList<String>();
            for (String item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)this;
    }

    @Override
    public A withAddresses(String ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
        }
        if (addresses != null) {
            for (String item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    @Override
    public A addNewAddress(String arg1) {
        return this.addToAddresses(new String(arg1));
    }

    @Override
    public A addNewAddress(StringBuilder arg1) {
        return this.addToAddresses(new String(arg1));
    }

    @Override
    public A addNewAddress(StringBuffer arg1) {
        return this.addToAddresses(new String(arg1));
    }

    @Override
    public A addToEndpoints(int index, WorkloadEntrySpec item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<WorkloadEntrySpecBuilder>();
        }
        WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);
        this._visitables.get((Object)"endpoints").add(index >= 0 ? index : this._visitables.get((Object)"endpoints").size(), builder);
        this.endpoints.add(index >= 0 ? index : this.endpoints.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEndpoints(int index, WorkloadEntrySpec item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<WorkloadEntrySpecBuilder>();
        }
        WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"endpoints").size()) {
            this._visitables.get((Object)"endpoints").add(builder);
        } else {
            this._visitables.get((Object)"endpoints").set(index, builder);
        }
        if (index < 0 || index >= this.endpoints.size()) {
            this.endpoints.add(builder);
        } else {
            this.endpoints.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEndpoints(WorkloadEntrySpec ... items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<WorkloadEntrySpecBuilder>();
        }
        for (WorkloadEntrySpec item : items) {
            WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);
            this._visitables.get((Object)"endpoints").add(builder);
            this.endpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEndpoints(Collection<WorkloadEntrySpec> items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<WorkloadEntrySpecBuilder>();
        }
        for (WorkloadEntrySpec item : items) {
            WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);
            this._visitables.get((Object)"endpoints").add(builder);
            this.endpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEndpoints(WorkloadEntrySpec ... items) {
        for (WorkloadEntrySpec item : items) {
            WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);
            this._visitables.get((Object)"endpoints").remove(builder);
            if (this.endpoints == null) continue;
            this.endpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEndpoints(Collection<WorkloadEntrySpec> items) {
        for (WorkloadEntrySpec item : items) {
            WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);
            this._visitables.get((Object)"endpoints").remove(builder);
            if (this.endpoints == null) continue;
            this.endpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEndpoints(Predicate<WorkloadEntrySpecBuilder> predicate) {
        if (this.endpoints == null) {
            return (A)this;
        }
        Iterator<WorkloadEntrySpecBuilder> each = this.endpoints.iterator();
        List visitables = this._visitables.get((Object)"endpoints");
        while (each.hasNext()) {
            WorkloadEntrySpecBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<WorkloadEntrySpec> getEndpoints() {
        return ServiceEntrySpecFluentImpl.build(this.endpoints);
    }

    @Override
    public List<WorkloadEntrySpec> buildEndpoints() {
        return ServiceEntrySpecFluentImpl.build(this.endpoints);
    }

    @Override
    public WorkloadEntrySpec buildEndpoint(int index) {
        return this.endpoints.get(index).build();
    }

    @Override
    public WorkloadEntrySpec buildFirstEndpoint() {
        return this.endpoints.get(0).build();
    }

    @Override
    public WorkloadEntrySpec buildLastEndpoint() {
        return this.endpoints.get(this.endpoints.size() - 1).build();
    }

    @Override
    public WorkloadEntrySpec buildMatchingEndpoint(Predicate<WorkloadEntrySpecBuilder> predicate) {
        for (WorkloadEntrySpecBuilder item : this.endpoints) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEndpoint(Predicate<WorkloadEntrySpecBuilder> predicate) {
        for (WorkloadEntrySpecBuilder item : this.endpoints) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEndpoints(List<WorkloadEntrySpec> endpoints) {
        if (this.endpoints != null) {
            this._visitables.get((Object)"endpoints").removeAll(this.endpoints);
        }
        if (endpoints != null) {
            this.endpoints = new ArrayList<WorkloadEntrySpecBuilder>();
            for (WorkloadEntrySpec item : endpoints) {
                this.addToEndpoints(item);
            }
        } else {
            this.endpoints = null;
        }
        return (A)this;
    }

    @Override
    public A withEndpoints(WorkloadEntrySpec ... endpoints) {
        if (this.endpoints != null) {
            this.endpoints.clear();
        }
        if (endpoints != null) {
            for (WorkloadEntrySpec item : endpoints) {
                this.addToEndpoints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEndpoints() {
        return this.endpoints != null && !this.endpoints.isEmpty();
    }

    @Override
    public ServiceEntrySpecFluent.EndpointsNested<A> addNewEndpoint() {
        return new EndpointsNestedImpl();
    }

    @Override
    public ServiceEntrySpecFluent.EndpointsNested<A> addNewEndpointLike(WorkloadEntrySpec item) {
        return new EndpointsNestedImpl(-1, item);
    }

    @Override
    public ServiceEntrySpecFluent.EndpointsNested<A> setNewEndpointLike(int index, WorkloadEntrySpec item) {
        return new EndpointsNestedImpl(index, item);
    }

    @Override
    public ServiceEntrySpecFluent.EndpointsNested<A> editEndpoint(int index) {
        if (this.endpoints.size() <= index) {
            throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    @Override
    public ServiceEntrySpecFluent.EndpointsNested<A> editFirstEndpoint() {
        if (this.endpoints.size() == 0) {
            throw new RuntimeException("Can't edit first endpoints. The list is empty.");
        }
        return this.setNewEndpointLike(0, this.buildEndpoint(0));
    }

    @Override
    public ServiceEntrySpecFluent.EndpointsNested<A> editLastEndpoint() {
        int index = this.endpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last endpoints. The list is empty.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    @Override
    public ServiceEntrySpecFluent.EndpointsNested<A> editMatchingEndpoint(Predicate<WorkloadEntrySpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.endpoints.size(); ++i) {
            if (!predicate.apply((Object)this.endpoints.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching endpoints. No match found.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    @Override
    public A addToExportTo(int index, String item) {
        if (this.exportTo == null) {
            this.exportTo = new ArrayList<String>();
        }
        this.exportTo.add(index, item);
        return (A)this;
    }

    @Override
    public A setToExportTo(int index, String item) {
        if (this.exportTo == null) {
            this.exportTo = new ArrayList<String>();
        }
        this.exportTo.set(index, item);
        return (A)this;
    }

    @Override
    public A addToExportTo(String ... items) {
        if (this.exportTo == null) {
            this.exportTo = new ArrayList<String>();
        }
        for (String item : items) {
            this.exportTo.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToExportTo(Collection<String> items) {
        if (this.exportTo == null) {
            this.exportTo = new ArrayList<String>();
        }
        for (String item : items) {
            this.exportTo.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromExportTo(String ... items) {
        for (String item : items) {
            if (this.exportTo == null) continue;
            this.exportTo.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExportTo(Collection<String> items) {
        for (String item : items) {
            if (this.exportTo == null) continue;
            this.exportTo.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getExportTo() {
        return this.exportTo;
    }

    @Override
    public String getExportTo(int index) {
        return this.exportTo.get(index);
    }

    @Override
    public String getFirstExportTo() {
        return this.exportTo.get(0);
    }

    @Override
    public String getLastExportTo() {
        return this.exportTo.get(this.exportTo.size() - 1);
    }

    @Override
    public String getMatchingExportTo(Predicate<String> predicate) {
        for (String item : this.exportTo) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingExportTo(Predicate<String> predicate) {
        for (String item : this.exportTo) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withExportTo(List<String> exportTo) {
        if (this.exportTo != null) {
            this._visitables.get((Object)"exportTo").removeAll(this.exportTo);
        }
        if (exportTo != null) {
            this.exportTo = new ArrayList<String>();
            for (String item : exportTo) {
                this.addToExportTo(item);
            }
        } else {
            this.exportTo = null;
        }
        return (A)this;
    }

    @Override
    public A withExportTo(String ... exportTo) {
        if (this.exportTo != null) {
            this.exportTo.clear();
        }
        if (exportTo != null) {
            for (String item : exportTo) {
                this.addToExportTo(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasExportTo() {
        return this.exportTo != null && !this.exportTo.isEmpty();
    }

    @Override
    public A addNewExportTo(String arg1) {
        return this.addToExportTo(new String(arg1));
    }

    @Override
    public A addNewExportTo(StringBuilder arg1) {
        return this.addToExportTo(new String(arg1));
    }

    @Override
    public A addNewExportTo(StringBuffer arg1) {
        return this.addToExportTo(new String(arg1));
    }

    @Override
    public A addToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.add(index, item);
        return (A)this;
    }

    @Override
    public A setToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.set(index, item);
        return (A)this;
    }

    @Override
    public A addToHosts(String ... items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToHosts(Collection<String> items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromHosts(String ... items) {
        for (String item : items) {
            if (this.hosts == null) continue;
            this.hosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHosts(Collection<String> items) {
        for (String item : items) {
            if (this.hosts == null) continue;
            this.hosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getHosts() {
        return this.hosts;
    }

    @Override
    public String getHost(int index) {
        return this.hosts.get(index);
    }

    @Override
    public String getFirstHost() {
        return this.hosts.get(0);
    }

    @Override
    public String getLastHost() {
        return this.hosts.get(this.hosts.size() - 1);
    }

    @Override
    public String getMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHosts(List<String> hosts) {
        if (this.hosts != null) {
            this._visitables.get((Object)"hosts").removeAll(this.hosts);
        }
        if (hosts != null) {
            this.hosts = new ArrayList<String>();
            for (String item : hosts) {
                this.addToHosts(item);
            }
        } else {
            this.hosts = null;
        }
        return (A)this;
    }

    @Override
    public A withHosts(String ... hosts) {
        if (this.hosts != null) {
            this.hosts.clear();
        }
        if (hosts != null) {
            for (String item : hosts) {
                this.addToHosts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHosts() {
        return this.hosts != null && !this.hosts.isEmpty();
    }

    @Override
    public A addNewHost(String arg1) {
        return this.addToHosts(new String(arg1));
    }

    @Override
    public A addNewHost(StringBuilder arg1) {
        return this.addToHosts(new String(arg1));
    }

    @Override
    public A addNewHost(StringBuffer arg1) {
        return this.addToHosts(new String(arg1));
    }

    @Override
    public ServiceEntryLocation getLocation() {
        return this.location;
    }

    @Override
    public A withLocation(ServiceEntryLocation location) {
        this.location = location;
        return (A)this;
    }

    @Override
    public Boolean hasLocation() {
        return this.location != null;
    }

    @Override
    public A addToPorts(int index, Port item) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortBuilder>();
        }
        PortBuilder builder = new PortBuilder(item);
        this._visitables.get((Object)"ports").add(index >= 0 ? index : this._visitables.get((Object)"ports").size(), builder);
        this.ports.add(index >= 0 ? index : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(int index, Port item) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortBuilder>();
        }
        PortBuilder builder = new PortBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"ports").size()) {
            this._visitables.get((Object)"ports").add(builder);
        } else {
            this._visitables.get((Object)"ports").set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(Port ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortBuilder>();
        }
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<Port> items) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortBuilder>();
        }
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(Port ... items) {
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.get((Object)"ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<Port> items) {
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.get((Object)"ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPorts(Predicate<PortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<PortBuilder> each = this.ports.iterator();
        List visitables = this._visitables.get((Object)"ports");
        while (each.hasNext()) {
            PortBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Port> getPorts() {
        return ServiceEntrySpecFluentImpl.build(this.ports);
    }

    @Override
    public List<Port> buildPorts() {
        return ServiceEntrySpecFluentImpl.build(this.ports);
    }

    @Override
    public Port buildPort(int index) {
        return this.ports.get(index).build();
    }

    @Override
    public Port buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public Port buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public Port buildMatchingPort(Predicate<PortBuilder> predicate) {
        for (PortBuilder item : this.ports) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPort(Predicate<PortBuilder> predicate) {
        for (PortBuilder item : this.ports) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPorts(List<Port> ports) {
        if (this.ports != null) {
            this._visitables.get((Object)"ports").removeAll(this.ports);
        }
        if (ports != null) {
            this.ports = new ArrayList<PortBuilder>();
            for (Port item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    @Override
    public A withPorts(Port ... ports) {
        if (this.ports != null) {
            this.ports.clear();
        }
        if (ports != null) {
            for (Port item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public A addNewPort(String name, Integer number, String protocol) {
        return this.addToPorts(new Port(name, number, protocol));
    }

    @Override
    public ServiceEntrySpecFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public ServiceEntrySpecFluent.PortsNested<A> addNewPortLike(Port item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public ServiceEntrySpecFluent.PortsNested<A> setNewPortLike(int index, Port item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public ServiceEntrySpecFluent.PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public ServiceEntrySpecFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public ServiceEntrySpecFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public ServiceEntrySpecFluent.PortsNested<A> editMatchingPort(Predicate<PortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.apply((Object)this.ports.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public ServiceEntryResolution getResolution() {
        return this.resolution;
    }

    @Override
    public A withResolution(ServiceEntryResolution resolution) {
        this.resolution = resolution;
        return (A)this;
    }

    @Override
    public Boolean hasResolution() {
        return this.resolution != null;
    }

    @Override
    public A addToSubjectAltNames(int index, String item) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        this.subjectAltNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSubjectAltNames(int index, String item) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        this.subjectAltNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSubjectAltNames(String ... items) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.subjectAltNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubjectAltNames(Collection<String> items) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.subjectAltNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubjectAltNames(String ... items) {
        for (String item : items) {
            if (this.subjectAltNames == null) continue;
            this.subjectAltNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubjectAltNames(Collection<String> items) {
        for (String item : items) {
            if (this.subjectAltNames == null) continue;
            this.subjectAltNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSubjectAltNames() {
        return this.subjectAltNames;
    }

    @Override
    public String getSubjectAltName(int index) {
        return this.subjectAltNames.get(index);
    }

    @Override
    public String getFirstSubjectAltName() {
        return this.subjectAltNames.get(0);
    }

    @Override
    public String getLastSubjectAltName() {
        return this.subjectAltNames.get(this.subjectAltNames.size() - 1);
    }

    @Override
    public String getMatchingSubjectAltName(Predicate<String> predicate) {
        for (String item : this.subjectAltNames) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSubjectAltName(Predicate<String> predicate) {
        for (String item : this.subjectAltNames) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSubjectAltNames(List<String> subjectAltNames) {
        if (this.subjectAltNames != null) {
            this._visitables.get((Object)"subjectAltNames").removeAll(this.subjectAltNames);
        }
        if (subjectAltNames != null) {
            this.subjectAltNames = new ArrayList<String>();
            for (String item : subjectAltNames) {
                this.addToSubjectAltNames(item);
            }
        } else {
            this.subjectAltNames = null;
        }
        return (A)this;
    }

    @Override
    public A withSubjectAltNames(String ... subjectAltNames) {
        if (this.subjectAltNames != null) {
            this.subjectAltNames.clear();
        }
        if (subjectAltNames != null) {
            for (String item : subjectAltNames) {
                this.addToSubjectAltNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubjectAltNames() {
        return this.subjectAltNames != null && !this.subjectAltNames.isEmpty();
    }

    @Override
    public A addNewSubjectAltName(String arg1) {
        return this.addToSubjectAltNames(new String(arg1));
    }

    @Override
    public A addNewSubjectAltName(StringBuilder arg1) {
        return this.addToSubjectAltNames(new String(arg1));
    }

    @Override
    public A addNewSubjectAltName(StringBuffer arg1) {
        return this.addToSubjectAltNames(new String(arg1));
    }

    @Override
    @Deprecated
    public WorkloadSelector getWorkloadSelector() {
        return this.workloadSelector != null ? this.workloadSelector.build() : null;
    }

    @Override
    public WorkloadSelector buildWorkloadSelector() {
        return this.workloadSelector != null ? this.workloadSelector.build() : null;
    }

    @Override
    public A withWorkloadSelector(WorkloadSelector workloadSelector) {
        this._visitables.get((Object)"workloadSelector").remove(this.workloadSelector);
        if (workloadSelector != null) {
            this.workloadSelector = new WorkloadSelectorBuilder(workloadSelector);
            this._visitables.get((Object)"workloadSelector").add(this.workloadSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasWorkloadSelector() {
        return this.workloadSelector != null;
    }

    @Override
    public ServiceEntrySpecFluent.WorkloadSelectorNested<A> withNewWorkloadSelector() {
        return new WorkloadSelectorNestedImpl();
    }

    @Override
    public ServiceEntrySpecFluent.WorkloadSelectorNested<A> withNewWorkloadSelectorLike(WorkloadSelector item) {
        return new WorkloadSelectorNestedImpl(item);
    }

    @Override
    public ServiceEntrySpecFluent.WorkloadSelectorNested<A> editWorkloadSelector() {
        return this.withNewWorkloadSelectorLike(this.getWorkloadSelector());
    }

    @Override
    public ServiceEntrySpecFluent.WorkloadSelectorNested<A> editOrNewWorkloadSelector() {
        return this.withNewWorkloadSelectorLike(this.getWorkloadSelector() != null ? this.getWorkloadSelector() : new WorkloadSelectorBuilder().build());
    }

    @Override
    public ServiceEntrySpecFluent.WorkloadSelectorNested<A> editOrNewWorkloadSelectorLike(WorkloadSelector item) {
        return this.withNewWorkloadSelectorLike(this.getWorkloadSelector() != null ? this.getWorkloadSelector() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceEntrySpecFluentImpl that = (ServiceEntrySpecFluentImpl)o;
        if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) {
            return false;
        }
        if (this.endpoints != null ? !this.endpoints.equals(that.endpoints) : that.endpoints != null) {
            return false;
        }
        if (this.exportTo != null ? !this.exportTo.equals(that.exportTo) : that.exportTo != null) {
            return false;
        }
        if (this.hosts != null ? !this.hosts.equals(that.hosts) : that.hosts != null) {
            return false;
        }
        if (this.location != null ? !this.location.equals((Object)that.location) : that.location != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.resolution != null ? !this.resolution.equals((Object)that.resolution) : that.resolution != null) {
            return false;
        }
        if (this.subjectAltNames != null ? !this.subjectAltNames.equals(that.subjectAltNames) : that.subjectAltNames != null) {
            return false;
        }
        return !(this.workloadSelector != null ? !this.workloadSelector.equals(that.workloadSelector) : that.workloadSelector != null);
    }

    public class WorkloadSelectorNestedImpl<N>
    extends WorkloadSelectorFluentImpl<ServiceEntrySpecFluent.WorkloadSelectorNested<N>>
    implements ServiceEntrySpecFluent.WorkloadSelectorNested<N>,
    Nested<N> {
        private final WorkloadSelectorBuilder builder;

        WorkloadSelectorNestedImpl(WorkloadSelector item) {
            this.builder = new WorkloadSelectorBuilder(this, item);
        }

        WorkloadSelectorNestedImpl() {
            this.builder = new WorkloadSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceEntrySpecFluentImpl.this.withWorkloadSelector(this.builder.build());
        }

        @Override
        public N endWorkloadSelector() {
            return this.and();
        }
    }

    public class PortsNestedImpl<N>
    extends PortFluentImpl<ServiceEntrySpecFluent.PortsNested<N>>
    implements ServiceEntrySpecFluent.PortsNested<N>,
    Nested<N> {
        private final PortBuilder builder;
        private final int index;

        PortsNestedImpl(int index, Port item) {
            this.index = index;
            this.builder = new PortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new PortBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceEntrySpecFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    public class EndpointsNestedImpl<N>
    extends WorkloadEntrySpecFluentImpl<ServiceEntrySpecFluent.EndpointsNested<N>>
    implements ServiceEntrySpecFluent.EndpointsNested<N>,
    Nested<N> {
        private final WorkloadEntrySpecBuilder builder;
        private final int index;

        EndpointsNestedImpl(int index, WorkloadEntrySpec item) {
            this.index = index;
            this.builder = new WorkloadEntrySpecBuilder(this, item);
        }

        EndpointsNestedImpl() {
            this.index = -1;
            this.builder = new WorkloadEntrySpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceEntrySpecFluentImpl.this.setToEndpoints(this.index, this.builder.build());
        }

        @Override
        public N endEndpoint() {
            return this.and();
        }
    }
}

