/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassWithInterfaceFieldsRegistry {
    private static final Map<String, Map<String, FieldInfo>> classNameToFieldInfos = new HashMap<String, Map<String, FieldInfo>>();
    private static final Set<String> supportedSimpleTypes = new HashSet<String>();

    static FieldInfo getFieldInfo(String targetClassName, String fieldName) {
        FieldInfo info = (FieldInfo)classNameToFieldInfos.getOrDefault(targetClassName, Collections.emptyMap()).get(fieldName);
        if (info == null) {
            throw new IllegalArgumentException("Unknown field '" + fieldName + "'");
        }
        return info;
    }

    static Set<String> getKnownClasses() {
        return Collections.unmodifiableSet(classNameToFieldInfos.keySet());
    }

    private static Optional<Field> getField(Class<?> objectClass, String fieldName) {
        try {
            return Optional.of(objectClass.getDeclaredField(fieldName));
        }
        catch (NoSuchFieldException e) {
            return Optional.empty();
        }
    }

    private static String getFieldClassFQN(Class targetClass, String type) {
        return type.contains(".") ? type : targetClass.getPackage().getName() + '.' + type;
    }

    static {
        Collections.addAll(supportedSimpleTypes, "integer", "string", "number", "boolean");
        YAMLMapper mapper = new YAMLMapper();
        InputStream dataIs = Thread.currentThread().getContextClassLoader().getResourceAsStream("classes-with-interface-fields.yml");
        try {
            Classes classes = (Classes)mapper.readValue(dataIs, Classes.class);
            classes.classes.forEach(ci -> {
                HashMap<String, FieldInfo> infos = new HashMap<String, FieldInfo>(((ClassInfo)ci).fields.size());
                for (Map.Entry entry : ((ClassInfo)ci).fields.entrySet()) {
                    FieldInfo info;
                    String type = (String)entry.getValue();
                    String fieldName = (String)entry.getKey();
                    if (supportedSimpleTypes.contains(type)) {
                        info = new FieldInfo(fieldName, type);
                    } else if (type.startsWith("is")) {
                        String interfaceName = type.substring(type.lastIndexOf(95) + 1);
                        String target = interfaceName.substring(0, 1).toLowerCase() + interfaceName.substring(1);
                        String impl = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                        info = new ObjectFieldInfo(target, impl + interfaceName);
                    } else {
                        info = type.startsWith("map") ? new MapFieldInfo(fieldName, type) : new ObjectFieldInfo(fieldName, type);
                    }
                    infos.put(fieldName, info);
                }
                classNameToFieldInfos.put(((ClassInfo)ci).className, infos);
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static class ObjectFieldInfo
    extends FieldInfo {
        private ObjectFieldInfo(String target, String type) {
            super(target, type);
        }

        @Override
        Object deserialize(JsonNode node, String fieldName, Class targetClass, DeserializationContext ctxt) throws IOException {
            String type = ClassWithInterfaceFieldsRegistry.getFieldClassFQN(targetClass, this.type());
            try {
                Class<?> fieldClass = Thread.currentThread().getContextClassLoader().loadClass(type);
                Optional field = ClassWithInterfaceFieldsRegistry.getField(targetClass, fieldName);
                ObjectCodec codec = ctxt.getParser().getCodec();
                if (field.isPresent()) {
                    return codec.treeToValue((TreeNode)this.getTargetNode(node, fieldName), fieldClass);
                }
                Class<?> childFieldClass = fieldClass.getDeclaredField(fieldName).getType();
                Object childObject = codec.treeToValue((TreeNode)this.getTargetNode(node, fieldName), childFieldClass);
                return fieldClass.getDeclaredConstructor(childFieldClass).newInstance(childObject);
            }
            catch (JsonProcessingException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Unsupported type '" + type + "' for field '" + fieldName + "' on '" + targetClass.getName() + "' class", e);
            }
        }

        protected JsonNode getTargetNode(JsonNode node, String fieldName) {
            return node.get(fieldName);
        }
    }

    static class MapFieldInfo
    extends FieldInfo {
        private static final Pattern MAP_PATTERN = Pattern.compile("\\s*map<([^,]*),([^)]*)>");
        private final String keyType;
        private final String valueType;

        private MapFieldInfo(String target, String type) {
            super(target, type);
            Matcher matcher = MAP_PATTERN.matcher(type);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Expected map field format 'map<T,U>', got: " + type);
            }
            this.keyType = matcher.group(1).trim();
            this.valueType = matcher.group(2).trim();
        }

        public String toString() {
            return String.format("map<%s,%s>", this.keyType, this.valueType);
        }

        public String keyType() {
            return this.keyType;
        }

        public String valueType() {
            return this.valueType;
        }

        @Override
        Object deserialize(JsonNode node, String fieldName, Class targetClass, DeserializationContext ctxt) throws IOException {
            String type = ClassWithInterfaceFieldsRegistry.getFieldClassFQN(targetClass, this.valueType);
            try {
                Class<?> fieldClass = Thread.currentThread().getContextClassLoader().loadClass(type);
                YAMLMapper codec = (YAMLMapper)ctxt.getParser().getCodec();
                MapType mapType = codec.getTypeFactory().constructMapType(Map.class, String.class, fieldClass);
                JsonParser traverse = node.get(fieldName).traverse((ObjectCodec)codec);
                return codec.readValue(traverse, (JavaType)mapType);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unsupported type '" + type + "' for field '" + fieldName + "' on '" + targetClass.getName() + "' class. Full type was " + this, e);
            }
        }
    }

    static class FieldInfo {
        private final String target;
        private final String type;

        private FieldInfo(String target, String type) {
            this.target = target;
            this.type = type;
        }

        public String target() {
            return this.target;
        }

        public String type() {
            return this.type;
        }

        Object deserialize(JsonNode node, String fieldName, Class targetClass, DeserializationContext ctxt) throws IOException {
            JsonNode value = node.get(fieldName);
            switch (this.type()) {
                case "integer": {
                    return value.intValue();
                }
                case "string": {
                    return value.textValue();
                }
                case "number": {
                    return value.doubleValue();
                }
                case "boolean": {
                    return value.booleanValue();
                }
            }
            throw new IllegalArgumentException("Unknown simple type '" + this.type + "'");
        }
    }

    private static class ClassInfo {
        @JsonProperty(value="class")
        private String className;
        @JsonProperty
        private Map<String, String> fields;

        private ClassInfo() {
        }
    }

    private static class Classes {
        @JsonProperty
        private List<ClassInfo> classes;

        private Classes() {
        }
    }
}

