/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.v4_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_10.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import me.snowdrop.istio.api.mesh.v1alpha1.CustomTag;
import me.snowdrop.istio.api.mesh.v1alpha1.Tracing;
import me.snowdrop.istio.api.mesh.v1alpha1.TracingFluent;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettings;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettingsBuilder;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettingsFluentImpl;

public class TracingFluentImpl<A extends TracingFluent<A>>
extends BaseFluent<A>
implements TracingFluent<A> {
    private Map<String, CustomTag> customTags;
    private Integer maxPathTagLength;
    private Double sampling;
    private ClientTLSSettingsBuilder tlsSettings;
    private Tracing.Tracer tracer;

    public TracingFluentImpl() {
    }

    public TracingFluentImpl(Tracing instance) {
        this.withCustomTags(instance.getCustomTags());
        this.withMaxPathTagLength(instance.getMaxPathTagLength());
        this.withSampling(instance.getSampling());
        this.withTlsSettings(instance.getTlsSettings());
        this.withTracer(instance.getTracer());
    }

    @Override
    public A addToCustomTags(String key, CustomTag value) {
        if (this.customTags == null && key != null && value != null) {
            this.customTags = new LinkedHashMap<String, CustomTag>();
        }
        if (key != null && value != null) {
            this.customTags.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToCustomTags(Map<String, CustomTag> map) {
        if (this.customTags == null && map != null) {
            this.customTags = new LinkedHashMap<String, CustomTag>();
        }
        if (map != null) {
            this.customTags.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromCustomTags(String key) {
        if (this.customTags == null) {
            return (A)this;
        }
        if (key != null && this.customTags != null) {
            this.customTags.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromCustomTags(Map<String, CustomTag> map) {
        if (this.customTags == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.customTags == null) continue;
                this.customTags.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, CustomTag> getCustomTags() {
        return this.customTags;
    }

    @Override
    public A withCustomTags(Map<String, CustomTag> customTags) {
        this.customTags = customTags == null ? null : new LinkedHashMap<String, CustomTag>(customTags);
        return (A)this;
    }

    @Override
    public Boolean hasCustomTags() {
        return this.customTags != null;
    }

    @Override
    public Integer getMaxPathTagLength() {
        return this.maxPathTagLength;
    }

    @Override
    public A withMaxPathTagLength(Integer maxPathTagLength) {
        this.maxPathTagLength = maxPathTagLength;
        return (A)this;
    }

    @Override
    public Boolean hasMaxPathTagLength() {
        return this.maxPathTagLength != null;
    }

    @Override
    public Double getSampling() {
        return this.sampling;
    }

    @Override
    public A withSampling(Double sampling) {
        this.sampling = sampling;
        return (A)this;
    }

    @Override
    public Boolean hasSampling() {
        return this.sampling != null;
    }

    @Override
    @Deprecated
    public ClientTLSSettings getTlsSettings() {
        return this.tlsSettings != null ? this.tlsSettings.build() : null;
    }

    @Override
    public ClientTLSSettings buildTlsSettings() {
        return this.tlsSettings != null ? this.tlsSettings.build() : null;
    }

    @Override
    public A withTlsSettings(ClientTLSSettings tlsSettings) {
        this._visitables.get((Object)"tlsSettings").remove(this.tlsSettings);
        if (tlsSettings != null) {
            this.tlsSettings = new ClientTLSSettingsBuilder(tlsSettings);
            this._visitables.get((Object)"tlsSettings").add(this.tlsSettings);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsSettings() {
        return this.tlsSettings != null;
    }

    @Override
    public TracingFluent.TlsSettingsNested<A> withNewTlsSettings() {
        return new TlsSettingsNestedImpl();
    }

    @Override
    public TracingFluent.TlsSettingsNested<A> withNewTlsSettingsLike(ClientTLSSettings item) {
        return new TlsSettingsNestedImpl(item);
    }

    @Override
    public TracingFluent.TlsSettingsNested<A> editTlsSettings() {
        return this.withNewTlsSettingsLike(this.getTlsSettings());
    }

    @Override
    public TracingFluent.TlsSettingsNested<A> editOrNewTlsSettings() {
        return this.withNewTlsSettingsLike(this.getTlsSettings() != null ? this.getTlsSettings() : new ClientTLSSettingsBuilder().build());
    }

    @Override
    public TracingFluent.TlsSettingsNested<A> editOrNewTlsSettingsLike(ClientTLSSettings item) {
        return this.withNewTlsSettingsLike(this.getTlsSettings() != null ? this.getTlsSettings() : item);
    }

    @Override
    public Tracing.Tracer getTracer() {
        return this.tracer;
    }

    @Override
    public A withTracer(Tracing.Tracer tracer) {
        this.tracer = tracer;
        return (A)this;
    }

    @Override
    public Boolean hasTracer() {
        return this.tracer != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TracingFluentImpl that = (TracingFluentImpl)o;
        if (this.customTags != null ? !this.customTags.equals(that.customTags) : that.customTags != null) {
            return false;
        }
        if (this.maxPathTagLength != null ? !this.maxPathTagLength.equals(that.maxPathTagLength) : that.maxPathTagLength != null) {
            return false;
        }
        if (this.sampling != null ? !this.sampling.equals(that.sampling) : that.sampling != null) {
            return false;
        }
        if (this.tlsSettings != null ? !this.tlsSettings.equals(that.tlsSettings) : that.tlsSettings != null) {
            return false;
        }
        return !(this.tracer != null ? !this.tracer.equals(that.tracer) : that.tracer != null);
    }

    public class TlsSettingsNestedImpl<N>
    extends ClientTLSSettingsFluentImpl<TracingFluent.TlsSettingsNested<N>>
    implements TracingFluent.TlsSettingsNested<N>,
    Nested<N> {
        private final ClientTLSSettingsBuilder builder;

        TlsSettingsNestedImpl(ClientTLSSettings item) {
            this.builder = new ClientTLSSettingsBuilder(this, item);
        }

        TlsSettingsNestedImpl() {
            this.builder = new ClientTLSSettingsBuilder(this);
        }

        @Override
        public N and() {
            return (N)TracingFluentImpl.this.withTlsSettings(this.builder.build());
        }

        @Override
        public N endTlsSettings() {
            return this.and();
        }
    }
}

