/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.client;

import io.fabric8.kubernetes.api.model.v4_9.RootPaths;
import io.fabric8.kubernetes.clnt.v4_9.Client;
import io.fabric8.kubernetes.clnt.v4_9.ExtensionAdapter;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import me.snowdrop.istio.client.DefaultIstioClient;
import me.snowdrop.istio.client.IstioClient;
import okhttp3.OkHttpClient;

public class IstioExtensionAdapter
implements ExtensionAdapter<IstioClient> {
    private static final ConcurrentMap<URL, Boolean> IS_ISTIO = new ConcurrentHashMap<URL, Boolean>();
    private static final ConcurrentMap<URL, Boolean> USES_ISTIO_APIGROUPS = new ConcurrentHashMap<URL, Boolean>();

    public Class<IstioClient> getExtensionType() {
        return IstioClient.class;
    }

    public Boolean isAdaptable(Client client) {
        return this.isIstioAvailable(client);
    }

    public IstioClient adapt(Client client) {
        return new DefaultIstioClient((OkHttpClient)client.adapt(OkHttpClient.class), client.getConfiguration());
    }

    private boolean isIstioAvailable(Client client) {
        List paths;
        URL masterUrl = client.getMasterUrl();
        if (IS_ISTIO.containsKey(masterUrl)) {
            return (Boolean)IS_ISTIO.get(masterUrl);
        }
        RootPaths rootPaths = client.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!path.endsWith("istio.io") && !path.contains("istio.io/")) continue;
                USES_ISTIO_APIGROUPS.putIfAbsent(masterUrl, true);
                IS_ISTIO.putIfAbsent(masterUrl, true);
                return true;
            }
        }
        IS_ISTIO.putIfAbsent(masterUrl, false);
        return false;
    }
}

