/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.rbac.v1alpha1;

import io.fabric8.kubernetes.api.builder.v4_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_9.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.api.rbac.v1alpha1.Target;
import me.snowdrop.istio.api.rbac.v1alpha1.TargetFluent;

public class TargetFluentImpl<A extends TargetFluent<A>>
extends BaseFluent<A>
implements TargetFluent<A> {
    private List<String> namespaces;
    private List<String> services;

    public TargetFluentImpl() {
    }

    public TargetFluentImpl(Target instance) {
        this.withNamespaces(instance.getNamespaces());
        this.withServices(instance.getServices());
    }

    @Override
    public A addToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNamespaces(String ... items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNamespaces(Collection<String> items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNamespaces(String ... items) {
        for (String item : items) {
            if (this.namespaces == null) continue;
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNamespaces(Collection<String> items) {
        for (String item : items) {
            if (this.namespaces == null) continue;
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public String getNamespace(int index) {
        return this.namespaces.get(index);
    }

    @Override
    public String getFirstNamespace() {
        return this.namespaces.get(0);
    }

    @Override
    public String getLastNamespace() {
        return this.namespaces.get(this.namespaces.size() - 1);
    }

    @Override
    public String getMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNamespaces(List<String> namespaces) {
        if (this.namespaces != null) {
            this._visitables.get((Object)"namespaces").removeAll(this.namespaces);
        }
        if (namespaces != null) {
            this.namespaces = new ArrayList<String>();
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        } else {
            this.namespaces = null;
        }
        return (A)this;
    }

    @Override
    public A withNamespaces(String ... namespaces) {
        if (this.namespaces != null) {
            this.namespaces.clear();
        }
        if (namespaces != null) {
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaces() {
        return this.namespaces != null && !this.namespaces.isEmpty();
    }

    @Override
    public A addNewNamespace(String arg1) {
        return this.addToNamespaces(new String(arg1));
    }

    @Override
    public A addNewNamespace(StringBuilder arg1) {
        return this.addToNamespaces(new String(arg1));
    }

    @Override
    public A addNewNamespace(StringBuffer arg1) {
        return this.addToNamespaces(new String(arg1));
    }

    @Override
    public A addToServices(int index, String item) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        this.services.add(index, item);
        return (A)this;
    }

    @Override
    public A setToServices(int index, String item) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        this.services.set(index, item);
        return (A)this;
    }

    @Override
    public A addToServices(String ... items) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        for (String item : items) {
            this.services.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToServices(Collection<String> items) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        for (String item : items) {
            this.services.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromServices(String ... items) {
        for (String item : items) {
            if (this.services == null) continue;
            this.services.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServices(Collection<String> items) {
        for (String item : items) {
            if (this.services == null) continue;
            this.services.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getServices() {
        return this.services;
    }

    @Override
    public String getService(int index) {
        return this.services.get(index);
    }

    @Override
    public String getFirstService() {
        return this.services.get(0);
    }

    @Override
    public String getLastService() {
        return this.services.get(this.services.size() - 1);
    }

    @Override
    public String getMatchingService(Predicate<String> predicate) {
        for (String item : this.services) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingService(Predicate<String> predicate) {
        for (String item : this.services) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withServices(List<String> services) {
        if (this.services != null) {
            this._visitables.get((Object)"services").removeAll(this.services);
        }
        if (services != null) {
            this.services = new ArrayList<String>();
            for (String item : services) {
                this.addToServices(item);
            }
        } else {
            this.services = null;
        }
        return (A)this;
    }

    @Override
    public A withServices(String ... services) {
        if (this.services != null) {
            this.services.clear();
        }
        if (services != null) {
            for (String item : services) {
                this.addToServices(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServices() {
        return this.services != null && !this.services.isEmpty();
    }

    @Override
    public A addNewService(String arg1) {
        return this.addToServices(new String(arg1));
    }

    @Override
    public A addNewService(StringBuilder arg1) {
        return this.addToServices(new String(arg1));
    }

    @Override
    public A addNewService(StringBuffer arg1) {
        return this.addToServices(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetFluentImpl that = (TargetFluentImpl)o;
        if (this.namespaces != null ? !this.namespaces.equals(that.namespaces) : that.namespaces != null) {
            return false;
        }
        return !(this.services != null ? !this.services.equals(that.services) : that.services != null);
    }
}

