/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.v4_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_9.Nested;
import me.snowdrop.istio.api.Duration;
import me.snowdrop.istio.api.DurationBuilder;
import me.snowdrop.istio.api.DurationFluentImpl;
import me.snowdrop.istio.api.networking.v1beta1.H2UpgradePolicy;
import me.snowdrop.istio.api.networking.v1beta1.HTTPSettings;
import me.snowdrop.istio.api.networking.v1beta1.HTTPSettingsFluent;

public class HTTPSettingsFluentImpl<A extends HTTPSettingsFluent<A>>
extends BaseFluent<A>
implements HTTPSettingsFluent<A> {
    private H2UpgradePolicy h2UpgradePolicy;
    private Integer http1MaxPendingRequests;
    private Integer http2MaxRequests;
    private DurationBuilder idleTimeout;
    private Integer maxRequestsPerConnection;
    private Integer maxRetries;

    public HTTPSettingsFluentImpl() {
    }

    public HTTPSettingsFluentImpl(HTTPSettings instance) {
        this.withH2UpgradePolicy(instance.getH2UpgradePolicy());
        this.withHttp1MaxPendingRequests(instance.getHttp1MaxPendingRequests());
        this.withHttp2MaxRequests(instance.getHttp2MaxRequests());
        this.withIdleTimeout(instance.getIdleTimeout());
        this.withMaxRequestsPerConnection(instance.getMaxRequestsPerConnection());
        this.withMaxRetries(instance.getMaxRetries());
    }

    @Override
    public H2UpgradePolicy getH2UpgradePolicy() {
        return this.h2UpgradePolicy;
    }

    @Override
    public A withH2UpgradePolicy(H2UpgradePolicy h2UpgradePolicy) {
        this.h2UpgradePolicy = h2UpgradePolicy;
        return (A)this;
    }

    @Override
    public Boolean hasH2UpgradePolicy() {
        return this.h2UpgradePolicy != null;
    }

    @Override
    public Integer getHttp1MaxPendingRequests() {
        return this.http1MaxPendingRequests;
    }

    @Override
    public A withHttp1MaxPendingRequests(Integer http1MaxPendingRequests) {
        this.http1MaxPendingRequests = http1MaxPendingRequests;
        return (A)this;
    }

    @Override
    public Boolean hasHttp1MaxPendingRequests() {
        return this.http1MaxPendingRequests != null;
    }

    @Override
    public Integer getHttp2MaxRequests() {
        return this.http2MaxRequests;
    }

    @Override
    public A withHttp2MaxRequests(Integer http2MaxRequests) {
        this.http2MaxRequests = http2MaxRequests;
        return (A)this;
    }

    @Override
    public Boolean hasHttp2MaxRequests() {
        return this.http2MaxRequests != null;
    }

    @Override
    @Deprecated
    public Duration getIdleTimeout() {
        return this.idleTimeout != null ? this.idleTimeout.build() : null;
    }

    @Override
    public Duration buildIdleTimeout() {
        return this.idleTimeout != null ? this.idleTimeout.build() : null;
    }

    @Override
    public A withIdleTimeout(Duration idleTimeout) {
        this._visitables.get((Object)"idleTimeout").remove(this.idleTimeout);
        if (idleTimeout != null) {
            this.idleTimeout = new DurationBuilder(idleTimeout);
            this._visitables.get((Object)"idleTimeout").add(this.idleTimeout);
        }
        return (A)this;
    }

    @Override
    public Boolean hasIdleTimeout() {
        return this.idleTimeout != null;
    }

    @Override
    public A withNewIdleTimeout(Integer nanos, Long seconds) {
        return this.withIdleTimeout(new Duration(nanos, seconds));
    }

    @Override
    public HTTPSettingsFluent.IdleTimeoutNested<A> withNewIdleTimeout() {
        return new IdleTimeoutNestedImpl();
    }

    @Override
    public HTTPSettingsFluent.IdleTimeoutNested<A> withNewIdleTimeoutLike(Duration item) {
        return new IdleTimeoutNestedImpl(item);
    }

    @Override
    public HTTPSettingsFluent.IdleTimeoutNested<A> editIdleTimeout() {
        return this.withNewIdleTimeoutLike(this.getIdleTimeout());
    }

    @Override
    public HTTPSettingsFluent.IdleTimeoutNested<A> editOrNewIdleTimeout() {
        return this.withNewIdleTimeoutLike(this.getIdleTimeout() != null ? this.getIdleTimeout() : new DurationBuilder().build());
    }

    @Override
    public HTTPSettingsFluent.IdleTimeoutNested<A> editOrNewIdleTimeoutLike(Duration item) {
        return this.withNewIdleTimeoutLike(this.getIdleTimeout() != null ? this.getIdleTimeout() : item);
    }

    @Override
    public Integer getMaxRequestsPerConnection() {
        return this.maxRequestsPerConnection;
    }

    @Override
    public A withMaxRequestsPerConnection(Integer maxRequestsPerConnection) {
        this.maxRequestsPerConnection = maxRequestsPerConnection;
        return (A)this;
    }

    @Override
    public Boolean hasMaxRequestsPerConnection() {
        return this.maxRequestsPerConnection != null;
    }

    @Override
    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public A withMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
        return (A)this;
    }

    @Override
    public Boolean hasMaxRetries() {
        return this.maxRetries != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPSettingsFluentImpl that = (HTTPSettingsFluentImpl)o;
        if (this.h2UpgradePolicy != null ? !this.h2UpgradePolicy.equals((Object)that.h2UpgradePolicy) : that.h2UpgradePolicy != null) {
            return false;
        }
        if (this.http1MaxPendingRequests != null ? !this.http1MaxPendingRequests.equals(that.http1MaxPendingRequests) : that.http1MaxPendingRequests != null) {
            return false;
        }
        if (this.http2MaxRequests != null ? !this.http2MaxRequests.equals(that.http2MaxRequests) : that.http2MaxRequests != null) {
            return false;
        }
        if (this.idleTimeout != null ? !this.idleTimeout.equals(that.idleTimeout) : that.idleTimeout != null) {
            return false;
        }
        if (this.maxRequestsPerConnection != null ? !this.maxRequestsPerConnection.equals(that.maxRequestsPerConnection) : that.maxRequestsPerConnection != null) {
            return false;
        }
        return !(this.maxRetries != null ? !this.maxRetries.equals(that.maxRetries) : that.maxRetries != null);
    }

    public class IdleTimeoutNestedImpl<N>
    extends DurationFluentImpl<HTTPSettingsFluent.IdleTimeoutNested<N>>
    implements HTTPSettingsFluent.IdleTimeoutNested<N>,
    Nested<N> {
        private final DurationBuilder builder;

        IdleTimeoutNestedImpl(Duration item) {
            this.builder = new DurationBuilder(this, item);
        }

        IdleTimeoutNestedImpl() {
            this.builder = new DurationBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPSettingsFluentImpl.this.withIdleTimeout(this.builder.build());
        }

        @Override
        public N endIdleTimeout() {
            return this.and();
        }
    }
}

