/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.rbac.v1alpha1;

import io.fabric8.kubernetes.api.builder.v4_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_10.Nested;
import io.fabric8.kubernetes.api.builder.v4_10.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import me.snowdrop.istio.api.rbac.v1alpha1.AccessRule;
import me.snowdrop.istio.api.rbac.v1alpha1.AccessRuleFluent;
import me.snowdrop.istio.api.rbac.v1alpha1.Constraint;
import me.snowdrop.istio.api.rbac.v1alpha1.ConstraintBuilder;
import me.snowdrop.istio.api.rbac.v1alpha1.ConstraintFluentImpl;

public class AccessRuleFluentImpl<A extends AccessRuleFluent<A>>
extends BaseFluent<A>
implements AccessRuleFluent<A> {
    private List<ConstraintBuilder> constraints;
    private List<String> hosts;
    private List<String> methods;
    private List<String> notHosts;
    private List<String> notMethods;
    private List<String> notPaths;
    private String notPorts;
    private List<String> paths;
    private String ports;
    private List<String> services;

    public AccessRuleFluentImpl() {
    }

    public AccessRuleFluentImpl(AccessRule instance) {
        this.withConstraints(instance.getConstraints());
        this.withHosts(instance.getHosts());
        this.withMethods(instance.getMethods());
        this.withNotHosts(instance.getNotHosts());
        this.withNotMethods(instance.getNotMethods());
        this.withNotPaths(instance.getNotPaths());
        this.withNotPorts(instance.getNotPorts());
        this.withPaths(instance.getPaths());
        this.withPorts(instance.getPorts());
        this.withServices(instance.getServices());
    }

    @Override
    public A addToConstraints(int index, Constraint item) {
        if (this.constraints == null) {
            this.constraints = new ArrayList<ConstraintBuilder>();
        }
        ConstraintBuilder builder = new ConstraintBuilder(item);
        this._visitables.get((Object)"constraints").add(index >= 0 ? index : this._visitables.get((Object)"constraints").size(), builder);
        this.constraints.add(index >= 0 ? index : this.constraints.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConstraints(int index, Constraint item) {
        if (this.constraints == null) {
            this.constraints = new ArrayList<ConstraintBuilder>();
        }
        ConstraintBuilder builder = new ConstraintBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"constraints").size()) {
            this._visitables.get((Object)"constraints").add(builder);
        } else {
            this._visitables.get((Object)"constraints").set(index, builder);
        }
        if (index < 0 || index >= this.constraints.size()) {
            this.constraints.add(builder);
        } else {
            this.constraints.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConstraints(Constraint ... items) {
        if (this.constraints == null) {
            this.constraints = new ArrayList<ConstraintBuilder>();
        }
        for (Constraint item : items) {
            ConstraintBuilder builder = new ConstraintBuilder(item);
            this._visitables.get((Object)"constraints").add(builder);
            this.constraints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConstraints(Collection<Constraint> items) {
        if (this.constraints == null) {
            this.constraints = new ArrayList<ConstraintBuilder>();
        }
        for (Constraint item : items) {
            ConstraintBuilder builder = new ConstraintBuilder(item);
            this._visitables.get((Object)"constraints").add(builder);
            this.constraints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConstraints(Constraint ... items) {
        for (Constraint item : items) {
            ConstraintBuilder builder = new ConstraintBuilder(item);
            this._visitables.get((Object)"constraints").remove(builder);
            if (this.constraints == null) continue;
            this.constraints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConstraints(Collection<Constraint> items) {
        for (Constraint item : items) {
            ConstraintBuilder builder = new ConstraintBuilder(item);
            this._visitables.get((Object)"constraints").remove(builder);
            if (this.constraints == null) continue;
            this.constraints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConstraints(Predicate<ConstraintBuilder> predicate) {
        if (this.constraints == null) {
            return (A)this;
        }
        Iterator<ConstraintBuilder> each = this.constraints.iterator();
        List visitables = this._visitables.get((Object)"constraints");
        while (each.hasNext()) {
            ConstraintBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Constraint> getConstraints() {
        return AccessRuleFluentImpl.build(this.constraints);
    }

    @Override
    public List<Constraint> buildConstraints() {
        return AccessRuleFluentImpl.build(this.constraints);
    }

    @Override
    public Constraint buildConstraint(int index) {
        return this.constraints.get(index).build();
    }

    @Override
    public Constraint buildFirstConstraint() {
        return this.constraints.get(0).build();
    }

    @Override
    public Constraint buildLastConstraint() {
        return this.constraints.get(this.constraints.size() - 1).build();
    }

    @Override
    public Constraint buildMatchingConstraint(Predicate<ConstraintBuilder> predicate) {
        for (ConstraintBuilder item : this.constraints) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingConstraint(Predicate<ConstraintBuilder> predicate) {
        for (ConstraintBuilder item : this.constraints) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConstraints(List<Constraint> constraints) {
        if (this.constraints != null) {
            this._visitables.get((Object)"constraints").removeAll(this.constraints);
        }
        if (constraints != null) {
            this.constraints = new ArrayList<ConstraintBuilder>();
            for (Constraint item : constraints) {
                this.addToConstraints(item);
            }
        } else {
            this.constraints = null;
        }
        return (A)this;
    }

    @Override
    public A withConstraints(Constraint ... constraints) {
        if (this.constraints != null) {
            this.constraints.clear();
        }
        if (constraints != null) {
            for (Constraint item : constraints) {
                this.addToConstraints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConstraints() {
        return this.constraints != null && !this.constraints.isEmpty();
    }

    @Override
    public AccessRuleFluent.ConstraintsNested<A> addNewConstraint() {
        return new ConstraintsNestedImpl();
    }

    @Override
    public AccessRuleFluent.ConstraintsNested<A> addNewConstraintLike(Constraint item) {
        return new ConstraintsNestedImpl(-1, item);
    }

    @Override
    public AccessRuleFluent.ConstraintsNested<A> setNewConstraintLike(int index, Constraint item) {
        return new ConstraintsNestedImpl(index, item);
    }

    @Override
    public AccessRuleFluent.ConstraintsNested<A> editConstraint(int index) {
        if (this.constraints.size() <= index) {
            throw new RuntimeException("Can't edit constraints. Index exceeds size.");
        }
        return this.setNewConstraintLike(index, this.buildConstraint(index));
    }

    @Override
    public AccessRuleFluent.ConstraintsNested<A> editFirstConstraint() {
        if (this.constraints.size() == 0) {
            throw new RuntimeException("Can't edit first constraints. The list is empty.");
        }
        return this.setNewConstraintLike(0, this.buildConstraint(0));
    }

    @Override
    public AccessRuleFluent.ConstraintsNested<A> editLastConstraint() {
        int index = this.constraints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last constraints. The list is empty.");
        }
        return this.setNewConstraintLike(index, this.buildConstraint(index));
    }

    @Override
    public AccessRuleFluent.ConstraintsNested<A> editMatchingConstraint(Predicate<ConstraintBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.constraints.size(); ++i) {
            if (!predicate.apply((Object)this.constraints.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching constraints. No match found.");
        }
        return this.setNewConstraintLike(index, this.buildConstraint(index));
    }

    @Override
    public A addToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.add(index, item);
        return (A)this;
    }

    @Override
    public A setToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.set(index, item);
        return (A)this;
    }

    @Override
    public A addToHosts(String ... items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToHosts(Collection<String> items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromHosts(String ... items) {
        for (String item : items) {
            if (this.hosts == null) continue;
            this.hosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHosts(Collection<String> items) {
        for (String item : items) {
            if (this.hosts == null) continue;
            this.hosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getHosts() {
        return this.hosts;
    }

    @Override
    public String getHost(int index) {
        return this.hosts.get(index);
    }

    @Override
    public String getFirstHost() {
        return this.hosts.get(0);
    }

    @Override
    public String getLastHost() {
        return this.hosts.get(this.hosts.size() - 1);
    }

    @Override
    public String getMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHosts(List<String> hosts) {
        if (this.hosts != null) {
            this._visitables.get((Object)"hosts").removeAll(this.hosts);
        }
        if (hosts != null) {
            this.hosts = new ArrayList<String>();
            for (String item : hosts) {
                this.addToHosts(item);
            }
        } else {
            this.hosts = null;
        }
        return (A)this;
    }

    @Override
    public A withHosts(String ... hosts) {
        if (this.hosts != null) {
            this.hosts.clear();
        }
        if (hosts != null) {
            for (String item : hosts) {
                this.addToHosts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHosts() {
        return this.hosts != null && !this.hosts.isEmpty();
    }

    @Override
    public A addNewHost(String arg1) {
        return this.addToHosts(new String(arg1));
    }

    @Override
    public A addNewHost(StringBuilder arg1) {
        return this.addToHosts(new String(arg1));
    }

    @Override
    public A addNewHost(StringBuffer arg1) {
        return this.addToHosts(new String(arg1));
    }

    @Override
    public A addToMethods(int index, String item) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
        }
        this.methods.add(index, item);
        return (A)this;
    }

    @Override
    public A setToMethods(int index, String item) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
        }
        this.methods.set(index, item);
        return (A)this;
    }

    @Override
    public A addToMethods(String ... items) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
        }
        for (String item : items) {
            this.methods.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToMethods(Collection<String> items) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
        }
        for (String item : items) {
            this.methods.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromMethods(String ... items) {
        for (String item : items) {
            if (this.methods == null) continue;
            this.methods.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMethods(Collection<String> items) {
        for (String item : items) {
            if (this.methods == null) continue;
            this.methods.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getMethods() {
        return this.methods;
    }

    @Override
    public String getMethod(int index) {
        return this.methods.get(index);
    }

    @Override
    public String getFirstMethod() {
        return this.methods.get(0);
    }

    @Override
    public String getLastMethod() {
        return this.methods.get(this.methods.size() - 1);
    }

    @Override
    public String getMatchingMethod(Predicate<String> predicate) {
        for (String item : this.methods) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMethod(Predicate<String> predicate) {
        for (String item : this.methods) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMethods(List<String> methods) {
        if (this.methods != null) {
            this._visitables.get((Object)"methods").removeAll(this.methods);
        }
        if (methods != null) {
            this.methods = new ArrayList<String>();
            for (String item : methods) {
                this.addToMethods(item);
            }
        } else {
            this.methods = null;
        }
        return (A)this;
    }

    @Override
    public A withMethods(String ... methods) {
        if (this.methods != null) {
            this.methods.clear();
        }
        if (methods != null) {
            for (String item : methods) {
                this.addToMethods(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMethods() {
        return this.methods != null && !this.methods.isEmpty();
    }

    @Override
    public A addNewMethod(String arg1) {
        return this.addToMethods(new String(arg1));
    }

    @Override
    public A addNewMethod(StringBuilder arg1) {
        return this.addToMethods(new String(arg1));
    }

    @Override
    public A addNewMethod(StringBuffer arg1) {
        return this.addToMethods(new String(arg1));
    }

    @Override
    public A addToNotHosts(int index, String item) {
        if (this.notHosts == null) {
            this.notHosts = new ArrayList<String>();
        }
        this.notHosts.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNotHosts(int index, String item) {
        if (this.notHosts == null) {
            this.notHosts = new ArrayList<String>();
        }
        this.notHosts.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNotHosts(String ... items) {
        if (this.notHosts == null) {
            this.notHosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.notHosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNotHosts(Collection<String> items) {
        if (this.notHosts == null) {
            this.notHosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.notHosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNotHosts(String ... items) {
        for (String item : items) {
            if (this.notHosts == null) continue;
            this.notHosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNotHosts(Collection<String> items) {
        for (String item : items) {
            if (this.notHosts == null) continue;
            this.notHosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNotHosts() {
        return this.notHosts;
    }

    @Override
    public String getNotHost(int index) {
        return this.notHosts.get(index);
    }

    @Override
    public String getFirstNotHost() {
        return this.notHosts.get(0);
    }

    @Override
    public String getLastNotHost() {
        return this.notHosts.get(this.notHosts.size() - 1);
    }

    @Override
    public String getMatchingNotHost(Predicate<String> predicate) {
        for (String item : this.notHosts) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNotHost(Predicate<String> predicate) {
        for (String item : this.notHosts) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNotHosts(List<String> notHosts) {
        if (this.notHosts != null) {
            this._visitables.get((Object)"notHosts").removeAll(this.notHosts);
        }
        if (notHosts != null) {
            this.notHosts = new ArrayList<String>();
            for (String item : notHosts) {
                this.addToNotHosts(item);
            }
        } else {
            this.notHosts = null;
        }
        return (A)this;
    }

    @Override
    public A withNotHosts(String ... notHosts) {
        if (this.notHosts != null) {
            this.notHosts.clear();
        }
        if (notHosts != null) {
            for (String item : notHosts) {
                this.addToNotHosts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNotHosts() {
        return this.notHosts != null && !this.notHosts.isEmpty();
    }

    @Override
    public A addNewNotHost(String arg1) {
        return this.addToNotHosts(new String(arg1));
    }

    @Override
    public A addNewNotHost(StringBuilder arg1) {
        return this.addToNotHosts(new String(arg1));
    }

    @Override
    public A addNewNotHost(StringBuffer arg1) {
        return this.addToNotHosts(new String(arg1));
    }

    @Override
    public A addToNotMethods(int index, String item) {
        if (this.notMethods == null) {
            this.notMethods = new ArrayList<String>();
        }
        this.notMethods.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNotMethods(int index, String item) {
        if (this.notMethods == null) {
            this.notMethods = new ArrayList<String>();
        }
        this.notMethods.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNotMethods(String ... items) {
        if (this.notMethods == null) {
            this.notMethods = new ArrayList<String>();
        }
        for (String item : items) {
            this.notMethods.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNotMethods(Collection<String> items) {
        if (this.notMethods == null) {
            this.notMethods = new ArrayList<String>();
        }
        for (String item : items) {
            this.notMethods.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNotMethods(String ... items) {
        for (String item : items) {
            if (this.notMethods == null) continue;
            this.notMethods.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNotMethods(Collection<String> items) {
        for (String item : items) {
            if (this.notMethods == null) continue;
            this.notMethods.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNotMethods() {
        return this.notMethods;
    }

    @Override
    public String getNotMethod(int index) {
        return this.notMethods.get(index);
    }

    @Override
    public String getFirstNotMethod() {
        return this.notMethods.get(0);
    }

    @Override
    public String getLastNotMethod() {
        return this.notMethods.get(this.notMethods.size() - 1);
    }

    @Override
    public String getMatchingNotMethod(Predicate<String> predicate) {
        for (String item : this.notMethods) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNotMethod(Predicate<String> predicate) {
        for (String item : this.notMethods) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNotMethods(List<String> notMethods) {
        if (this.notMethods != null) {
            this._visitables.get((Object)"notMethods").removeAll(this.notMethods);
        }
        if (notMethods != null) {
            this.notMethods = new ArrayList<String>();
            for (String item : notMethods) {
                this.addToNotMethods(item);
            }
        } else {
            this.notMethods = null;
        }
        return (A)this;
    }

    @Override
    public A withNotMethods(String ... notMethods) {
        if (this.notMethods != null) {
            this.notMethods.clear();
        }
        if (notMethods != null) {
            for (String item : notMethods) {
                this.addToNotMethods(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNotMethods() {
        return this.notMethods != null && !this.notMethods.isEmpty();
    }

    @Override
    public A addNewNotMethod(String arg1) {
        return this.addToNotMethods(new String(arg1));
    }

    @Override
    public A addNewNotMethod(StringBuilder arg1) {
        return this.addToNotMethods(new String(arg1));
    }

    @Override
    public A addNewNotMethod(StringBuffer arg1) {
        return this.addToNotMethods(new String(arg1));
    }

    @Override
    public A addToNotPaths(int index, String item) {
        if (this.notPaths == null) {
            this.notPaths = new ArrayList<String>();
        }
        this.notPaths.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNotPaths(int index, String item) {
        if (this.notPaths == null) {
            this.notPaths = new ArrayList<String>();
        }
        this.notPaths.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNotPaths(String ... items) {
        if (this.notPaths == null) {
            this.notPaths = new ArrayList<String>();
        }
        for (String item : items) {
            this.notPaths.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNotPaths(Collection<String> items) {
        if (this.notPaths == null) {
            this.notPaths = new ArrayList<String>();
        }
        for (String item : items) {
            this.notPaths.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNotPaths(String ... items) {
        for (String item : items) {
            if (this.notPaths == null) continue;
            this.notPaths.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNotPaths(Collection<String> items) {
        for (String item : items) {
            if (this.notPaths == null) continue;
            this.notPaths.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNotPaths() {
        return this.notPaths;
    }

    @Override
    public String getNotPath(int index) {
        return this.notPaths.get(index);
    }

    @Override
    public String getFirstNotPath() {
        return this.notPaths.get(0);
    }

    @Override
    public String getLastNotPath() {
        return this.notPaths.get(this.notPaths.size() - 1);
    }

    @Override
    public String getMatchingNotPath(Predicate<String> predicate) {
        for (String item : this.notPaths) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNotPath(Predicate<String> predicate) {
        for (String item : this.notPaths) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNotPaths(List<String> notPaths) {
        if (this.notPaths != null) {
            this._visitables.get((Object)"notPaths").removeAll(this.notPaths);
        }
        if (notPaths != null) {
            this.notPaths = new ArrayList<String>();
            for (String item : notPaths) {
                this.addToNotPaths(item);
            }
        } else {
            this.notPaths = null;
        }
        return (A)this;
    }

    @Override
    public A withNotPaths(String ... notPaths) {
        if (this.notPaths != null) {
            this.notPaths.clear();
        }
        if (notPaths != null) {
            for (String item : notPaths) {
                this.addToNotPaths(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNotPaths() {
        return this.notPaths != null && !this.notPaths.isEmpty();
    }

    @Override
    public A addNewNotPath(String arg1) {
        return this.addToNotPaths(new String(arg1));
    }

    @Override
    public A addNewNotPath(StringBuilder arg1) {
        return this.addToNotPaths(new String(arg1));
    }

    @Override
    public A addNewNotPath(StringBuffer arg1) {
        return this.addToNotPaths(new String(arg1));
    }

    @Override
    public String getNotPorts() {
        return this.notPorts;
    }

    @Override
    public A withNotPorts(String notPorts) {
        this.notPorts = notPorts;
        return (A)this;
    }

    @Override
    public Boolean hasNotPorts() {
        return this.notPorts != null;
    }

    @Override
    public A withNewNotPorts(String arg1) {
        return this.withNotPorts(new String(arg1));
    }

    @Override
    public A withNewNotPorts(StringBuilder arg1) {
        return this.withNotPorts(new String(arg1));
    }

    @Override
    public A withNewNotPorts(StringBuffer arg1) {
        return this.withNotPorts(new String(arg1));
    }

    @Override
    public A addToPaths(int index, String item) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPaths(int index, String item) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPaths(String ... items) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        for (String item : items) {
            this.paths.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPaths(Collection<String> items) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        for (String item : items) {
            this.paths.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPaths(String ... items) {
        for (String item : items) {
            if (this.paths == null) continue;
            this.paths.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPaths(Collection<String> items) {
        for (String item : items) {
            if (this.paths == null) continue;
            this.paths.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPaths() {
        return this.paths;
    }

    @Override
    public String getPath(int index) {
        return this.paths.get(index);
    }

    @Override
    public String getFirstPath() {
        return this.paths.get(0);
    }

    @Override
    public String getLastPath() {
        return this.paths.get(this.paths.size() - 1);
    }

    @Override
    public String getMatchingPath(Predicate<String> predicate) {
        for (String item : this.paths) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPath(Predicate<String> predicate) {
        for (String item : this.paths) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPaths(List<String> paths) {
        if (this.paths != null) {
            this._visitables.get((Object)"paths").removeAll(this.paths);
        }
        if (paths != null) {
            this.paths = new ArrayList<String>();
            for (String item : paths) {
                this.addToPaths(item);
            }
        } else {
            this.paths = null;
        }
        return (A)this;
    }

    @Override
    public A withPaths(String ... paths) {
        if (this.paths != null) {
            this.paths.clear();
        }
        if (paths != null) {
            for (String item : paths) {
                this.addToPaths(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPaths() {
        return this.paths != null && !this.paths.isEmpty();
    }

    @Override
    public A addNewPath(String arg1) {
        return this.addToPaths(new String(arg1));
    }

    @Override
    public A addNewPath(StringBuilder arg1) {
        return this.addToPaths(new String(arg1));
    }

    @Override
    public A addNewPath(StringBuffer arg1) {
        return this.addToPaths(new String(arg1));
    }

    @Override
    public String getPorts() {
        return this.ports;
    }

    @Override
    public A withPorts(String ports) {
        this.ports = ports;
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null;
    }

    @Override
    public A withNewPorts(String arg1) {
        return this.withPorts(new String(arg1));
    }

    @Override
    public A withNewPorts(StringBuilder arg1) {
        return this.withPorts(new String(arg1));
    }

    @Override
    public A withNewPorts(StringBuffer arg1) {
        return this.withPorts(new String(arg1));
    }

    @Override
    public A addToServices(int index, String item) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        this.services.add(index, item);
        return (A)this;
    }

    @Override
    public A setToServices(int index, String item) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        this.services.set(index, item);
        return (A)this;
    }

    @Override
    public A addToServices(String ... items) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        for (String item : items) {
            this.services.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToServices(Collection<String> items) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        for (String item : items) {
            this.services.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromServices(String ... items) {
        for (String item : items) {
            if (this.services == null) continue;
            this.services.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServices(Collection<String> items) {
        for (String item : items) {
            if (this.services == null) continue;
            this.services.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getServices() {
        return this.services;
    }

    @Override
    public String getService(int index) {
        return this.services.get(index);
    }

    @Override
    public String getFirstService() {
        return this.services.get(0);
    }

    @Override
    public String getLastService() {
        return this.services.get(this.services.size() - 1);
    }

    @Override
    public String getMatchingService(Predicate<String> predicate) {
        for (String item : this.services) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingService(Predicate<String> predicate) {
        for (String item : this.services) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withServices(List<String> services) {
        if (this.services != null) {
            this._visitables.get((Object)"services").removeAll(this.services);
        }
        if (services != null) {
            this.services = new ArrayList<String>();
            for (String item : services) {
                this.addToServices(item);
            }
        } else {
            this.services = null;
        }
        return (A)this;
    }

    @Override
    public A withServices(String ... services) {
        if (this.services != null) {
            this.services.clear();
        }
        if (services != null) {
            for (String item : services) {
                this.addToServices(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServices() {
        return this.services != null && !this.services.isEmpty();
    }

    @Override
    public A addNewService(String arg1) {
        return this.addToServices(new String(arg1));
    }

    @Override
    public A addNewService(StringBuilder arg1) {
        return this.addToServices(new String(arg1));
    }

    @Override
    public A addNewService(StringBuffer arg1) {
        return this.addToServices(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessRuleFluentImpl that = (AccessRuleFluentImpl)o;
        if (this.constraints != null ? !this.constraints.equals(that.constraints) : that.constraints != null) {
            return false;
        }
        if (this.hosts != null ? !this.hosts.equals(that.hosts) : that.hosts != null) {
            return false;
        }
        if (this.methods != null ? !this.methods.equals(that.methods) : that.methods != null) {
            return false;
        }
        if (this.notHosts != null ? !this.notHosts.equals(that.notHosts) : that.notHosts != null) {
            return false;
        }
        if (this.notMethods != null ? !this.notMethods.equals(that.notMethods) : that.notMethods != null) {
            return false;
        }
        if (this.notPaths != null ? !this.notPaths.equals(that.notPaths) : that.notPaths != null) {
            return false;
        }
        if (this.notPorts != null ? !this.notPorts.equals(that.notPorts) : that.notPorts != null) {
            return false;
        }
        if (this.paths != null ? !this.paths.equals(that.paths) : that.paths != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        return !(this.services != null ? !this.services.equals(that.services) : that.services != null);
    }

    public class ConstraintsNestedImpl<N>
    extends ConstraintFluentImpl<AccessRuleFluent.ConstraintsNested<N>>
    implements AccessRuleFluent.ConstraintsNested<N>,
    Nested<N> {
        private final ConstraintBuilder builder;
        private final int index;

        ConstraintsNestedImpl(int index, Constraint item) {
            this.index = index;
            this.builder = new ConstraintBuilder(this, item);
        }

        ConstraintsNestedImpl() {
            this.index = -1;
            this.builder = new ConstraintBuilder(this);
        }

        @Override
        public N and() {
            return (N)AccessRuleFluentImpl.this.setToConstraints(this.index, this.builder.build());
        }

        @Override
        public N endConstraint() {
            return this.and();
        }
    }
}

