/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.cexl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import me.snowdrop.istio.api.cexl.parser.CEXLLexer;
import me.snowdrop.istio.api.cexl.parser.CEXLParser;
import me.snowdrop.istio.api.cexl.parser.CEXLTypeResolver;
import me.snowdrop.istio.api.mixer.config.descriptor.ValueType;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

@JsonSerialize(using=TypedValueSerializer.class)
@JsonDeserialize(using=TypedValueDeserializer.class)
public class TypedValue {
    private final ValueType type;
    private String expression;

    public TypedValue(ValueType type, String expression) {
        this.type = type;
        this.expression = expression;
    }

    @JsonIgnore
    public ValueType getType() {
        return this.type;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public static TypedValue from(String value) {
        CEXLLexer lexer = new CEXLLexer((CharStream)CharStreams.fromString((String)value));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        CEXLParser parser = new CEXLParser((TokenStream)tokens);
        CEXLParser.ExpressionContext context = parser.expression();
        ParseTreeWalker walker = new ParseTreeWalker();
        CEXLTypeResolver resolver = new CEXLTypeResolver();
        walker.walk((ParseTreeListener)resolver, (ParseTree)context);
        return new TypedValue(resolver.getExpressionType(), value);
    }

    public static TypedValue unparsed(String value) {
        return new TypedValue(ValueType.STRING, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypedValue)) {
            return false;
        }
        TypedValue other = (TypedValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ValueType this$type = this.getType();
        ValueType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        return !(this$expression == null ? other$expression != null : !this$expression.equals(other$expression));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TypedValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ValueType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        return result;
    }

    public String toString() {
        return "TypedValue(type=" + (Object)((Object)this.getType()) + ", expression=" + this.getExpression() + ")";
    }

    static class TypedValueDeserializer
    extends JsonDeserializer<TypedValue> {
        TypedValueDeserializer() {
        }

        public TypedValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String text = p.getText();
            try {
                return TypedValue.from(text);
            }
            catch (IllegalArgumentException e) {
                return TypedValue.unparsed(text);
            }
        }
    }

    static class TypedValueSerializer
    extends JsonSerializer<TypedValue> {
        TypedValueSerializer() {
        }

        public void serialize(TypedValue value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.expression);
        }
    }
}

