/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.template.apikey;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.mixer.template.apikey.ApiKeySpec;
import me.snowdrop.istio.mixer.template.apikey.ApiKeySpecFluent;
import me.snowdrop.istio.mixer.template.apikey.ApiKeySpecFluentImpl;

public class ApiKeySpecBuilder
extends ApiKeySpecFluentImpl<ApiKeySpecBuilder>
implements VisitableBuilder<ApiKeySpec, ApiKeySpecBuilder> {
    ApiKeySpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ApiKeySpecBuilder() {
        this(true);
    }

    public ApiKeySpecBuilder(Boolean validationEnabled) {
        this(new ApiKeySpec(), validationEnabled);
    }

    public ApiKeySpecBuilder(ApiKeySpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ApiKeySpecBuilder(ApiKeySpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ApiKeySpec(), validationEnabled);
    }

    public ApiKeySpecBuilder(ApiKeySpecFluent<?> fluent, ApiKeySpec instance) {
        this(fluent, instance, true);
    }

    public ApiKeySpecBuilder(ApiKeySpecFluent<?> fluent, ApiKeySpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApi(instance.getApi());
        fluent.withApiKey(instance.getApiKey());
        fluent.withApiOperation(instance.getApiOperation());
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withName(instance.getName());
        fluent.withTimestamp(instance.getTimestamp());
        this.validationEnabled = validationEnabled;
    }

    public ApiKeySpecBuilder(ApiKeySpec instance) {
        this(instance, (Boolean)true);
    }

    public ApiKeySpecBuilder(ApiKeySpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApi(instance.getApi());
        this.withApiKey(instance.getApiKey());
        this.withApiOperation(instance.getApiOperation());
        this.withApiVersion(instance.getApiVersion());
        this.withName(instance.getName());
        this.withTimestamp(instance.getTimestamp());
        this.validationEnabled = validationEnabled;
    }

    public ApiKeySpecBuilder(Validator validator) {
        this(new ApiKeySpec(), (Boolean)true);
    }

    public ApiKeySpecBuilder(ApiKeySpecFluent<?> fluent, ApiKeySpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApi(instance.getApi());
        fluent.withApiKey(instance.getApiKey());
        fluent.withApiOperation(instance.getApiOperation());
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withName(instance.getName());
        fluent.withTimestamp(instance.getTimestamp());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ApiKeySpecBuilder(ApiKeySpec instance, Validator validator) {
        this.fluent = this;
        this.withApi(instance.getApi());
        this.withApiKey(instance.getApiKey());
        this.withApiOperation(instance.getApiOperation());
        this.withApiVersion(instance.getApiVersion());
        this.withName(instance.getName());
        this.withTimestamp(instance.getTimestamp());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ApiKeySpec build() {
        ApiKeySpec buildable = new ApiKeySpec(this.fluent.getApi(), this.fluent.getApiKey(), this.fluent.getApiOperation(), this.fluent.getApiVersion(), this.fluent.getName(), this.fluent.getTimestamp());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable, (Validator)this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApiKeySpecBuilder that = (ApiKeySpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

