/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.adapter.statsd;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.mixer.adapter.statsd.StatsdSpec;
import me.snowdrop.istio.mixer.adapter.statsd.StatsdSpecFluent;
import me.snowdrop.istio.mixer.adapter.statsd.StatsdSpecFluentImpl;

public class StatsdSpecBuilder
extends StatsdSpecFluentImpl<StatsdSpecBuilder>
implements VisitableBuilder<StatsdSpec, StatsdSpecBuilder> {
    StatsdSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public StatsdSpecBuilder() {
        this(true);
    }

    public StatsdSpecBuilder(Boolean validationEnabled) {
        this(new StatsdSpec(), validationEnabled);
    }

    public StatsdSpecBuilder(StatsdSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public StatsdSpecBuilder(StatsdSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StatsdSpec(), validationEnabled);
    }

    public StatsdSpecBuilder(StatsdSpecFluent<?> fluent, StatsdSpec instance) {
        this(fluent, instance, true);
    }

    public StatsdSpecBuilder(StatsdSpecFluent<?> fluent, StatsdSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAddress(instance.getAddress());
        fluent.withFlushBytes(instance.getFlushBytes());
        fluent.withFlushDuration(instance.getFlushDuration());
        fluent.withMetrics(instance.getMetrics());
        fluent.withPrefix(instance.getPrefix());
        fluent.withSamplingRate(instance.getSamplingRate());
        this.validationEnabled = validationEnabled;
    }

    public StatsdSpecBuilder(StatsdSpec instance) {
        this(instance, (Boolean)true);
    }

    public StatsdSpecBuilder(StatsdSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAddress(instance.getAddress());
        this.withFlushBytes(instance.getFlushBytes());
        this.withFlushDuration(instance.getFlushDuration());
        this.withMetrics(instance.getMetrics());
        this.withPrefix(instance.getPrefix());
        this.withSamplingRate(instance.getSamplingRate());
        this.validationEnabled = validationEnabled;
    }

    public StatsdSpecBuilder(Validator validator) {
        this(new StatsdSpec(), (Boolean)true);
    }

    public StatsdSpecBuilder(StatsdSpecFluent<?> fluent, StatsdSpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAddress(instance.getAddress());
        fluent.withFlushBytes(instance.getFlushBytes());
        fluent.withFlushDuration(instance.getFlushDuration());
        fluent.withMetrics(instance.getMetrics());
        fluent.withPrefix(instance.getPrefix());
        fluent.withSamplingRate(instance.getSamplingRate());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public StatsdSpecBuilder(StatsdSpec instance, Validator validator) {
        this.fluent = this;
        this.withAddress(instance.getAddress());
        this.withFlushBytes(instance.getFlushBytes());
        this.withFlushDuration(instance.getFlushDuration());
        this.withMetrics(instance.getMetrics());
        this.withPrefix(instance.getPrefix());
        this.withSamplingRate(instance.getSamplingRate());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public StatsdSpec build() {
        StatsdSpec buildable = new StatsdSpec(this.fluent.getAddress(), this.fluent.getFlushBytes(), this.fluent.getFlushDuration(), this.fluent.getMetrics(), this.fluent.getPrefix(), this.fluent.getSamplingRate());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable, (Validator)this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatsdSpecBuilder that = (StatsdSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

