/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.v4_2.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_2.Nested;
import io.fabric8.kubernetes.api.builder.v4_2.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.api.networking.v1alpha3.CaptureMode;
import me.snowdrop.istio.api.networking.v1alpha3.IstioEgressListener;
import me.snowdrop.istio.api.networking.v1alpha3.IstioEgressListenerFluent;
import me.snowdrop.istio.api.networking.v1alpha3.Port;
import me.snowdrop.istio.api.networking.v1alpha3.PortBuilder;
import me.snowdrop.istio.api.networking.v1alpha3.PortFluentImpl;

public class IstioEgressListenerFluentImpl<A extends IstioEgressListenerFluent<A>>
extends BaseFluent<A>
implements IstioEgressListenerFluent<A> {
    private String bind;
    private CaptureMode captureMode;
    private List<String> hosts;
    private PortBuilder port;

    public IstioEgressListenerFluentImpl() {
    }

    public IstioEgressListenerFluentImpl(IstioEgressListener instance) {
        this.withBind(instance.getBind());
        this.withCaptureMode(instance.getCaptureMode());
        this.withHosts(instance.getHosts());
        this.withPort(instance.getPort());
    }

    @Override
    public String getBind() {
        return this.bind;
    }

    @Override
    public A withBind(String bind) {
        this.bind = bind;
        return (A)this;
    }

    @Override
    public Boolean hasBind() {
        return this.bind != null;
    }

    @Override
    public A withNewBind(String arg1) {
        return this.withBind(new String(arg1));
    }

    @Override
    public A withNewBind(StringBuilder arg1) {
        return this.withBind(new String(arg1));
    }

    @Override
    public A withNewBind(StringBuffer arg1) {
        return this.withBind(new String(arg1));
    }

    @Override
    public CaptureMode getCaptureMode() {
        return this.captureMode;
    }

    @Override
    public A withCaptureMode(CaptureMode captureMode) {
        this.captureMode = captureMode;
        return (A)this;
    }

    @Override
    public Boolean hasCaptureMode() {
        return this.captureMode != null;
    }

    @Override
    public A addToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.add(index, item);
        return (A)this;
    }

    @Override
    public A setToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.set(index, item);
        return (A)this;
    }

    @Override
    public A addToHosts(String ... items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToHosts(Collection<String> items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromHosts(String ... items) {
        for (String item : items) {
            if (this.hosts == null) continue;
            this.hosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHosts(Collection<String> items) {
        for (String item : items) {
            if (this.hosts == null) continue;
            this.hosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getHosts() {
        return this.hosts;
    }

    @Override
    public String getHost(int index) {
        return this.hosts.get(index);
    }

    @Override
    public String getFirstHost() {
        return this.hosts.get(0);
    }

    @Override
    public String getLastHost() {
        return this.hosts.get(this.hosts.size() - 1);
    }

    @Override
    public String getMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHosts(List<String> hosts) {
        if (this.hosts != null) {
            this._visitables.get((Object)"hosts").removeAll(this.hosts);
        }
        if (hosts != null) {
            this.hosts = new ArrayList<String>();
            for (String item : hosts) {
                this.addToHosts(item);
            }
        } else {
            this.hosts = null;
        }
        return (A)this;
    }

    @Override
    public A withHosts(String ... hosts) {
        if (this.hosts != null) {
            this.hosts.clear();
        }
        if (hosts != null) {
            for (String item : hosts) {
                this.addToHosts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHosts() {
        return this.hosts != null && !this.hosts.isEmpty();
    }

    @Override
    public A addNewHost(String arg1) {
        return this.addToHosts(new String(arg1));
    }

    @Override
    public A addNewHost(StringBuilder arg1) {
        return this.addToHosts(new String(arg1));
    }

    @Override
    public A addNewHost(StringBuffer arg1) {
        return this.addToHosts(new String(arg1));
    }

    @Override
    @Deprecated
    public Port getPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public Port buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public A withPort(Port port) {
        this._visitables.get((Object)"port").remove(this.port);
        if (port != null) {
            this.port = new PortBuilder(port);
            this._visitables.get((Object)"port").add(this.port);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return this.port != null;
    }

    @Override
    public A withNewPort(String name, Integer number, String protocol) {
        return this.withPort(new Port(name, number, protocol));
    }

    @Override
    public IstioEgressListenerFluent.PortNested<A> withNewPort() {
        return new PortNestedImpl();
    }

    @Override
    public IstioEgressListenerFluent.PortNested<A> withNewPortLike(Port item) {
        return new PortNestedImpl(item);
    }

    @Override
    public IstioEgressListenerFluent.PortNested<A> editPort() {
        return this.withNewPortLike(this.getPort());
    }

    @Override
    public IstioEgressListenerFluent.PortNested<A> editOrNewPort() {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : new PortBuilder().build());
    }

    @Override
    public IstioEgressListenerFluent.PortNested<A> editOrNewPortLike(Port item) {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IstioEgressListenerFluentImpl that = (IstioEgressListenerFluentImpl)o;
        if (this.bind != null ? !this.bind.equals(that.bind) : that.bind != null) {
            return false;
        }
        if (this.captureMode != null ? !this.captureMode.equals((Object)that.captureMode) : that.captureMode != null) {
            return false;
        }
        if (this.hosts != null ? !this.hosts.equals(that.hosts) : that.hosts != null) {
            return false;
        }
        return !(this.port != null ? !this.port.equals(that.port) : that.port != null);
    }

    public class PortNestedImpl<N>
    extends PortFluentImpl<IstioEgressListenerFluent.PortNested<N>>
    implements IstioEgressListenerFluent.PortNested<N>,
    Nested<N> {
        private final PortBuilder builder;

        PortNestedImpl(Port item) {
            this.builder = new PortBuilder(this, item);
        }

        PortNestedImpl() {
            this.builder = new PortBuilder(this);
        }

        @Override
        public N and() {
            return (N)IstioEgressListenerFluentImpl.this.withPort(this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }
}

