/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.api.mesh.v1alpha1.ConfigSource;
import me.snowdrop.istio.api.mesh.v1alpha1.ConfigSourceFluent;
import me.snowdrop.istio.api.mesh.v1alpha1.ConfigSourceFluentImpl;

public class ConfigSourceBuilder
extends ConfigSourceFluentImpl<ConfigSourceBuilder>
implements VisitableBuilder<ConfigSource, ConfigSourceBuilder> {
    ConfigSourceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ConfigSourceBuilder() {
        this(true);
    }

    public ConfigSourceBuilder(Boolean validationEnabled) {
        this(new ConfigSource(), validationEnabled);
    }

    public ConfigSourceBuilder(ConfigSourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ConfigSourceBuilder(ConfigSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ConfigSource(), validationEnabled);
    }

    public ConfigSourceBuilder(ConfigSourceFluent<?> fluent, ConfigSource instance) {
        this(fluent, instance, true);
    }

    public ConfigSourceBuilder(ConfigSourceFluent<?> fluent, ConfigSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAddress(instance.getAddress());
        fluent.withTlsSettings(instance.getTlsSettings());
        this.validationEnabled = validationEnabled;
    }

    public ConfigSourceBuilder(ConfigSource instance) {
        this(instance, (Boolean)true);
    }

    public ConfigSourceBuilder(ConfigSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAddress(instance.getAddress());
        this.withTlsSettings(instance.getTlsSettings());
        this.validationEnabled = validationEnabled;
    }

    public ConfigSourceBuilder(Validator validator) {
        this(new ConfigSource(), (Boolean)true);
    }

    public ConfigSourceBuilder(ConfigSourceFluent<?> fluent, ConfigSource instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAddress(instance.getAddress());
        fluent.withTlsSettings(instance.getTlsSettings());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ConfigSourceBuilder(ConfigSource instance, Validator validator) {
        this.fluent = this;
        this.withAddress(instance.getAddress());
        this.withTlsSettings(instance.getTlsSettings());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ConfigSource build() {
        ConfigSource buildable = new ConfigSource(this.fluent.getAddress(), this.fluent.getTlsSettings());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable, (Validator)this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigSourceBuilder that = (ConfigSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

